/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package java.lang;

public class Runtime extends Object
{
    private static final Runtime instance;

    static {
        instance = new Runtime();
    }

    public static Runtime getRuntime() {
        return instance;
    }

    private final Thread interruptHandler;
    private final Object monitor;

    private Runtime() {
        Object monitor = new Object();
        ((Thread) (new GarbageCollectorThread(monitor))).start();
        this.interruptHandler = new InterruptHandlerThread();
        this.monitor = monitor;
    }

    public void startInterruptHandling() {
        interruptHandler.start();
    }

    public void gc() {
        Object monitor;
        synchronized(monitor = this.monitor)
        {
            monitor.notifyAll();
        }
    }

    public void exit(int status) {
        throw new SecurityException("Runtime.exit: спецификация MIDP не поддерживает выход с помощью Runtime.exit.");
    }

    public long freeMemory() {
        return (long) Memory.getFree();
    }

    public long totalMemory() {
        return (long) Memory.getTotal();
    }
}

final class GarbageCollectorThread extends Thread
{
    private final Object monitor;

    public GarbageCollectorThread(Object monitor) {
        super("Автоматический сборщик мусора");
        this.monitor = monitor;
    }

    public void run() {
        for(Object monitor = this.monitor; ; )
        {
            if(Memory.collectGarbage() > 0L) continue;
            synchronized(monitor)
            {
                try
                {
                    monitor.wait(1000L);
                }
                catch(InterruptedException e)
                {
                    e.printRealStackTrace();
                }
            }
        }
    }
}

final class InterruptHandlerThread extends Thread
{
    public InterruptHandlerThread() {
        super("Обработчик прерываний");
    }

    public void run() {
        for(MalikInterrupt.enable(); ; )
        {
            try
            {
                Thread.waitForInterrupt();
            }
            catch(InterruptedException e)
            {
                e.printRealStackTrace();
            }
        }
    }
}
