/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package java.util;

public class Random extends Object
{
    private static final long MULTIPLIER = 0x00000005deece66dL;
    private static final long ADDEND = 0x000000000000000bL;
    private static final long MASK = 0x0000ffffffffffffL;

    private long seed;

    public Random() {
        this.seed = (System.currentTimeMillis() ^ MULTIPLIER) & MASK;
    }

    public Random(long seed) {
        this.seed = (seed ^ MULTIPLIER) & MASK;
    }

    public synchronized void setSeed(long seed) {
        this.seed = (seed ^ MULTIPLIER) & MASK;
    }

    public float nextFloat() {
        return (float) next(24) / 16777216.f;
    }

    public double nextDouble() {
        return (double) (((long) next(26) << 27) + (long) next(27)) / 9007199254740992.d;
    }

    public int nextInt() {
        return next(32);
    }

    public int nextInt(int limit) {
        int bits;
        int result;
        if(limit <= 0)
        {
            throw new IllegalArgumentException("Random.nextInt: аргумент limit может быть только положительным.");
        }
        if((limit & -limit) == limit) return (int) (((long) limit * (long) next(31)) >> 31); /* limit является степенью двойки */
        do
        {
            result = (bits = next(31)) % limit;
        } while(bits - result + limit - 1 < 0);
        return result;
    }

    public long nextLong() {
        return ((long) next(32) << 32) + (long) next(32);
    }

    protected synchronized int next(int bits) {
        return (int) ((seed = (seed * MULTIPLIER + ADDEND) & MASK) >>> (48 - bits));
    }
}
