/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package java.util;

public class Stack extends Vector
{
    public Stack() {
    }

    public boolean empty() {
        return elementCount <= 0;
    }

    public int search(Object element) {
        int result;
        synchronized(monitor)
        {
            int i;
            result = (i = super.lastIndexOf(element)) >= 0 ? elementCount - i : -1;
        }
        return result;
    }

    public Object push(Object element) {
        super.addElement(element);
        return element;
    }

    public Object pop() {
        int error = 0;
        Object result;
        synchronized(monitor)
        {
            label0:
            {
                int c;
                Object[] d;
                if((c = elementCount) <= 0)
                {
                    error = 1;
                    result = null;
                    break label0;
                }
                result = (d = elementData)[--c];
                d[elementCount = c] = null;
            }
        }
        if(error == 1)
        {
            throw new EmptyStackException("Stack.pop: стак не содержит элементов.");
        }
        return result;
    }

    public Object peek() {
        int error = 0;
        Object result;
        synchronized(monitor)
        {
            label0:
            {
                int c;
                if((c = elementCount) <= 0)
                {
                    error = 1;
                    result = null;
                    break label0;
                }
                result = elementData[c - 1];
            }
        }
        if(error == 1)
        {
            throw new EmptyStackException("Stack.peek: стак не содержит элементов.");
        }
        return result;
    }
}
