/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package malik.emulator.io;

import java.io.*;
import malik.emulator.io.vfs.*;

public abstract class IOStream extends Object
{
    public IOStream() {
    }

    public abstract InputStream getInputStream() throws IOException;

    public abstract OutputStream getOutputStream() throws IOException;

    public void close() throws IOException {
    }

    public void resetInputStream() throws IOException {
        throw new PositionNotSupportedException("IOStream.resetInputStream: позиционирование не поддерживается.", null);
    }

    public void resetOutputStream() throws IOException {
        throw new PositionNotSupportedException("IOStream.resetOutputStream: позиционирование не поддерживается.", null);
    }

    public boolean truncateSupported() {
        return false;
    }

    public boolean positionSupported() {
        return false;
    }

    public long truncate() throws IOException {
        throw new TruncateNotSupportedException("IOStream.truncate: обрезка не поддерживается.", null);
    }

    public long position() throws IOException {
        return position(0L);
    }

    public long position(long delta) throws IOException {
        throw new PositionNotSupportedException("IOStream.position: позиционирование не поддерживается.", null);
    }
}
