/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package malik.emulator.media.graphics;

public class TextPaint extends Paint
{
    private boolean underline;
    private boolean strikeout;
    private SystemFont font;

    public TextPaint(int clipWidth, int clipHeight) {
        super(clipWidth, clipHeight);
    }

    public TextPaint(int clipWidth, int clipHeight, SystemFont font, boolean underline, boolean strikeout) {
        super(clipWidth, clipHeight);
        this.underline = underline;
        this.strikeout = strikeout;
        this.font = font;
    }

    public TextPaint(int clipWidth, int clipHeight, int colorARGB, boolean alpha) {
        super(clipWidth, clipHeight, colorARGB, alpha);
    }

    public TextPaint(int clipWidth, int clipHeight, int colorARGB, boolean alpha, SystemFont font, boolean underline, boolean strikeout) {
        super(clipWidth, clipHeight, colorARGB, alpha);
        this.underline = underline;
        this.strikeout = strikeout;
        this.font = font;
    }

    public TextPaint(int clipLeft, int clipTop, int clipWidth, int clipHeight) {
        super(clipLeft, clipTop, clipWidth, clipHeight);
    }

    public TextPaint(int clipLeft, int clipTop, int clipWidth, int clipHeight, SystemFont font, boolean underline, boolean strikeout) {
        super(clipLeft, clipTop, clipWidth, clipHeight);
        this.underline = underline;
        this.strikeout = strikeout;
        this.font = font;
    }

    public TextPaint(int clipLeft, int clipTop, int clipWidth, int clipHeight, int colorARGB, boolean alpha) {
        super(clipLeft, clipTop, clipWidth, clipHeight, colorARGB, alpha);
    }

    public TextPaint(int clipLeft, int clipTop, int clipWidth, int clipHeight, int colorARGB, boolean alpha, SystemFont font, boolean underline, boolean strikeout) {
        super(clipLeft, clipTop, clipWidth, clipHeight, colorARGB, alpha);
        this.underline = underline;
        this.strikeout = strikeout;
        this.font = font;
    }

    public TextPaint(int translateX, int translateY, int clipLeft, int clipTop, int clipWidth, int clipHeight) {
        super(translateX, translateY, clipLeft, clipTop, clipWidth, clipHeight);
    }

    public TextPaint(int translateX, int translateY, int clipLeft, int clipTop, int clipWidth, int clipHeight, SystemFont font, boolean underline, boolean strikeout) {
        super(translateX, translateY, clipLeft, clipTop, clipWidth, clipHeight);
        this.underline = underline;
        this.strikeout = strikeout;
        this.font = font;
    }

    public TextPaint(int translateX, int translateY, int clipLeft, int clipTop, int clipWidth, int clipHeight, int colorARGB, boolean alpha) {
        super(translateX, translateY, clipLeft, clipTop, clipWidth, clipHeight, colorARGB, alpha);
    }

    public TextPaint(int translateX, int translateY, int clipLeft, int clipTop, int clipWidth, int clipHeight, int colorARGB, boolean alpha, SystemFont font, boolean underline, boolean strikeout) {
        super(translateX, translateY, clipLeft, clipTop, clipWidth, clipHeight, colorARGB, alpha);
        this.underline = underline;
        this.strikeout = strikeout;
        this.font = font;
    }

    public void setUnderline(boolean underline) {
        this.underline = underline;
    }

    public void setStrikeout(boolean strikeout) {
        this.strikeout = strikeout;
    }

    public void setFont(SystemFont font) {
        this.font = font;
    }

    public void setFont(SystemFont font, boolean underline, boolean strikeout) {
        this.underline = underline;
        this.strikeout = strikeout;
        this.font = font;
    }

    public final boolean isUnderline() {
        return underline;
    }

    public final boolean isStrikeout() {
        return strikeout;
    }

    public final SystemFont getFont() {
        SystemFont result;
        return (result = font) == null ? SystemFont.getDefault() : result;
    }
}
