/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package malik.emulator.i18n.encoding;

public class ISO8859_5_Codec extends OneByteCodec
{
    public ISO8859_5_Codec() {
    }

    public int decode(int byteValue) {
        if(byteValue >= 0x00 && byteValue <= 0xa0 || byteValue == 0xad) return byteValue;
        if(byteValue == 0xf0) return 0x2116;
        if(byteValue == 0xfd) return 0x00a7;
        return byteValue + 0x0360;
    }

    public int encode(int charCode) {
        if(charCode >= 0x0000 && charCode <= 0x00a0 || charCode == 0x00ad) return charCode;
        if(charCode == 0x2116) return 0xf0;
        if(charCode == 0x00a7) return 0xfd;
        if(charCode >= 0x0401 && charCode <= 0x045f) return charCode - 0x0360;
        return '?';
    }
}
