/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package malik.emulator.i18n.encoding;

import java.io.*;
import malik.emulator.i18n.*;

public class OneByteReader extends MarkableStreamReader
{
    private final OneByteCodec decoder;

    public OneByteReader(OneByteCodec decoder) {
        super(new Object());
        if(decoder == null)
        {
            throw new NullPointerException("OneByteReader: аргумент decoder равен нулевой ссылке.");
        }
        this.decoder = decoder;
    }

    protected OneByteReader() {
        super(new Object());
        String name;
        this.decoder = OneByteCodec.get((name = getClass().getName()).substring(0, name.lastIndexOf('_') + 1).concat("Codec"));
    }

    public final int read() throws IOException {
        int result;
        InputStream stream = getInputStream();
        OneByteCodec decoder = this.decoder;
        synchronized(lock)
        {
            label0:
            {
                int b;
                if((b = stream.read()) < 0)
                {
                    result = -1;
                    break label0;
                }
                result = (char) decoder.decode(b & 0xff);
            }
        }
        return result;
    }

    public final int read(char[] dst) throws IOException {
        return super.read(dst);
    }

    public final int read(char[] dst, int offset, int length) throws IOException {
        int result;
        InputStream stream = getInputStream();
        OneByteCodec decoder = this.decoder;
        synchronized(lock)
        {
            label0: for(result = 0; result < length; result++)
            {
                int b;
                if((b = stream.read()) < 0)
                {
                    if(result == 0) result--;
                    break label0;
                }
                dst[offset + result] = (char) decoder.decode(b & 0xff);
            }
        }
        return result;
    }

    public final long skip(long quantity) throws IOException {
        long result;
        InputStream stream;
        if(quantity < 0L)
        {
            throw new IllegalArgumentException("Reader.skip: аргумент quantity не может быть отрицательным.");
        }
        if(quantity == 0L) return 0L;
        stream = getInputStream();
        synchronized(lock)
        {
            result = stream.skip(quantity);
        }
        return result;
    }
}
