/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package com.samsung.util;

import javax.microedition.lcdui.*;
import malik.emulator.microedition.lcdui.*;

public class SM extends Object
{
    private static final int MESSAGE_MAXIMUM_LENGTH = 80;

    String address;
    String text;

    public SM() {
        this.address = "";
        this.text = "";
    }

    public SM(String destAddress, String callbackAddress, String messageText) {
        if(destAddress == null)
        {
            throw new IllegalArgumentException("SM: аргумент destAddress равен нулевой ссылке.");
        }
        if(!InputStringBuilder.isConstraintsMatch(Input.PHONENUMBER, destAddress))
        {
            throw new IllegalArgumentException("SM: аргумент destAddress не является номером телефона.");
        }
        if((messageText == null ? messageText = "" : messageText).length() > MESSAGE_MAXIMUM_LENGTH)
        {
            throw new IllegalArgumentException("SM: аргумент messageText имеет длину больше " + MESSAGE_MAXIMUM_LENGTH + ".");
        }
        this.address = destAddress;
        this.text = messageText;
    }

    public void setData(String messageText) {
        if((messageText == null ? messageText = "" : messageText).length() > MESSAGE_MAXIMUM_LENGTH)
        {
            throw new IllegalArgumentException("SM.setData: аргумент messageText имеет длину больше " + MESSAGE_MAXIMUM_LENGTH + ".");
        }
        this.text = messageText;
    }

    public void setDestAddress(String destAddress) {
        if(destAddress == null)
        {
            throw new IllegalArgumentException("SM.setDestAddress: аргумент destAddress равен нулевой ссылке.");
        }
        if(!InputStringBuilder.isConstraintsMatch(Input.PHONENUMBER, destAddress))
        {
            throw new IllegalArgumentException("SM.setDestAddress: аргумент destAddress не является номером телефона.");
        }
        this.address = destAddress;
    }

    public void setCallbackAddress(String callbackAddress) {
    }

    public String getData() {
        return text;
    }

    public String getDestAddress() {
        return address;
    }

    public String getCallbackAddress() {
        return "";
    }
}
