/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package javax.microedition.io.file;

import java.io.*;
import java.util.*;
import javax.microedition.io.*;

public interface FileConnection extends StreamConnection
{
    public InputStream openInputStream() throws IOException;

    public DataInputStream openDataInputStream() throws IOException;

    public OutputStream openOutputStream() throws IOException;

    public DataOutputStream openDataOutputStream() throws IOException;

    public void mkdir() throws IOException;

    public void create() throws IOException;

    public void delete() throws IOException;

    public void rename(String newName) throws IOException;

    public void truncate(long position) throws IOException;

    public void setHidden(boolean hidden) throws IOException;

    public void setReadable(boolean readable) throws IOException;

    public void setWritable(boolean writable) throws IOException;

    public void setFileConnection(String objectName) throws IOException;

    public boolean exists();

    public boolean canRead();

    public boolean canWrite();

    public boolean isOpen();

    public boolean isHidden();

    public boolean isDirectory();

    public long usedSize();

    public long totalSize();

    public long availableSize();

    public long lastModified();

    public long fileSize() throws IOException;

    public long directorySize(boolean includeSubDirectories) throws IOException;

    public OutputStream openOutputStream(long position) throws IOException;

    public Enumeration list(String filter, boolean includeHidden) throws IOException;

    public Enumeration list() throws IOException;

    public String getName();

    public String getPath();

    public String getURL();
}
