/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package javax.microedition.lcdui;

public abstract class CustomScrollBar extends ScrollBar
{
    protected CustomScrollBar() {
    }

    protected CustomScrollBar(boolean visibility, int range, Object monitor) {
        super(visibility, range, monitor);
    }

    public abstract void repaint();

    public abstract int getPage();

    public int invalidatePosition() {
        int result;
        int page = getPage();
        synchronized(monitor)
        {
            int maximum = range - page;
            int newPosition = position;
            if(newPosition > maximum) newPosition = maximum;
            if(newPosition < 0) newPosition = 0;
            result = position = newPosition;
        }
        return result;
    }
}
