/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package malik.emulator.microedition.system.console;

import java.io.*;
import malik.emulator.microedition.system.*;
import malik.emulator.util.*;

public class PrintConsoleCommand extends ConsoleCommand
{
    private final boolean line;
    private final PrintStream output;

    public PrintConsoleCommand(String name, String help, PrintStream output, boolean line) {
        super(name, help);
        if(output == null)
        {
            throw new NullPointerException("PrintConsoleCommand: аргумент output равен нулевой ссылке.");
        }
        this.line = line;
        this.output = output;
    }

    protected void execute(String[] arguments, Console console) {
        boolean line = this.line;
        StringBuilder text = new StringBuilder();
        for(int lim = arguments.length - 1, i = 0; i <= lim; i++)
        {
            text.append(arguments[i]);
            if(line || i < lim) text.append('\n');
        }
        output.print(text.toString());
    }
}
