/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package javax.bluetooth;

import java.io.*;
import javax.microedition.io.*;

public class RemoteDevice extends Object
{
    public static RemoteDevice getRemoteDevice(Connection connection) throws IOException {
        if(connection == null)
        {
            throw new NullPointerException("RemoteDevice.getRemoteDevice: аргумент connection равен нулевой ссылке.");
        }
        throw new IllegalArgumentException("RemoteDevice.getRemoteDevice: аргумент connection не является соединением с устройством.");
    }

    private final String address;

    protected RemoteDevice(String address) {
        if(address == null)
        {
            throw new NullPointerException("RemoteDevice: аргумент address равен нулевой ссылке.");
        }
        if(address.length() != 12)
        {
            throw new IllegalArgumentException("RemoteDevice: аргумент address имеет недопустимое значение.");
        }
        for(int i = 12; i-- > 0; )
        {
            int digit = address.charAt(i);
            if((digit < '0' || digit > '9') && (digit < 'a' || digit > 'f') && (digit < 'A' || digit > 'F'))
            {
                throw new IllegalArgumentException("RemoteDevice: аргумент address имеет недопустимое значение.");
            }
        }
        this.address = address.toUpperCase();
    }

    public boolean equals(Object anot) {
        return anot instanceof RemoteDevice && ((RemoteDevice) anot).address.equals(address);
    }

    public int hashCode() {
        return address.hashCode();
    }

    public boolean authenticate() throws IOException {
        throw new ConnectionNotFoundException("RemoteDevice.authenticate: нет открытых соединений с устройством.");
    }

    public boolean authorize(Connection connection) throws IOException {
        throw new IllegalArgumentException("RemoteDevice.authorize: аргумент connection не является соединением с устройством.");
    }

    public boolean encrypt(Connection connection, boolean encrypted) throws IOException {
        throw new IllegalArgumentException("RemoteDevice.encrypt: аргумент connection не является соединением с устройством.");
    }

    public boolean isTrustedDevice() {
        return false;
    }

    public boolean isAuthenticated() {
        return false;
    }

    public boolean isAuthorized(Connection connection) throws IOException {
        throw new IllegalArgumentException("RemoteDevice.isAuthorized: аргумент connection не является соединением с устройством.");
    }

    public boolean isEncrypted() {
        return false;
    }

    public String getFriendlyName(boolean ask) throws IOException {
        throw new ConnectionNotFoundException("RemoteDevice.getFriendlyName: нет связи с устройством.");
    }

    public final String getBluetoothAddress() {
        return address;
    }
}
