{
    FileBrowsingWindow используется для создания окна, в котором пользователь
    смотрит файлы и папки на своём компьютере и выбирает один файл для обработки
    Малик Эмулятором.
    Этот исходный текст является частью Малик Эмулятора.

    Следующие файлы используются этим исходным текстом:
        filebrowsingwindow.lfm
    На них так же распространяются те же права, как и на этот исходный текст.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Малик Эмулятор – свободная программа: вы можете перераспространять её и/или
    изменять её на условиях Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Малик Эмулятор распространяется в надежде, что он может быть полезен,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЁННЫХ ЦЕЛЕЙ. Подробнее см. в Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <http://www.gnu.org/licenses/>.
}

unit FileBrowsingWindow;

{$MODE DELPHI}

interface

uses
    Classes,
    SysUtils,
    Forms,
    ShellCtrls,
    ExtCtrls,
    StdCtrls,
    ComCtrls,
    Lang,
    Manifests,
    StaticRecompilers,
    EmulatorInterfaces;

{%region public }
type
    TFileBrowser = class(TForm)
        viewPanel: TPanel;
        directoriesView: TShellTreeView;
        directoriesFilesSplitter: TSplitter;
        filesView: TShellListView;
        fileTypeLabel: TLabel;
        fileType: TComboBox;
        selectButton: TButton;
        cancelButton: TButton;
        procedure filesViewColumnClick(sender: TObject; column: TListColumn);
        procedure filesViewSelectItem(sender: TObject; item: TListItem; selected: boolean);
        procedure fileTypeChange(sender: TObject);
    private
        owner: MainWindowInterface;
        fileName: AnsiString;
    public
        constructor create(theOwner: TComponent); override;
        procedure afterConstruction(); override;
        procedure beforeDestruction(); override;
        function getFileName(): AnsiString;
    end;
{%endregion}

implementation

{$R *.LFM}

{%region TFileBrowser }
    constructor TFileBrowser.create(theOwner: TComponent);
    begin
        inherited create(theOwner);
        theOwner.getInterface(stringToGUID(MAIN_WINDOW_INTERFACE_GUID), owner);
    end;

    procedure TFileBrowser.filesViewSelectItem(sender: TObject; item: TListItem; selected: boolean);
    var
        f: boolean;
    begin
        f := (item <> nil) and selected;
        selectButton.enabled := f;
        if f then begin
            fileName := filesView.getPathFromItem(item);
        end else begin
            fileName := '';
        end;
    end;

    procedure TFileBrowser.filesViewColumnClick(sender: TObject; column: TListColumn);
    var
        index: int;
        view: TShellListView;
    begin
        view := TShellListView(sender);
        index := column.index;
        if view.sortColumn <> index then begin
            view.sortType := TSortType.stText;
            view.sortColumn := index;
        end;
    end;

    procedure TFileBrowser.fileTypeChange(sender: TObject);
    begin
        filesView.mask := '*.' + getRecompiler(fileType.itemIndex).getArchiveExtension();
    end;

    procedure TFileBrowser.afterConstruction();
    var
        i: int;
        r: StaticRecompiler;
        s: TStrings;
        sizes: AnsiString_Array1d;
    begin
        inherited afterConstruction();
        sizes := getComponents(owner.getSetting(SECTION_WINDOWS, KEY_FILE_BROWSER, toDecString(width) + ',' + toDecString(height) + ',' + toDecString(directoriesView.width)));
        if length(sizes) >= 2 then begin
            width := parseDecInt(sizes[0], width);
            height := parseDecInt(sizes[1], height);
        end;
        if length(sizes) >= 3 then begin
            directoriesView.width := parseDecInt(sizes[2], directoriesView.width);
        end;
        for i := -1 to 23 do begin
            try
                if i = -1 then begin
                    directoriesView.path := owner.getSetting(SECTION_CONTENT, KEY_FILE_BROWSER, '');
                    break;
                end;
                directoriesView.path := char(int('C') + i) + (':' + DIRECTORY_SEPARATOR);
                break;
            except
                on e: EInvalidPath do begin
                    continue;
                end;
            end;
        end;
        filesView.column[0].caption := 'Имя';
        filesView.column[1].caption := 'Размер';
        filesView.column[2].caption := 'Тип';
        s := fileType.items;
        for i := 0 to getRecompilersCount() - 1 do begin
            r := getRecompiler(i);
            s.add(r.getArchiveTypeName() + ' (.' + r.getArchiveExtension() + ')');
        end;
        fileType.itemIndex := 0;
        fileTypeChange(fileType);
    end;

    procedure TFileBrowser.beforeDestruction();
    begin
        owner.setSetting(SECTION_WINDOWS, KEY_FILE_BROWSER, toDecString(width) + ',' + toDecString(height) + ',' + toDecString(directoriesView.width));
        owner.setSetting(SECTION_CONTENT, KEY_FILE_BROWSER, directoriesView.path);
        inherited beforeDestruction();
    end;

    function TFileBrowser.getFileName(): AnsiString;
    begin
        result := fileName;
    end;
{%endregion}

end.

