{
    InvisibleWindow используется для создания невидимого окна в качестве главного.

    Следующие файлы используются этим исходным текстом:
        invisiblewindow.lfm
    На них так же распространяются те же права, как и на этот исходный текст.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять её и/или
    изменять её на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она может быть полезна,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЁННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <http://www.gnu.org/licenses/>.
}

unit InvisibleWindow;

{$MODE DELPHI}

interface

uses
    Forms,
    ExtCtrls;

{%region public }
type
    TInvisibleForm = class(TForm)
        start: TTimer;
        procedure formClose(sender: TObject; var action: TCloseAction);
        procedure startTimer(sender: TObject);

    strict private
        INSTANCE: TInvisibleForm; static;
    public
        class procedure createInstance();
    end;
{%endregion}

implementation

{$R *.LFM}

{%region TInvisibleForm }
    class procedure TInvisibleForm.createInstance();
    begin
        if INSTANCE = nil then begin
            application.createForm(self, INSTANCE);
        end;
    end;

    procedure TInvisibleForm.formClose(sender: TObject; var action: TCloseAction);
    begin
        action := caHide;
    end;

    procedure TInvisibleForm.startTimer(sender: TObject);
    begin
        close();
        start.enabled := false;
    end;
{%endregion}

end.

