/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package javax.bluetooth;

public class DeviceClass extends Object
{
	private static final int SERVICE = 0xffe000;
	private static final int MAJOR = 0x001f00;
	private static final int MINOR = 0x0000fc;


	private int record;

	public DeviceClass(int record)
	{
		if((record & 0xff000000) != 0)
		{
			throw new IllegalArgumentException("DeviceClass: " +
					"недопустимое значение параметра record.");
		}
		this.record = record;
	}

	public int getServiceClasses()
	{
		return record & SERVICE;
	}

	public int getMajorDeviceClass()
	{
		return record & MAJOR;
	}

	public int getMinorDeviceClass()
	{
		return record & MINOR;
	}
}
