/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package javax.bluetooth;

public interface DiscoveryListener
{
	public static final int INQUIRY_COMPLETED = 0;
	public static final int SERVICE_SEARCH_COMPLETED = 1;
	public static final int SERVICE_SEARCH_TERMINATED = 2;
	public static final int SERVICE_SEARCH_ERROR = 3;
	public static final int SERVICE_SEARCH_NO_RECORDS = 4;
	public static final int INQUIRY_TERMINATED = 5;
	public static final int SERVICE_SEARCH_DEVICE_NOT_REACHABLE = 6;
	public static final int INQUIRY_ERROR = 7;

	public void deviceDiscovered(RemoteDevice deviceInfo, DeviceClass deviceClass);

	public void servicesDiscovered(int transactionID, ServiceRecord[] services);

	public void serviceSearchCompleted(int transactionID, int response);

	public void inquiryCompleted(int request);
}
