/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package javax.bluetooth;

public class UUID extends Object
{
	public static char getDigitRepresentation(int digit)
	{
		if(digit >= 0 && digit < 10)
		{
			return (char) (digit + '0');
		}
		if(digit >= 0x0a && digit < Character.MAX_RADIX)
		{
			return (char) (digit + ('a' - 0x0a));
		}
		throw new ArrayIndexOutOfBoundsException(digit);
	}


	private long low64bit;
	private long high64bit;

	public UUID(long value)
	{
		if(value < 0L || value > 0xffffffffL)
		{
			throw new IllegalArgumentException("UUID: " +
					"недопустимое значение параметра value.");
		}
		this.low64bit = value;
		this.high64bit = 0L;
	}

	public UUID(String value, boolean shortType)
	{
		char c;
		int i;
		int j;
		int d;
		int len;
		long low64bit;
		long high64bit;
		char[] ac;
		if(value == null)
		{
			throw new NullPointerException("UUID: " +
					"параметр value равен нулевой ссылке.");
		}
		if((len = value.length()) <= 0 || len > (shortType ? 8 : 32))
		{
			throw new IllegalArgumentException("UUID: " +
					"параметр value имеет очень большую длину.");
		}
		for(ac = value.toCharArray(), low64bit = high64bit = 0L, j = 0, i = len; i-- > 0; j += 4)
		{
			if(((c = ac[i]) < '0' || c > '9') && (c < 'A' || c > 'F') && (c < 'a' || c > 'f'))
			{
				throw new NumberFormatException("UUID: " +
						"параметр value может состоять только из символов 0-9, A-F, a-f.");
			}
			d = c >= 'A' && c <= 'F' ? c - ('A' - 0x0a) :
					(c >= 'a' && c <= 'f' ? c - ('a' - 0x0a) : c - '0');
			if(j >= 16)
			{
				high64bit |= ((long) d) << (j - 16);
			} else
			{
				low64bit |= ((long) d) << j;
			}
		}
		this.low64bit = low64bit;
		this.high64bit = high64bit;
	}

	public boolean equals(Object ref)
	{
		UUID other;
		return ref == this || ref instanceof UUID &&
				low64bit == (other = (UUID) ref).low64bit && high64bit == other.high64bit;
	}

	public int hashCode()
	{
		long tmp;
		return ((int) (tmp = low64bit)) ^ ((int) (tmp >> 32)) ^
				((int) (tmp = high64bit)) ^ ((int) (tmp >> 32));
	}

	public String toString()
	{
		int i;
		int len = i = 0x20;
		long qword0 = low64bit;
		long qword1 = high64bit;
		char[] buf = new char[len];
		do
		{
			buf[--i] = Character.toUpperCase(getDigitRepresentation(((int) qword0) & 0x0f));
		} while((qword0 = (qword0 >>> 4) | (qword1 << 60)) != 0L | (qword1 >>>= 4) != 0L);
		return new String(buf, i, len - i);
	}

	public final boolean isRealEquals(UUID other)
	{
		return other != null &&
				this.low64bit == other.low64bit &&
				this.high64bit == other.high64bit;
	}

	public final long getLow64bit()
	{
		return low64bit;
	}

	public final long getHigh64bit()
	{
		return high64bit;
	}
}
