/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package java.io;

import malik.emulator.i18n.*;

public class InputStreamReader extends Reader
{
	private Reader reader;

	public InputStreamReader(InputStream stream)
	{
		if(stream == null)
		{
			throw new NullPointerException("InputStreamReader: " +
					"параметр stream равен нулевой ссылке.");
		}
		this.reader = Helper.getStreamReader(stream);
	}

	public InputStreamReader(InputStream stream, String encoding)
			throws UnsupportedEncodingException
	{
		if(stream == null)
		{
			throw new NullPointerException("InputStreamReader: " +
					"параметр stream равен нулевой ссылке.");
		}
		this.reader = Helper.getStreamReader(stream, encoding);
	}

	public void close()
			throws IOException
	{
		Reader reader;
		if((reader = this.reader) == null)
		{
			return;
		}
		this.reader = null;
		this.lock = null;
		reader.close();
	}

	public void reset()
			throws IOException
	{
		ensureOpen().reset();
	}

	public void mark(int readLimit)
			throws IOException
	{
		Reader reader;
		if(!(reader = ensureOpen()).markSupported())
		{
			throw new IOException("InputStreamReader.mark: " +
					"класс " + reader.getClass().getName() + " не поддерживает метод mark.");
		}
		reader.mark(readLimit);
	}

	public boolean markSupported()
	{
		Reader reader;
		return (reader = this.reader) != null && reader.markSupported();
	}

	public boolean ready()
			throws IOException
	{
		return ensureOpen().ready();
	}

	public int read()
			throws IOException
	{
		return ensureOpen().read();
	}

	public int read(char[] dst)
			throws IOException
	{
		if(dst == null)
		{
			throw new NullPointerException("InputStreamReader.read: " +
					"параметр dst равен нулевой ссылке.");
		}
		return ensureOpen().read(dst);
	}

	public int read(char[] dst, int offset, int length)
			throws IOException
	{
		int lim;
		int len;
		if(dst == null)
		{
			throw new NullPointerException("InputStreamReader.read: " +
					"параметр dst равен нулевой ссылке.");
		}
		if((lim = offset + length) > (len = dst.length) ||
				lim < offset || offset > len || offset < 0)
		{
			throw new ArrayIndexOutOfBoundsException("InputStreamReader.read: " +
					"индекс выходит из диапазона.");
		}
		return ensureOpen().read(dst, offset, length);
	}

	public long skip(long charsCount)
			throws IOException
	{
		return ensureOpen().skip(charsCount);
	}

	private Reader ensureOpen()
			throws IOException
	{
		Reader result;
		if((result = reader) == null)
		{
			throw new IOException("InputStreamReader: " +
					"символьный поток закрыт.");
		}
		return result;
	}
}
