/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package java.lang;

public final class Math extends Object
{
	public static final double E = 2.71828182845904524d;
	public static final double PI = 3.14159265358979324d;
	private static final int FLOAT_NEGATIVE_ZERO_BITS = -1 << 31;
	private static final long DOUBLE_NEGATIVE_ZERO_BITS = -1L << 63;

	public static float abs(float x)
	{
		return Float.intBitsToFloat(Float.floatToIntBits(x) & Integer.MAX_VALUE);
	}

	public static float max(float x, float y)
	{
		return x != x ? x : y != y ? y : x == 0.f && y == 0.f && Float.floatToIntBits(x) == FLOAT_NEGATIVE_ZERO_BITS || x < y ? y : x;
	}

	public static float min(float x, float y)
	{
		return x != x ? x : y != y ? y : x == 0.f && y == 0.f && Float.floatToIntBits(y) == FLOAT_NEGATIVE_ZERO_BITS || x > y ? y : x;
	}

	public static double abs(double x)
	{
		return Double.longBitsToDouble(Double.doubleToLongBits(x) & Long.MAX_VALUE);
	}

	public static double max(double x, double y)
	{
		return x != x ? x : y != y ? y : x == 0.d && y == 0.d && Double.doubleToLongBits(x) == DOUBLE_NEGATIVE_ZERO_BITS || x < y ? y : x;
	}

	public static double min(double x, double y)
	{
		return x != x ? x : y != y ? y : x == 0.d && y == 0.d && Double.doubleToLongBits(y) == DOUBLE_NEGATIVE_ZERO_BITS || x > y ? y : x;
	}

	public static double toDegrees(double angleInRadians)
	{
		return angleInRadians * (180.d / PI);
	}

	public static double toRadians(double angleInDegrees)
	{
		return angleInDegrees / (180.d / PI);
	}

	public static double tan(double x)
	{
		return sin(x) / cos(x);
	}

	public static native double intPart(double x);

	public static native double fracPart(double x);

	public static native double sqrt(double x);

	public static native double arctan(double y, double x);

	public static native double sin(double x);

	public static native double cos(double x);

	public static native double pow2(double x);

	public static native double log2(double x);

	public static native double floor(double x);

	public static native double ceil(double x);

	public static int abs(int x)
	{
		return x >= 0 ? x : -x;
	}

	public static int max(int x, int y)
	{
		return x >= y ? x : y;
	}

	public static int min(int x, int y)
	{
		return x <= y ? x : y;
	}

	public static long abs(long x)
	{
		return x >= 0L ? x : -x;
	}

	public static long max(long x, long y)
	{
		return x >= y ? x : y;
	}

	public static long min(long x, long y)
	{
		return x <= y ? x : y;
	}

	public static native long round(double x);


	private Math()
	{
	}
}
