/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package javax.microedition.lcdui;

public abstract class Screen extends Displayable
{
	Screen(boolean system, boolean fullScreenMode, String title, Ticker ticker,
			Command[] commands, Command defaultCommand, CommandListener listener)
	{
		super(system, fullScreenMode, title, ticker, commands, defaultCommand, listener);
	}

	abstract void paint(Graphics render);

	int getMarginLeft()
	{
		return 0;
	}

	int getMarginTop()
	{
		return 3;
	}

	int getMarginRight()
	{
		return 0;
	}

	int getMarginBottom()
	{
		return 3;
	}

	final int getClientLeft()
	{
		return super.getClientLeft() + getMarginLeft();
	}

	final int getClientTop()
	{
		return super.getClientTop() + getMarginTop();
	}

	final int getClientWidth()
	{
		return super.getClientWidth() - (getMarginLeft() + getMarginRight());
	}

	final int getClientHeight()
	{
		return super.getClientHeight() - (getClientTop() + getMarginBottom());
	}
}
