/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package javax.microedition.lcdui;

public class ScrollBarDefault extends Object
		implements ScrollBarStyle
{
	private static final int DEFAULT_SIZE = 11;
	private static final int TRACK_MARGIN_FROM_ENDS = 1;
	private static final int TRACK_MARGIN_FROM_EDGE = 3;
	private static final int SLIDER_MARGIN_FROM_EDGE = 2;
	private static final int SLIDER_MINIMAL_LENGTH = 7;
	private static final int[] TRACK_COLORS;
	private static final int[] SLIDER_MARGINS_COLORS;

	static
	{
		TRACK_COLORS = new int[] {
				0x60609f, 0x7a7aaf, 0x9595bf, 0xafafcf
		};
		SLIDER_MARGINS_COLORS = new int[] {
				0x02ffffff, 0x01f3f3f3, 0x00e7e7e7, 0x00dbdbdb, 0x00cfcfcf, 0x01c3c3c3, 0x02b7b7b7
		};
	}


	private int prev;

	public ScrollBarDefault()
	{
	}

	public void paintHorzScrollBar(Graphics render, ScrollBar scrollbar, int length, int width)
	{
		int a;
		int b;
		int c;
		int i;
		int j;
		int page;
		int range;
		render.translate(0, (width - DEFAULT_SIZE) / 2);
		render.clipRect(0, 0, length, DEFAULT_SIZE);
		b = length - ((a = TRACK_MARGIN_FROM_ENDS) + 1);
		for(j = (i = TRACK_COLORS.length) + TRACK_MARGIN_FROM_EDGE; i-- > 0; )
		{
			j--;
			render.setColor(TRACK_COLORS[i]);
			render.drawLine(a, j, b, j);
		}
		if((range = scrollbar.getRange()) <= 0 || (page = scrollbar.getPage()) <= 0 ||
				range <= page)
		{
			return;
		}
		b = (a = ScrollBarPaintHelper.getSliderPosition(scrollbar.getPosition(), page, range,
				length, b = ScrollBarPaintHelper.getSliderLength(page, range,
				length, SLIDER_MINIMAL_LENGTH))) + b - 1;
		for(j = (i = SLIDER_MARGINS_COLORS.length) + SLIDER_MARGIN_FROM_EDGE; i-- > 0; )
		{
			j--;
			render.setColor(c = SLIDER_MARGINS_COLORS[i]);
			render.drawLine(a + (c >>= 24), j, b - c, j);
		}
	}

	public void paintVertScrollBar(Graphics render, ScrollBar scrollbar, int length, int width)
	{
		int a;
		int b;
		int c;
		int i;
		int j;
		int page;
		int range;
		render.translate((width - DEFAULT_SIZE) / 2, 0);
		render.clipRect(0, 0, DEFAULT_SIZE, length);
		b = length - ((a = TRACK_MARGIN_FROM_ENDS) + 1);
		for(j = (i = TRACK_COLORS.length) + TRACK_MARGIN_FROM_EDGE; i-- > 0; )
		{
			j--;
			render.setColor(TRACK_COLORS[i]);
			render.drawLine(j, a, j, b);
		}
		if((range = scrollbar.getRange()) <= 0 || (page = scrollbar.getPage()) <= 0 ||
				range <= page)
		{
			return;
		}
		b = (a = ScrollBarPaintHelper.getSliderPosition(scrollbar.getPosition(), page, range,
				length, b = ScrollBarPaintHelper.getSliderLength(page, range,
				length, SLIDER_MINIMAL_LENGTH))) + b - 1;
		for(j = (i = SLIDER_MARGINS_COLORS.length) + SLIDER_MARGIN_FROM_EDGE; i-- > 0; )
		{
			j--;
			render.setColor(c = SLIDER_MARGINS_COLORS[i]);
			render.drawLine(j, a + (c >>= 24), j, b - c);
		}
	}

	public void onHorzScrollBarPointerPressed(ScrollBar scrollbar, int length, int width,
			int x, int y, int button)
	{
		int a;
		int b;
		int page;
		int range;
		if((range = scrollbar.getRange()) <= 0 || (page = scrollbar.getPage()) <= 0 ||
				range <= page)
		{
			prev = Integer.MAX_VALUE;
			return;
		}
		b = (a = ScrollBarPaintHelper.getSliderPosition(scrollbar.getPosition(), page, range,
				length, b = ScrollBarPaintHelper.getSliderLength(page, range,
				length, SLIDER_MINIMAL_LENGTH))) + b;
		if(x < a)
		{
			prev = Integer.MAX_VALUE;
			scrollbar.scroll(-page);
			return;
		}
		if(x >= b)
		{
			prev = Integer.MAX_VALUE;
			scrollbar.scroll(page);
			return;
		}
		prev = x;
	}

	public void onHorzScrollBarPointerDragged(ScrollBar scrollbar, int length, int width,
			int x, int y)
	{
		int p;
		int page;
		int range;
		if((range = scrollbar.getRange()) <= 0 || (page = scrollbar.getPage()) <= 0 ||
				range <= page || (p = prev) == Integer.MAX_VALUE)
		{
			return;
		}
		scrollbar.scroll((int) (((double) (x - p)) * ((double) range) / ((double) length)));
		prev = x;
	}

	public void onHorzScrollBarPointerReleased(ScrollBar scrollbar, int length, int width,
			int x, int y, int button)
	{
		int p;
		int page;
		int range;
		if((range = scrollbar.getRange()) <= 0 || (page = scrollbar.getPage()) <= 0 ||
				range <= page || (p = prev) == Integer.MAX_VALUE)
		{
			return;
		}
		scrollbar.scroll((int) (((double) (x - p)) * ((double) range) / ((double) length)));
	}

	public void onVertScrollBarPointerPressed(ScrollBar scrollbar, int length, int width,
			int x, int y, int button)
	{
		int a;
		int b;
		int page;
		int range;
		if((range = scrollbar.getRange()) <= 0 || (page = scrollbar.getPage()) <= 0 ||
				range <= page)
		{
			prev = Integer.MAX_VALUE;
			return;
		}
		b = (a = ScrollBarPaintHelper.getSliderPosition(scrollbar.getPosition(), page, range,
				length, b = ScrollBarPaintHelper.getSliderLength(page, range,
				length, SLIDER_MINIMAL_LENGTH))) + b;
		if(y < a)
		{
			prev = Integer.MAX_VALUE;
			scrollbar.scroll(-page);
			return;
		}
		if(y >= b)
		{
			prev = Integer.MAX_VALUE;
			scrollbar.scroll(page);
			return;
		}
		prev = y;
	}

	public void onVertScrollBarPointerDragged(ScrollBar scrollbar, int length, int width,
			int x, int y)
	{
		int p;
		int page;
		int range;
		if((range = scrollbar.getRange()) <= 0 || (page = scrollbar.getPage()) <= 0 ||
				range <= page || (p = prev) == Integer.MAX_VALUE)
		{
			return;
		}
		scrollbar.scroll((int) (((double) (y - p)) * ((double) range) / ((double) length)));
		prev = y;
	}

	public void onVertScrollBarPointerReleased(ScrollBar scrollbar, int length, int width,
			int x, int y, int button)
	{
		int p;
		int page;
		int range;
		if((range = scrollbar.getRange()) <= 0 || (page = scrollbar.getPage()) <= 0 ||
				range <= page || (p = prev) == Integer.MAX_VALUE)
		{
			return;
		}
		scrollbar.scroll((int) (((double) (y - p)) * ((double) range) / ((double) length)));
	}

	public int getHorzScrollBarWidth()
	{
		return DEFAULT_SIZE;
	}

	public int getVertScrollBarWidth()
	{
		return DEFAULT_SIZE;
	}
}
