/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package javax.microedition.media.control;

import javax.microedition.media.*;

public interface MIDIControl
		extends Control
{
	public static final int NOTE_ON = 0x90;
	public static final int CONTROL_CHANGE = 0xb0;

	public void shortMidiEvent(int statusByte, int dataByte1, int dataByte2);

	public void setChannelVolume(int channel, int volume);

	public void setProgram(int channel, int bank, int programme);

	public boolean isBankQuerySupported();

	public int longMidiEvent(byte[] src, int offset, int length);

	public int getChannelVolume(int channel);

	public int[] getBankList(boolean custom)
			throws MediaException;

	public int[] getProgram(int channel)
			throws MediaException;

	public int[] getProgramList(int bank)
			throws MediaException;

	public String getProgramName(int bank, int programme)
			throws MediaException;

	public String getKeyName(int bank, int programme, int key)
			throws MediaException;
}
