/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package javax.microedition.midlet;

public final class MIDletDispatcher extends Object
{
	private boolean mustDestroyed;
	private MIDlet midlet;
	private Class midletClass;
	private Exception cause;

	public MIDletDispatcher(Class midletClass)
	{
		this.midletClass = midletClass;
	}

	public void startMIDlet()
	{
		int i;
		MIDlet midlet;
		Class midletClass;
		try
		{
			/* Создание инстанции мидлета */
			if(!Class.forName("javax.microedition.midlet.MIDlet").
					isAssignableFrom(midletClass = this.midletClass))
			{
				throw new IllegalMIDletClassNameException("MIDlet: " +
						"класс " + midletClass.getCanonicalName() +
						(" не унаследован от javax.microedition.midlet.MIDlet - " +
						"запуск мидлета невозможен."));
			}
			this.midlet = midlet = (MIDlet) midletClass.newInstance();

			/* Попытка запустить мидлет */
			for(i = 4 /* <-- количество попыток */; i > 0; i--)
			{
				try
				{
					midlet.startApp();
					break;
				}
				catch(MIDletStateChangeException e)
				{
					e.printRealStackTrace();
					midlet.pauseApp();
					Thread.sleep(1000L);
				}
			}
			if(i == 0)
			{
				throw new MIDletStateChangeException("MIDlet: " +
						"несколько попыток запустить мидлет - " +
						"возбуждение исключения MIDletStateChangeException.");
			}
		}
		catch(Exception e)
		{
			e.printRealStackTrace();
			mustDestroyed = true;
			cause = e;
		}
	}

	public void stopMIDlet()
	{
		/* Вызывается системой, чтобы принудительно завершить работу мидлета */
		MIDlet midlet;
		if((midlet = this.midlet) == null)
		{
			return;
		}
		try
		{
			midlet.destroyApp(true);
		}
		catch(Exception e)
		{
			e.printRealStackTrace();
		}
	}

	public boolean mustDestroyed()
	{
		return mustDestroyed;
	}

	public Class getMIDletClass()
	{
		return midletClass;
	}

	public Exception getCause()
	{
		return cause;
	}
}
