/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.midp;

import java.lang.ref.*;

public abstract class ConsoleCommand extends Object
{
	private boolean hide;
	private String name;
	private String help;
	private Reference console;

	protected ConsoleCommand(String name, String help)
	{
		this.name = name;
		this.help = help;
	}

	ConsoleCommand(String name)
	{
		this.hide = true;
		this.name = name;
	}

	public abstract void run(String[] arguments);

	public final String getName()
	{
		return name;
	}

	public final String getHelp()
	{
		return help;
	}

	public final ConsoleScreen getConsoleScreen()
	{
		Reference ref;
		return (ref = console) == null ? null : (ConsoleScreen) ref.get();
	}

	final void setConsoleScreen(Reference console)
	{
		this.console = console;
	}

	final boolean isHide()
	{
		return hide;
	}
}
