/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.midp.console;

import java.io.*;
import javax.wireless.messaging.*;
import malik.emulator.io.j2me.*;
import malik.emulator.midp.*;
import malik.emulator.midp.protocol.*;

public class MessageCommand extends ConsoleCommand
{
	public MessageCommand()
	{
		super("смс",
				"Использование:\n" +
				"  смс \"<текст>\"\n" +
				"  смс :<порт> \"<текст>\"\n" +
				"Отправляет текстовое сообщение на указанный порт. Номер порта должен быть в " +
				"диапазоне от 0 до 65535. Если номер порта не указан или указан неверно, то " +
				"используется порт " +
				SupportedConnections.DEFAULT_PORT_FOR_RECEIVE_WIRELESS_MESSAGES +
				", который всегда прослушивается. " +
				"Если приложение слушает указанный порт, то оно примет это сообщение.");
	}

	public void run(String[] arguments)
	{
		int len;
		int port;
		String text;
		String portArg;
		TextMessage messageForSend;
		MessageConnection defaultMessagePort;
		if((len = arguments.length) <= 0)
		{
			return;
		}
		defaultMessagePort = (MessageConnection) ImplementationManager.getConnectionFactory().
				getInboundConnection("sms",
				SupportedConnections.DEFAULT_PORT_FOR_RECEIVE_WIRELESS_MESSAGES);
		if(len >= 2 && (portArg = arguments[0]) != null && portArg.length() >= 2 &&
				portArg.charAt(0) == ':')
		{
			text = arguments[1];
			try
			{
				if((port = Integer.parseInt(portArg.substring(1))) < 0x0000 || port > 0xffff)
				{
					port = SupportedConnections.DEFAULT_PORT_FOR_RECEIVE_WIRELESS_MESSAGES;
				}
			}
			catch(NumberFormatException e)
			{
				port = SupportedConnections.DEFAULT_PORT_FOR_RECEIVE_WIRELESS_MESSAGES;
			}
		} else
		{
			text = arguments[0];
			port = SupportedConnections.DEFAULT_PORT_FOR_RECEIVE_WIRELESS_MESSAGES;
		}
		(messageForSend = (TextMessage) defaultMessagePort.newMessage(
				MessageConnection.TEXT_MESSAGE, "sms://:" + port)).setPayloadText(text);
		try
		{
			defaultMessagePort.send(messageForSend);
		}
		catch(IOException e)
		{
			e.printRealStackTrace();
		}
	}
}
