/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.midp.image;

import java.io.*;
import malik.emulator.fileformats.*;
import malik.emulator.fileformats.graphics.*;
import malik.emulator.fileformats.graphics.pnglib.*;
import malik.emulator.io.j2me.*;

public class SupportedImageFormats extends Object
		implements VirtualImageDecoder
{
	public SupportedImageFormats()
	{
	}

	public ImageDecoder getImageDecoder(InputStream src)
			throws IOException
	{
		long signature;
		DataInputStream stream = new DataInputStream(src);
		
		/* PNG */
		if(PNGDecoder.PNG_SIGNATURE == (signature = stream.readLong()))
		{
			return new PNGDecoder();
		}

		/* неизвестный формат */
		throw new InvalidDataFormatException("Неизвестный формат изображения (сигнатура " +
				Long.toString(signature, 16) + ").");
	}
}
