/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.midp.protocol.sms;

import java.io.*;
import java.util.*;
import javax.wireless.messaging.*;
import malik.emulator.io.j2me.*;

public class ClientMessageConnection extends CustomConnection
		implements MessageConnection
{
	private static final int MAXIMUM_MESSAGE_LENGTH = 0x0400;


	QueueOfObjects outgoingMessages;

	public ClientMessageConnection(String url)
	{
		super(url);
		this.outgoingMessages = new QueueOfObjects(4);
	}

	public void setMessageListener(MessageListener listener)
			throws IOException
	{
		if(closed)
		{
			throw new IOException("MessageConnection.setMessageListener: " +
					"соединение закрыто.");
		}
		throw new IOException("MessageConnection.setMessageListener: " +
				"клиентское соединение не может принимать сообщения.");
	}

	public void send(Message message)
			throws IOException, InterruptedIOException
	{
		boolean bytes;
		boolean chars;
		int passLength;
		byte[] passData;
		String passText;
		QueueOfObjects messagesQueue;
		if(closed)
		{
			throw new IOException("MessageConnection.send: " +
					"соединение закрыто.");
		}
		if(message == null)
		{
			throw new NullPointerException("MessageConnection.send: " +
					"параметр message равен нулевой ссылке.");
		}
		if((!(bytes = message instanceof MessageOfBytes)) &
				(!(chars = message instanceof MessageOfChars)))
		{
			throw new IllegalArgumentException("MessageConnection.send: " +
					"параметр message не был создан методом newMessage.");
		}
		if(bytes && ((passLength = (passData = ((BinaryMessage) message).getPayloadData()) !=
				null ? passData.length : 0) < 0 || passLength > MAXIMUM_MESSAGE_LENGTH) ||
				chars && ((passLength = (passText = ((TextMessage) message).getPayloadText()) !=
				null ? passText.length() : 0) < 0 || passLength > MAXIMUM_MESSAGE_LENGTH))
		{
			throw new IllegalArgumentException("MessageConnection.send: " +
					"параметр message имеет очень большую длину.");
		}
		synchronized(messagesQueue = outgoingMessages)
		{
			messagesQueue.push(message);
		}
		ImplementationManager.getConnectionFactory().setEvent(new MessageDeliveryEvent(this));
	}

	public int numberOfSegments(Message message)
	{
		boolean bytes;
		boolean chars;
		int passLength;
		byte[] passData;
		String passText;
		return message == null || (
				(!(bytes = message instanceof MessageOfBytes)) &
				(!(chars = message instanceof MessageOfChars))) ||
				bytes && ((passLength = (passData = ((BinaryMessage) message).getPayloadData()) !=
				null ? passData.length : 0) < 0 || passLength > MAXIMUM_MESSAGE_LENGTH) ||
				chars && ((passLength = (passText = ((TextMessage) message).getPayloadText()) !=
				null ? passText.length() : 0) < 0 || passLength > MAXIMUM_MESSAGE_LENGTH) ? 0 : 1;
	}

	public Message receive()
			throws IOException, InterruptedIOException
	{
		if(closed)
		{
			throw new IOException("MessageConnection.receive: " +
					"соединение закрыто.");
		}
		throw new IOException("MessageConnection.receive: " +
				"клиентское соединение не может принимать сообщения.");
	}

	public final Message newMessage(String type)
	{
		if(BINARY_MESSAGE.equals(type))
		{
			return new MessageOfBytes(url);
		}
		if(TEXT_MESSAGE.equals(type))
		{
			return new MessageOfChars(url);
		}
		throw new IllegalArgumentException("MessageConnection.newMessage: " +
				"недопустимое значение параметра type.");
	}

	public final Message newMessage(String type, String url)
	{
		if(BINARY_MESSAGE.equals(type))
		{
			return new MessageOfBytes(url);
		}
		if(TEXT_MESSAGE.equals(type))
		{
			return new MessageOfChars(url);
		}
		throw new IllegalArgumentException("MessageConnection.newMessage: " +
				"недопустимое значение параметра type.");
	}
}
