/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package java.lang;

import malik.emulator.util.*;

public final class Double extends Object
{
    public static final double NaN = 0.d / 0.d;
    public static final double POSITIVE_INFINITY = +1.d / 0.d;
    public static final double NEGATIVE_INFINITY = -1.d / 0.d;
    public static final double MAX_VALUE = 1.79769313486231571e+308d;
    public static final double MIN_VALUE = 4.94065645841246544e-324d;

    private static final RealValueRepresenter representer;

    static {
        representer = new RealValueRepresenter(RealValueRepresenter.DOUBLE_SIGNIFICAND_DIGITS, RealValueRepresenter.DOUBLE_ORDER_DIGITS);
    }

    public static boolean isNaN(double value) {
        return value != value;
    }

    public static boolean isInfinite(double value) {
        return value == POSITIVE_INFINITY || value == NEGATIVE_INFINITY;
    }

    public static double parseDouble(String string) throws NumberFormatException {
        return representer.parseDouble(string);
    }

    public static strictfp double longBitsToDouble(long bits) {
        return MalikSystem.getDoubleAt(MalikSystem.getLocalVariableAddress(bits));
    }

    public static strictfp long doubleToLongBits(double value) {
        return MalikSystem.getLongAt(MalikSystem.getLocalVariableAddress(value));
    }

    public static Double valueOf(String string) throws NumberFormatException {
        double value = representer.parseDouble(string);
        return new Double(value);
    }

    public static String toString(double value) {
        return representer.toString(value);
    }

    private final double value;

    public Double(double value) {
        this.value = value;
    }

    public boolean equals(Object anot) {
        return anot == this || anot instanceof Double && doubleToLongBits(value) == doubleToLongBits(((Double) anot).value);
    }

    public int hashCode() {
        long bits;
        return (int) ((bits = doubleToLongBits(value)) ^ (bits >> 32));
    }

    public String toString() {
        return representer.toString(value);
    }

    public boolean isNaN() {
        double value;
        return (value = this.value) != value;
    }

    public boolean isInfinite() {
        double value;
        return (value = this.value) == POSITIVE_INFINITY || value == NEGATIVE_INFINITY;
    }

    public float floatValue() {
        return (float) value;
    }

    public double doubleValue() {
        return value;
    }

    public byte byteValue() {
        return (byte) value;
    }

    public short shortValue() {
        return (short) value;
    }

    public int intValue() {
        return (int) value;
    }

    public long longValue() {
        return (long) value;
    }
}
