/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package malik.emulator.i18n.encoding.system;

import java.io.*;
import malik.emulator.i18n.*;

public class UTF_8_Reader extends StreamReader
{
    public UTF_8_Reader() {
        super(new Object());
    }

    public int read() throws IOException {
        int error;
        int result;
        InputStream stream = getInputStream();
        error = 0;
        synchronized(lock)
        {
            label0:
            {
                int b;
                int count;
                if((b = stream.read()) < 0)
                {
                    result = -1;
                    break label0;
                }
                switch(b >> 4)
                {
                case 0x00:
                case 0x01:
                case 0x02:
                case 0x03:
                case 0x04:
                case 0x05:
                case 0x06:
                case 0x07:
                    result = b;
                    count = 1;
                    break;
                case 0x0c:
                case 0x0d:
                    result = b & 0x1f;
                    count = 2;
                    break;
                case 0x0e:
                    result = b & 0x0f;
                    count = 3;
                    break;
                default:
                    error = 1;
                    result = 0;
                    break label0;
                }
                for(int i = 1; i < count; i++)
                {
                    if((b = stream.read()) < 0 || (b & 0xc0) != 0x80)
                    {
                        error = 1;
                        break label0;
                    }
                    result = result << 6 | b & 0x3f;
                }
            }
        }
        if(error == 1)
        {
            throw new UTFDataFormatException("InputStreamReader.read: ошибка в данных, закодированных кодировкой UTF-8.");
        }
        return result;
    }

    public int read(char[] dst, int offset, int length) throws IOException {
        int error;
        int result;
        InputStream stream = getInputStream();
        error = 0;
        synchronized(lock)
        {
            label0: for(result = 0; result < length; result++)
            {
                int b;
                int count;
                int character;
                if((b = stream.read()) < 0)
                {
                    if(result == 0) result--;
                    break label0;
                }
                switch(b >> 4)
                {
                case 0x00:
                case 0x01:
                case 0x02:
                case 0x03:
                case 0x04:
                case 0x05:
                case 0x06:
                case 0x07:
                    character = b;
                    count = 1;
                    break;
                case 0x0c:
                case 0x0d:
                    character = b & 0x1f;
                    count = 2;
                    break;
                case 0x0e:
                    character = b & 0x0f;
                    count = 3;
                    break;
                default:
                    error = 1;
                    break label0;
                }
                for(int i = 1; i < count; i++)
                {
                    if((b = stream.read()) < 0 || (b & 0xc0) != 0x80)
                    {
                        error = 1;
                        break label0;
                    }
                    character = character << 6 | b & 0x3f;
                }
                dst[offset + result] = (char) character;
            }
        }
        if(error == 1)
        {
            throw new UTFDataFormatException("InputStreamReader.read: ошибка в данных, закодированных кодировкой UTF-8.");
        }
        return result;
    }

    public long skip(long quantity) throws IOException {
        int error;
        long result;
        InputStream stream;
        if(quantity < 0L)
        {
            throw new IllegalArgumentException("Reader.skip: аргумент quantity не может быть отрицательным.");
        }
        if(quantity == 0L) return 0L;
        stream = getInputStream();
        error = 0;
        synchronized(lock)
        {
            label0: for(result = 0; result < quantity; result++)
            {
                int b;
                int count;
                if((b = stream.read()) < 0) break label0;
                switch(b >> 4)
                {
                case 0x00:
                case 0x01:
                case 0x02:
                case 0x03:
                case 0x04:
                case 0x05:
                case 0x06:
                case 0x07:
                    count = 1;
                    break;
                case 0x0c:
                case 0x0d:
                    count = 2;
                    break;
                case 0x0e:
                    count = 3;
                    break;
                default:
                    error = 1;
                    break label0;
                }
                for(int i = 1; i < count; i++) if((b = stream.read()) < 0 || (b & 0xc0) != 0x80)
                {
                    error = 1;
                    break label0;
                }
            }
        }
        if(error == 1)
        {
            throw new UTFDataFormatException("InputStreamReader.skip: ошибка в данных, закодированных кодировкой UTF-8.");
        }
        return result;
    }
}
