/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package malik.emulator.util;

public class ObjectQueue extends Queue
{
    protected Object[] objects;

    public ObjectQueue() {
        this(0x10);
    }

    public ObjectQueue(int initialCapacity) {
        super(initialCapacity);
        initialCapacity = capacity;
        this.objects = new Object[initialCapacity];
    }

    public void clear() {
        Object[] q = objects;
        for(int c = capacity, t = tail, i = head; i != t; i = nextIndex(i, c)) q[i] = null;
        super.clear();
    }

    public void removeHeadElement() {
        int h;
        if((h = head) != tail)
        {
            objects[h] = null;
            advanceHead(h);
        }
    }

    public void addTailElement(Object objectElement) {
        int t;
        Object[] q = objects;
        if(freeElements() == 0)
        {
            int c = (capacity << 1) - 1;
            q = objects = expand(q, c);
            reset(c);
        }
        t = tail;
        q[t] = objectElement;
        advanceTail(t);
    }

    public final Object peekHeadObject() {
        return objects[head];
    }
}
