/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package javax.microedition.lcdui;

public interface Input
{
    public static final int ANY             =      0;
    public static final int EMAILADDR       =      1;
    public static final int NUMERIC         =      2;
    public static final int PHONENUMBER     =      3;
    public static final int URL             =      4;
    public static final int DECIMAL         =      5;
    public static final int CONSTRAINT_MASK = 0xffff;
    public static final int PASSWORD              = 0x00010000;
    public static final int UNEDITABLE            = 0x00020000;
    public static final int SENSITIVE             = 0x00040000;
    public static final int NON_PREDICTIVE        = 0x00080000;
    public static final int INITIAL_CAPS_WORD     = 0x00100000;
    public static final int INITIAL_CAPS_SENTENCE = 0x00200000;

    public void insert(char[] src, int offset, int length, int position);

    public void insert(String text, int position);

    public void delete(int offset, int length);

    public void setConstraints(int constraints);

    public void setChars(char[] src, int offset, int length);

    public void setString(String inputText);

    public void setInitialInputMode(String characterSubset);

    public int setMaxSize(int maximumSize);

    public int size();

    public int getConstraints();

    public int getCaretPosition();

    public int getChars(char[] dst);

    public int getMaxSize();

    public String getString();
}
