/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package javax.microedition.lcdui;

import malik.emulator.util.*;

public class Ticker extends Object
{
    private static String toDisplayed(String text) {
        int len;
        StringBuilder result;
        if(text == null || (len = text.length()) <= 0) return "";
        (result = new StringBuilder(len)).append(text);
        for(int i = len; i-- > 0; ) if(result.get(i) < ' ')
        {
            result.delete(i);
            result.insert(i, "  ");
        }
        return result.toString();
    }

    private float position;
    private String text;
    private String displayed;

    public Ticker(String text) {
        this.position = -16384.f;
        this.text = text;
        this.displayed = toDisplayed(text);
    }

    public void setString(String text) {
        this.text = text;
        this.displayed = toDisplayed(text);
    }

    public String getString() {
        return text;
    }

    public final int getPosition() {
        return (int) position;
    }

    public final String getDisplayedString() {
        return displayed;
    }

    final void scroll(float delta, int width, Font font) {
        if(font == null) font = Font.getDefaultFont();
        if((position -= delta) < (float) -font.stringWidth(displayed)) position = (float) width;
    }
}
