/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package malik.emulator.microedition.system;

public final class KeyCodeSet extends Object
{
    private final int[] keyCodes;
    private final String name;

    public KeyCodeSet(String name, int keyCodeForUp, int keyCodeForDown, int keyCodeForLeft, int keyCodeForRight, int keyCodeForSelect, int keyCodeForSoft1, int keyCodeForSoft2) {
        this.keyCodes = new int[] { keyCodeForUp, keyCodeForDown, keyCodeForLeft, keyCodeForRight, keyCodeForSelect, keyCodeForSoft1, keyCodeForSoft2 };
        this.name = name;
    }

    public int getKeyCodeForUp() {
        return keyCodes[0];
    }

    public int getKeyCodeForDown() {
        return keyCodes[1];
    }

    public int getKeyCodeForLeft() {
        return keyCodes[2];
    }

    public int getKeyCodeForRight() {
        return keyCodes[3];
    }

    public int getKeyCodeForSelect() {
        return keyCodes[4];
    }

    public int getKeyCodeForSoft1() {
        return keyCodes[5];
    }

    public int getKeyCodeForSoft2() {
        return keyCodes[6];
    }

    public int[] getKeyCodesAsArray() {
        int len;
        int[] result;
        Array.copy(result = keyCodes, 0, result = new int[len = result.length], 0, len);
        return result;
    }

    public String getName() {
        return name;
    }
}
