/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package malik.emulator.microedition.system.protocol.sms;

import javax.wireless.messaging.*;

public class BinaryShortMessage extends ShortMessage implements BinaryMessage
{
    private byte[] payloadData;

    public BinaryShortMessage(MessageConnection creator, boolean inbound, String senderAddress, String recipientAddress, long timestamp, byte[] payloadData) {
        super(creator, inbound, senderAddress, recipientAddress, timestamp);
        this.payloadData = payloadData;
    }

    public int getLength() {
        byte[] payloadData;
        return (payloadData = this.payloadData) == null ? 0 : payloadData.length;
    }

    public ShortMessage createInboundCopy() {
        byte[] payloadData;
        if((payloadData = this.payloadData) != null)
        {
            int len;
            Array.copy(payloadData, 0, payloadData = new byte[len = payloadData.length], 0, len);
        }
        return new BinaryShortMessage(null, true, recipientAddress, senderAddress, timestamp, payloadData);
    }

    public void setPayloadData(byte[] data) {
        this.payloadData = data;
    }

    public byte[] getPayloadData() {
        return payloadData;
    }
}
