/*
 * Decompiled with CFR 0.152.
 */
package com.sensiblemobiles.MissionCorba;

import com.sensiblemobiles.MissionCorba.CommanFunctions;
import com.sensiblemobiles.MissionCorba.Configuration;
import com.sensiblemobiles.MissionCorba.LevelManager;
import com.sensiblemobiles.game.MainGameCanvas;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class LevelSelection {
    int screenWidth;
    int screenHeight;
    Image background;
    Image UnlockLevel;
    Image LockedLevel;
    int unlocked = 1;
    Font font;
    int Xcord;
    int Ycord;
    int selectIndex = 0;
    private int MaxLevel;
    public static String levelun = "levelun";
    String[] Level = new String[]{"/res/level/level_1.txt", "/res/level/level_2.txt", "/res/level/level_3.txt", "/res/level/level_4.txt", "/res/level/level_5.txt", "/res/level/level_6.txt", "/res/level/level_7.txt", "/res/level/level_8.txt", "/res/level/level_9.txt", "/res/level/level_10.txt"};
    int levelNo = 1;
    int topAdHeight;
    String val;
    int prvy = 0;
    int Sycord;
    int buttonSize;
    int noOfButtons = 2;
    private LevelManager levelManager;
    int maxRows;
    int maxCols;
    int[][] arr;

    public LevelSelection(int width, int height, int maxRows, int maxCols, int maxLevel) {
        this.screenWidth = width;
        this.screenHeight = height;
        this.maxRows = maxRows;
        this.maxCols = maxCols;
        this.MaxLevel = maxLevel;
        this.topAdHeight = MainGameCanvas.mainGameCanvas.advertisements.getTopAddHeight();
        this.unlocked = this.getUnlockedLevel();
        this.font = Font.getFont((int)32, (int)1, (int)8);
        try {
            this.background = Image.createImage((String)"/res/splash/Splash.png");
            this.background = CommanFunctions.scale(this.background, this.screenWidth, this.screenHeight);
            this.UnlockLevel = Image.createImage((String)"/res/levelSelection/UnlockLevel.png");
            this.LockedLevel = Image.createImage((String)"/res/levelSelection/LockedLevel.png");
            if (this.screenWidth < this.screenHeight) {
                this.UnlockLevel = CommanFunctions.scale(this.UnlockLevel, this.screenWidth * 20 / 100, this.screenWidth * 20 / 100);
                this.LockedLevel = CommanFunctions.scale(this.LockedLevel, this.screenWidth * 20 / 100, this.screenWidth * 20 / 100);
            } else {
                this.UnlockLevel = CommanFunctions.scale(this.UnlockLevel, this.screenHeight * 20 / 100, this.screenHeight * 20 / 100);
                this.LockedLevel = CommanFunctions.scale(this.LockedLevel, this.screenHeight * 20 / 100, this.screenHeight * 20 / 100);
            }
            if (width > height) {
                this.buttonSize = (height - height / 3) / 3;
                this.UnlockLevel = CommanFunctions.scale(this.UnlockLevel, this.buttonSize, this.buttonSize);
                this.LockedLevel = CommanFunctions.scale(this.LockedLevel, this.buttonSize, this.buttonSize);
                this.noOfButtons = width / this.buttonSize / 2;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (width > height) {
            this.Xcord = width / 3 / 3;
            this.Ycord = this.topAdHeight + 10;
            this.levelManager = new LevelManager();
            this.arr = this.levelManager.loadLevel(this.Level[this.levelNo], maxCols, maxRows);
        } else {
            this.Xcord = this.screenWidth * 10 / 100;
            this.Ycord = this.topAdHeight + this.screenHeight * 1 / 100;
            this.levelManager = new LevelManager();
            this.arr = this.levelManager.loadLevel(this.Level[this.levelNo], maxCols, maxRows);
        }
    }

    public void setUnlockedLevel(int level) {
        Configuration.Set(levelun, "" + level);
    }

    public int getUnlockedLevel() {
        int unl_lev = 1;
        String temp = Configuration.Get(levelun);
        unl_lev = temp.length() > 0 ? Integer.parseInt(temp) : 1;
        return unl_lev;
    }

    public void paint(Graphics g) {
        this.unlocked = this.getUnlockedLevel();
        g.drawImage(this.background, this.screenWidth / 2, this.screenHeight / 2, 3);
        int Tycord = this.Ycord;
        int Txcord = this.Xcord;
        for (int i = 0; i < this.MaxLevel; ++i) {
            if (this.selectIndex == i) {
                g.setColor(65331);
                if (this.screenWidth > this.screenHeight) {
                    g.fillRect(Txcord, Tycord, this.buttonSize, this.buttonSize);
                } else {
                    g.fillRect(Txcord, Tycord, this.screenWidth * 20 / 100, this.screenWidth * 20 / 100);
                }
                this.Sycord = Tycord;
            }
            int levelNumber = i + 1;
            if (i < this.unlocked) {
                g.drawImage(this.UnlockLevel, Txcord, Tycord, 0);
                g.setColor(0xFFFFFF);
                g.drawString("" + levelNumber, Txcord + this.UnlockLevel.getWidth() / 2, Tycord + this.UnlockLevel.getHeight() / 2 - this.font.getHeight() / 2, 17);
            } else {
                g.drawImage(this.LockedLevel, Txcord, Tycord, 0);
            }
            Txcord += this.Xcord + this.Xcord;
            if (this.screenWidth > this.screenHeight) {
                if ((i + 1) % 4 != 0) continue;
                Txcord = this.Xcord;
                if (this.screenHeight == 360) {
                    Tycord += this.UnlockLevel.getHeight();
                    continue;
                }
                Tycord += this.Xcord + this.Xcord / 2;
                continue;
            }
            if (i % 3 != 0 || i == 0) continue;
            Txcord = this.Xcord + this.Xcord;
            Tycord += this.UnlockLevel.getHeight() + 20;
        }
    }

    public void keyPressed(int keyCode) {
        block4: {
            block11: {
                block12: {
                    block9: {
                        block10: {
                            block6: {
                                block8: {
                                    block7: {
                                        block2: {
                                            block5: {
                                                block3: {
                                                    if (keyCode != -3) break block2;
                                                    if (this.screenWidth <= this.screenHeight) break block3;
                                                    this.selectIndex = this.selectIndex < 1 ? this.MaxLevel - 1 : --this.selectIndex;
                                                    break block4;
                                                }
                                                if (this.selectIndex > 1) break block5;
                                                this.selectIndex = this.MaxLevel - 1;
                                                this.Ycord = this.screenHeight - (this.UnlockLevel.getHeight() + this.Xcord / 2) * this.MaxLevel / 2;
                                                break block4;
                                            }
                                            --this.selectIndex;
                                            if (this.Sycord > this.UnlockLevel.getHeight() + this.Xcord / 2) break block4;
                                            this.Ycord += this.Xcord + this.Xcord / 2;
                                            break block4;
                                        }
                                        if (keyCode != -4) break block6;
                                        if (this.screenWidth <= this.screenHeight) break block7;
                                        this.selectIndex = this.selectIndex > this.MaxLevel - 1 ? 0 : ++this.selectIndex;
                                        break block4;
                                    }
                                    if (this.selectIndex < this.MaxLevel - 1) break block8;
                                    this.selectIndex = 0;
                                    this.Ycord = this.topAdHeight + this.screenWidth * 10 / 100;
                                    break block4;
                                }
                                ++this.selectIndex;
                                if (this.Sycord < this.screenHeight - (this.UnlockLevel.getHeight() + this.Xcord / 2) * 2) break block4;
                                this.Ycord -= this.Xcord + this.Xcord / 2;
                                break block4;
                            }
                            if (keyCode != -1) break block9;
                            if (this.screenWidth > this.screenHeight) break block4;
                            if (this.selectIndex > 1) break block10;
                            this.selectIndex = this.MaxLevel - 2;
                            this.Ycord = this.screenHeight - (this.UnlockLevel.getHeight() + this.Xcord / 2) * this.MaxLevel / 2;
                            break block4;
                        }
                        this.selectIndex -= 2;
                        if (this.Sycord > this.UnlockLevel.getHeight() + this.Xcord / 2) break block4;
                        this.Ycord += this.Xcord + this.Xcord / 2;
                        break block4;
                    }
                    if (keyCode != -2) break block11;
                    if (this.screenWidth > this.screenHeight) break block4;
                    if (this.selectIndex < this.MaxLevel - 2) break block12;
                    this.selectIndex = 0;
                    this.Ycord = this.topAdHeight + this.screenWidth * 10 / 100;
                    break block4;
                }
                this.selectIndex += 2;
                if (this.Sycord < this.screenHeight - (this.UnlockLevel.getHeight() + this.Xcord / 2) * 2) break block4;
                this.Ycord -= this.Xcord + this.Xcord / 2;
                break block4;
            }
            if (keyCode == -5) {
                for (int i = 0; i < this.unlocked; ++i) {
                    if (this.selectIndex != i) continue;
                    this.levelNo = this.selectIndex;
                    this.arr = this.levelManager.loadLevel(this.Level[this.levelNo], this.maxCols, this.maxRows);
                    MainGameCanvas.mainGameCanvas.setLevelValue(this.arr, this.selectIndex + 1);
                }
            }
        }
    }

    public void pointerPressed(int x, int y) {
        int Tycord = this.Ycord;
        int Txcord = this.Xcord;
        for (int i = 0; i < this.unlocked; ++i) {
            if (y > Tycord && y < Tycord + this.UnlockLevel.getHeight() && x > Txcord && x < Txcord + this.UnlockLevel.getWidth()) {
                this.selectIndex = i;
                this.keyPressed(-5);
            }
            Txcord += this.Xcord * 2;
            if ((i + 1) % 4 != 0) continue;
            Txcord = this.Xcord;
            if (this.screenHeight == 360) {
                Tycord += this.LockedLevel.getHeight();
                continue;
            }
            Tycord += this.Xcord + this.Xcord / 2;
        }
    }

    public void pointerDragged(int x, int y) {
    }

    public void SetMaxLevel(int maxLevel) {
        this.MaxLevel = maxLevel;
    }

    public int getSelectIndex() {
        return this.selectIndex;
    }
}

