/*
 * Decompiled with CFR 0.152.
 */
package arkanoid;

import arkanoid.Backable;
import arkanoid.Ball;
import arkanoid.BrickField;
import arkanoid.Caret;
import arkanoid.MoveBalls;
import arkanoid.NormalBall;
import arkanoid.PlayerLost;
import arkanoid.PlayerWon;
import arkanoid.SuperBall;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class ArkCanvas
extends Canvas
implements CommandListener {
    public static final int ACT_NO = 0;
    public static final int ACT_GLUE = 1;
    public static final int ACT_BALL = 2;
    public static final int ACT_SBALL = 3;
    public static final int ACT_PROTECT = 4;
    public static final int ACT_LOSE = 5;
    public static final int ACT_WIN = 6;
    private static final Command[] COMMANDS;
    private static int appWidth;
    private static int appHeight;
    private static int originLevel;
    private static Display display;
    private static Backable winBack;
    private static Graphics curG;
    private static int fLeft;
    private static int fRight;
    private static final Font font;
    private static final Vector balls;
    private static BrickField field;
    private static int level;
    private static int speed;
    private Image imageBuffer;

    public ArkCanvas() {
        int i = 0;
        while (i < COMMANDS.length) {
            this.addCommand(COMMANDS[i]);
            ++i;
        }
        appWidth = this.getWidth();
        appHeight = this.getHeight();
        originLevel = appWidth - font.stringWidth(" 9");
        field = new BrickField(originLevel - 2, appHeight);
    }

    public boolean init(int newLevel) {
        level = newLevel;
        speed = 100 - 2 * newLevel;
        if (field.load(level)) {
            fLeft = field.left() - 1;
            fRight = field.right() + 1;
            int fieldMid = (fLeft + fRight) / 2;
            balls.removeAllElements();
            balls.ensureCapacity(2);
            Caret.setLevel(level);
            Caret.set(fLeft, fRight, appHeight - 1, balls);
            this.imageBuffer = Image.createImage((int)appWidth, (int)appHeight);
            curG = this.imageBuffer.getGraphics();
            this.repaint();
            this.serviceRepaints();
            MoveBalls.start(speed, this);
            return true;
        }
        return false;
    }

    public void show(Display disp, Backable goBack) {
        display = disp;
        winBack = goBack;
        disp.setCurrent((Displayable)this);
        this.setCommandListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paint(Graphics g) {
        Graphics graphics = curG;
        synchronized (graphics) {
            curG.setColor(0xFFFFFF);
            curG.fillRect(0, 0, appWidth, appHeight);
            curG.setColor(0);
            curG.drawString("Lv", originLevel - 2, font.getHeight(), 0);
            curG.drawString("" + level, originLevel, font.getHeight() * 2, 0);
            int y = 0;
            while (y < appHeight) {
                curG.drawLine(fLeft, y, fLeft, y);
                curG.drawLine(fRight, y, fRight, y);
                y += 2;
            }
            field.paint(curG);
            Caret.paint(curG);
            int i = 0;
            while (i < balls.size()) {
                ((Ball)balls.elementAt(i)).paint(curG);
                ++i;
            }
            g.drawImage(this.imageBuffer, 0, 0, 20);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void moveBalls() {
        i = 0;
        while (i < ArkCanvas.balls.size()) {
            curBall = (Ball)ArkCanvas.balls.elementAt(i);
            curBall.move();
            if (curBall.bottom() < Caret.top() || !curBall.goesDown()) ** GOTO lbl-1000
            var4_6 = ArkCanvas.curG;
            synchronized (var4_6) {
                res = Caret.reflect(curBall, ArkCanvas.curG);
            }
            if (!res) {
                var5_7 = ArkCanvas.curG;
                synchronized (var5_7) {
                    curBall.hide(ArkCanvas.curG);
                }
                ArkCanvas.balls.removeElementAt(i);
                if (i > 0) {
                    --i;
                }
                if (ArkCanvas.balls.size() == 0 && !Caret.isGlued()) {
                    ArkCanvas.field.setAction(5);
                }
            } else lbl-1000:
            // 2 sources

            {
                var3_5 = ArkCanvas.curG;
                synchronized (var3_5) {
                    while (ArkCanvas.field.reflect(curBall, ArkCanvas.curG)) {
                    }
                }
                act = ArkCanvas.field.getAction();
                switch (act) {
                    case 5: 
                    case 6: {
                        ArkCanvas.field.setAction(act);
                        break;
                    }
                    case 2: {
                        ArkCanvas.balls.addElement(new NormalBall(curBall));
                        break;
                    }
                    case 3: {
                        ArkCanvas.balls.addElement(new SuperBall(curBall));
                        break;
                    }
                    case 1: 
                    case 4: {
                        var8_11 = ArkCanvas.curG;
                        synchronized (var8_11) {
                            Caret.action(act, ArkCanvas.curG);
                            break;
                        }
                    }
                }
                var9_12 = ArkCanvas.curG;
                synchronized (var9_12) {
                    curBall.paint(ArkCanvas.curG);
                }
            }
            ++i;
        }
        act = ArkCanvas.field.getAction();
        switch (act) {
            case 6: {
                this.stopAll();
                ArkCanvas.balls.removeAllElements();
                if (this.init(ArkCanvas.level + 1)) break;
                new PlayerWon().show(ArkCanvas.display, ArkCanvas.winBack);
                break;
            }
            case 5: {
                this.stopAll();
                ArkCanvas.balls.removeAllElements();
                new PlayerLost().show(ArkCanvas.display, ArkCanvas.winBack);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveCaret(int step) {
        Caret.move(step);
        Graphics graphics = curG;
        synchronized (graphics) {
            Caret.paint(curG);
        }
    }

    private void stopAll() {
        MoveBalls.stop();
        curG = null;
    }

    public void commandAction(Command cmd, Displayable obj) {
        if (cmd == COMMANDS[1]) {
            this.stopAll();
            winBack.show();
        } else {
            this.repaint();
        }
    }

    private int getExtraAction(int keyCode) {
        int key;
        switch (keyCode) {
            case 52: {
                key = 2;
                break;
            }
            case 54: {
                key = 5;
                break;
            }
            case 53: {
                key = 1;
                break;
            }
            case 56: {
                key = 6;
                break;
            }
            default: {
                key = this.getGameAction(keyCode);
            }
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void keyPressed(int keyCode) {
        int key = this.getExtraAction(keyCode);
        switch (key) {
            case 1: {
                if (MoveBalls.isPaused()) break;
                Graphics graphics = curG;
                synchronized (graphics) {
                    Caret.keyUp(curG);
                    break;
                }
            }
            case 6: {
                if (MoveBalls.isPaused()) break;
                Graphics graphics = curG;
                synchronized (graphics) {
                    Caret.keyDown(curG);
                    break;
                }
            }
            case 2: {
                if (MoveBalls.isPaused()) break;
                this.moveCaret(-1);
                break;
            }
            case 5: {
                if (MoveBalls.isPaused()) break;
                this.moveCaret(1);
                break;
            }
            case 8: {
                MoveBalls.pause();
            }
        }
    }

    protected void hideNotify() {
        MoveBalls.isStopped = true;
    }

    protected void showNotify() {
        MoveBalls.isStopped = false;
        new Thread(MoveBalls.mover).start();
    }

    static {
        ACT_NO = 0;
        ACT_GLUE = 1;
        ACT_BALL = 2;
        ACT_SBALL = 3;
        ACT_PROTECT = 4;
        ACT_LOSE = 5;
        ACT_WIN = 6;
        COMMANDS = new Command[]{new Command("Cancel", 3, 1), new Command("Stop", 6, 2)};
        font = Font.getFont((int)64, (int)0, (int)8);
        balls = new Vector();
    }
}

