/*
 * Decompiled with CFR 0.152.
 */
package arkanoid;

import arkanoid.BallBrick;
import arkanoid.BlackBrick;
import arkanoid.GlueBrick;
import arkanoid.GrayBrick;
import arkanoid.ProtectBrick;
import arkanoid.SolidBrick;
import arkanoid.SuperBrick;
import arkanoid.WhiteBrick;
import javax.microedition.lcdui.Graphics;

abstract class Brick {
    public static final int WIDTH = 17;
    public static final int HEIGHT = 5;
    protected int hitsLeft;
    protected int X;
    protected int Y;

    public Brick(int x, int y) {
        this.X = x;
        this.Y = y;
        this.hitsLeft = 1;
    }

    protected abstract void paintBrick(Graphics var1);

    public int hit(Graphics g) {
        --this.hitsLeft;
        return 0;
    }

    public int destroy(Graphics g) {
        this.hitsLeft = 0;
        return 0;
    }

    public final boolean hittable() {
        return this.hitsLeft > 0;
    }

    public boolean destroyable() {
        return true;
    }

    public final void paint(Graphics g) {
        if (this.hitsLeft == 0) {
            g.setColor(0xFFFFFF);
            g.fillRect(this.X, this.Y, 17, 5);
        } else {
            this.paintBrick(g);
        }
    }

    public final int top() {
        return this.Y;
    }

    public final int bottom() {
        return this.Y + 5 - 1;
    }

    public final int left() {
        return this.X;
    }

    public final int right() {
        return this.X + 17 - 1;
    }

    public static final Brick getTyped(char br_type, int x, int y) {
        Brick curBr;
        switch (br_type) {
            case 'W': {
                curBr = new WhiteBrick(x, y);
                break;
            }
            case 'G': {
                curBr = new GrayBrick(x, y);
                break;
            }
            case 'B': {
                curBr = new BlackBrick(x, y);
                break;
            }
            case 'S': {
                curBr = new SolidBrick(x, y);
                break;
            }
            case 'b': {
                curBr = new BallBrick(x, y);
                break;
            }
            case 'g': {
                curBr = new GlueBrick(x, y);
                break;
            }
            case 'p': {
                curBr = new ProtectBrick(x, y);
                break;
            }
            case 's': {
                curBr = new SuperBrick(x, y);
                break;
            }
            default: {
                curBr = null;
            }
        }
        return curBr;
    }

    static {
        WIDTH = 17;
        HEIGHT = 5;
    }
}

