/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Sprite;

public class TitleScreen
extends GameCanvas
implements CommandListener,
Runnable {
    private static final boolean DEBUG = false;
    private MyGameBase midlet;
    private Graphics buffer;
    private Command exitCommand;
    private Command startGameCommand;
    private Command startRndGameCommand;
    private Command swapColorsCommand;
    private Command swapCharsetCommand;
    private Command toggleYieldCommand;
    private Command toggleFPSCommand;
    private Command toggleBIGCommand;
    private Command benchmark1Command;
    private Command benchmark2Command;
    private Command benchmark3Command;
    private Image titleImage;
    private Image titleImageT;
    private Sprite titleSprite;
    private Sprite titleSpriteT;
    private boolean readytopaint;
    private boolean running;
    private long idletime;
    private boolean idlehide;
    private static int rndSeed;

    public TitleScreen(MyGameBase midlet) {
        super(false);
        this.midlet = midlet;
        this.readytopaint = false;
        this.running = true;
        this.exitCommand = new Command("exit", 7, 20);
        this.startGameCommand = new Command("Dash!", 1, 0);
        this.startRndGameCommand = new Command("Surprise!", 1, 1);
        this.swapColorsCommand = new Command("Change Colors", 1, 2);
        this.swapCharsetCommand = new Command("Change Charset", 1, 3);
        this.toggleYieldCommand = new Command("Toggle Yield", 1, 4);
        this.toggleFPSCommand = new Command("Toggle FPS", 1, 5);
        this.toggleBIGCommand = new Command("Toggle BIG", 1, 6);
        this.benchmark1Command = new Command("Benchmark 1", 1, 10);
        this.benchmark2Command = new Command("Benchmark 2", 1, 11);
        this.benchmark3Command = new Command("Benchmark 3", 1, 12);
        this.addCommand(this.exitCommand);
        this.addCommand(this.startGameCommand);
        this.addCommand(this.startRndGameCommand);
        this.addCommand(this.swapColorsCommand);
        this.addCommand(this.swapCharsetCommand);
        this.addCommand(this.toggleBIGCommand);
        this.setCommandListener(this);
        this.buffer = this.getGraphics();
        try {
            this.titleImage = Image.createImage((String)"/res_bd/Title_176x176.png");
            this.titleImageT = Image.createImage((String)"/res_bd/Title-t.png");
        }
        catch (Exception e) {
            System.out.println("titleSprite: " + e);
        }
        this.titleSprite = new Sprite(this.titleImage);
        this.titleSprite.setPosition(0, 0);
        this.readytopaint = true;
        this.idletime = System.currentTimeMillis();
        this.idlehide = false;
    }

    public void Dispose() {
        this.readytopaint = false;
        this.titleSprite = null;
        this.titleSpriteT = null;
        this.titleImage = null;
        this.titleImageT = null;
        this.buffer = null;
        this.midlet = null;
        this.exitCommand = null;
        this.startGameCommand = null;
        this.startRndGameCommand = null;
        this.swapColorsCommand = null;
        this.toggleYieldCommand = null;
        this.toggleFPSCommand = null;
        this.toggleBIGCommand = null;
        this.benchmark1Command = null;
        this.benchmark2Command = null;
        this.benchmark3Command = null;
    }

    public void MakeGameList(int g) {
        for (int i = 0; i < 20; ++i) {
            this.midlet.GameList[i] = g;
        }
    }

    private void randomize() {
        long ctm = System.currentTimeMillis();
        while ((ctm & 1L) == 0L) {
            ctm >>= 1;
        }
        rndSeed = (int)ctm;
    }

    private int rand() {
        rndSeed = 20021 * rndSeed + 1 >> 8;
        return rndSeed & Integer.MAX_VALUE;
    }

    public void MakeRndGameList(int maxg) {
        this.randomize();
        Random rnd = new Random();
        for (int i = 0; i < 20; ++i) {
            this.midlet.GameList[i] = rnd.nextInt(maxg);
            System.out.println("rnd seq " + this.midlet.GameList[i] + "  " + rndSeed);
        }
    }

    public void commandAction(Command c, Displayable s) {
        if (c == this.exitCommand) {
            this.midlet.quit();
        } else if (c == this.startGameCommand) {
            this.midlet.mode = 0;
            this.MakeGameList(this.midlet.game);
            this.running = false;
        } else if (c == this.startRndGameCommand) {
            this.midlet.mode = 0;
            ((Object)((Object)this.midlet)).getClass();
            this.MakeRndGameList(62);
            this.running = false;
        } else if (c == this.swapColorsCommand) {
            this.midlet.colors = (this.midlet.colors + 1) % 2;
        } else if (c == this.swapCharsetCommand) {
            MyGameBase.SPACE = !MyGameBase.SPACE;
        } else if (c == this.toggleYieldCommand) {
            this.midlet.yield = !this.midlet.yield;
        } else if (c == this.toggleFPSCommand) {
            this.midlet.showFPS = !this.midlet.showFPS;
        } else if (c == this.toggleBIGCommand) {
            this.midlet.BIGtiles = !this.midlet.BIGtiles;
        } else if (c == this.benchmark1Command) {
            this.midlet.mode = 1;
            this.midlet.showFPS = true;
            this.MakeGameList(this.midlet.game);
            this.running = false;
        } else if (c == this.benchmark2Command) {
            this.midlet.mode = 2;
            this.midlet.showFPS = true;
            this.MakeGameList(this.midlet.game);
            this.running = false;
        } else if (c == this.benchmark3Command) {
            this.midlet.mode = 3;
            this.midlet.showFPS = true;
            this.MakeGameList(this.midlet.game);
            this.running = false;
        }
    }

    public void paint(Graphics g) {
        if (this.readytopaint) {
            try {
                this.titleSprite.paint(g);
                g.setFont(null);
                if (this.midlet.frames != 0L && this.midlet.showFPS) {
                    g.setColor(128, 192, 255);
                    g.fillRect(8, 8, 70, 46);
                    g.setColor(0, 0, 0);
                    g.drawRect(8, 8, 70, 46);
                    g.setColor(0, 0, 0);
                    g.drawString(String.valueOf(this.midlet.frames) + " frms", 11, 11, 20);
                    g.drawString(String.valueOf(this.midlet.time) + " ms", 11, 26, 20);
                    g.drawString(String.valueOf(this.midlet.fps) + " fps", 11, 41, 20);
                }
                g.setColor(255, 255, 255);
                g.drawString(String.valueOf(this.midlet.game), 15, 148, 17);
                g.drawString(MyGameBase.CAVENAMES.substring(this.midlet.level, this.midlet.level + 1), 122, 148, 17);
                g.drawString(MyGameBase.GAMENAMES[this.midlet.game], 72, 148, 17);
            }
            catch (Exception e) {
                System.out.println("titleLayer.paint(): " + e);
            }
            this.flushGraphics();
        }
    }

    public int getReturnValue() {
        return 0;
    }

    protected void keyPressed(int keyCode) {
        this.idletime = System.currentTimeMillis();
        this.idlehide = false;
        int ga = this.getGameAction(keyCode);
        if (ga == 6) {
            if (--this.midlet.level < 0) {
                this.midlet.level = 19;
            }
        } else if (ga == 1) {
            if (++this.midlet.level >= 20) {
                this.midlet.level = 0;
            }
        } else if (ga == 2) {
            if (--this.midlet.game < 0) {
                ((Object)((Object)this.midlet)).getClass();
                this.midlet.game = 62 - 1;
            }
        } else if (ga == 5) {
            ((Object)((Object)this.midlet)).getClass();
            if (++this.midlet.game > 62 - 1) {
                this.midlet.game = 0;
            }
        }
        this.paint(this.buffer);
    }

    public void run() {
        while (this.running) {
            Thread.yield();
            long t = System.currentTimeMillis();
            this.paint(this.buffer);
        }
    }
}

