/*
 * Decompiled with CFR 0.152.
 */
package IcebergEngine;

import IcebergEngine.TextUtils;
import java.util.Vector;

public class StringStore {
    private Vector keys = new Vector();
    private Vector values = new Vector();

    public static StringStore createFromFromResource(String string) {
        String string2 = TextUtils.getStringFromResource(string);
        return new StringStore(string2);
    }

    public static StringStore createFromFromResource(String string, char c) {
        String string2 = TextUtils.getStringFromResource(string);
        return new StringStore(string2, c);
    }

    public StringStore(String string) {
        this(string, '\n');
    }

    public StringStore(String string, char c) {
        String[] stringArray = TextUtils.cutOnString(string, c);
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf(61);
            if (n == -1) continue;
            String string2 = stringArray[i].substring(0, n).trim();
            String string3 = stringArray[i].substring(n + 1).trim();
            this.put(string2, string3);
        }
    }

    public StringStore(String[] stringArray, String[] stringArray2) {
        for (int i = 0; i < stringArray2.length; ++i) {
            this.put(stringArray[i], stringArray2[i]);
        }
    }

    public StringStore() {
    }

    public void put(String string, String string2) {
        this.keys.addElement(string);
        this.values.addElement(string2);
    }

    public String get(String string) {
        int n = this.keys.indexOf(string);
        if (n == -1) {
            return null;
        }
        return (String)this.values.elementAt(n);
    }

    public int getInt(String string) {
        String string2 = this.get(string);
        if (string2 == null) {
            return 0;
        }
        return TextUtils.parseInt(string2);
    }

    public float getFloat(String string) {
        String string2 = this.get(string);
        if (string2 == null) {
            return 0.0f;
        }
        return TextUtils.parseFloat(string2);
    }

    public int getIntFromHex(String string) {
        String string2 = this.get(string);
        if (string2 == null) {
            return 0;
        }
        return this.parseInt(string2, 16);
    }

    private int parseInt(String string, int n) throws NumberFormatException {
        int n2 = 0;
        try {
            long l = Long.parseLong(string, n);
            if (n == 16) {
                n2 = (int)(l & Integer.MAX_VALUE);
                if ((l & Integer.MIN_VALUE) != 0L) {
                    n2 |= Integer.MIN_VALUE;
                }
            } else {
                if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                    throw new NumberFormatException(string);
                }
                n2 = (int)l;
            }
        }
        catch (Throwable throwable) {
            throw new NumberFormatException(string);
        }
        return n2;
    }

    public String[] getStringArray(String string, char c) {
        String string2 = this.get(string);
        if (string2 == null) {
            return null;
        }
        return TextUtils.cutOnString(string2, c);
    }

    public int[] getIntArray(String string, char c) {
        String string2 = this.get(string);
        if (string2 == null) {
            return null;
        }
        return TextUtils.cutOnInt(string2, c);
    }

    public float[] getFloatArray(String string, char c) {
        String string2 = this.get(string);
        if (string2 == null) {
            return null;
        }
        return TextUtils.cutOnFloat(string2, c);
    }

    public boolean contains(String string) {
        return this.keys.contains(string);
    }

    public Vector getKeys() {
        return this.keys;
    }

    public Vector getValues() {
        return this.values;
    }
}

