/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;

public class Designer {
    private static byte[] dat_textFont;
    private static int[] pal_textFont;
    private static String charIndex;
    private static byte[] textCharWidth;
    public static byte[] space;
    public static byte[] charTotalHeight;
    public static final byte FONT_TEXT = 0;
    public static final byte FONT_TEXT_SMALL = 3;
    public static final byte FONT_HP = 1;
    public static final byte FONT_TITLE = 2;
    public static final byte MARGIN_LEFT = 0;
    public static final byte MARGIN_CENTER = 1;
    public static final byte MARGIN_RIGHT = 2;
    public static int borderColor;
    public static int[] rgb;
    public static byte[] leftSideRef;
    public static final byte TRANS_NONE = 0;
    public static final byte TRANS_MIRROR = 2;
    public static final byte TRANS_ROT90 = 5;
    public static final byte TRANS_ROT180 = 3;
    public static final byte TRANS_ROT270 = 6;

    private static final byte[] loadDatFile(String file) {
        InputStream is = ((Object)((Object)SkyWar.sunnetFlash)).getClass().getResourceAsStream(file);
        byte[] dat = null;
        try {
            dat = new byte[is.available()];
            is.read(dat);
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return dat;
    }

    private static final int[] loadPalFile(String file) {
        InputStream is = ((Object)((Object)SkyWar.sunnetFlash)).getClass().getResourceAsStream(file);
        int[] pal = null;
        try {
            pal = new int[is.available() / 4];
            byte[] b = new byte[4];
            for (int i = 0; i < pal.length; ++i) {
                is.read(b);
                pal[i] = Designer.toInt(b, 0, 4);
            }
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return pal;
    }

    public static final int toInt(byte[] b, int offset, int length) {
        int num = 0;
        int j = offset + length;
        for (int i = offset; i < j; ++i) {
            num = b[i] < 0 ? (num << 8) + 256 + b[i] : (num << 8) + b[i];
        }
        return num;
    }

    public static final String toString(byte[] b) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            if (b[i] == -128) {
                buf.append('\n');
                continue;
            }
            if (b[i] == -127) {
                buf.append(' ');
                continue;
            }
            buf.append(charIndex.charAt(b[i] + 126));
        }
        return buf.toString();
    }

    public static final void toBytesIndex(String str, byte[] b) {
        int length = Math.min(str.length(), b.length);
        block4: for (int i = 0; i < length; ++i) {
            switch (str.charAt(i)) {
                case '\n': {
                    b[i] = -128;
                    continue block4;
                }
                case ' ': {
                    b[i] = -127;
                    continue block4;
                }
                default: {
                    b[i] = (byte)(charIndex.indexOf(str.charAt(i)) - 126);
                }
            }
        }
    }

    public static final int getCharWidth(byte b, byte type) {
        if (b == -127) {
            return space[type];
        }
        if (b == -128) {
            return 0;
        }
        if (type == 0) {
            return textCharWidth[b + 126];
        }
        return 0;
    }

    public static final int getStringWidth(byte[] b, int offset, int length, byte type) {
        int width = 0;
        int l = Math.min(offset + length, b.length);
        for (int i = offset; i < l; ++i) {
            width += Designer.getCharWidth(b[i], type);
        }
        return width;
    }

    public static final int renderTextChar(Graphics g, int index, int colorType, int x, int y) {
        if (pal_textFont == null) {
            pal_textFont = Designer.loadPalFile("/textfont.pal");
            Runtime.getRuntime().gc();
        }
        if (dat_textFont == null) {
            dat_textFont = Designer.loadDatFile("/textfont.dat");
            Runtime.getRuntime().gc();
        }
        int shift = index * 120;
        int shift_color = colorType * 3;
        for (int i = 0; i < 15; ++i) {
            for (int j = 0; j < 8; ++j) {
                int temp = i * 8 + j;
                Designer.rgb[temp] = pal_textFont[dat_textFont[temp + shift] + shift_color];
            }
        }
        g.drawRGB(rgb, 0, 8, x, y, 8, 15, true);
        return textCharWidth[index];
    }

    public static final int drawChar(Graphics g, byte b, byte type, int colorType, int x, int y) {
        if (b == -127) {
            return space[type];
        }
        if (type == 0) {
            return Designer.renderTextChar(g, b + 126, colorType, x, y);
        }
        return 0;
    }

    public static final int drawString(Graphics g, byte[] b, int offset, int length, byte type, int colorType, int x, int y) {
        int width = 0;
        int memo = x;
        int l = offset + Math.min(length, b.length);
        for (int i = offset; i < l; ++i) {
            if (b[i] == -128) {
                x = memo;
                y += charTotalHeight[type];
                continue;
            }
            int temp = Designer.drawChar(g, b[i], type, colorType, x, y);
            width += temp;
            x += temp;
        }
        return width;
    }

    public static final int drawString(Graphics g, byte[] b, int offset, int length, byte type, byte margin, boolean isWordSplit, int colorType, int x, int y, int width, int height) {
        int end = y + height - charTotalHeight[type];
        int index = offset;
        int lineLength = 0;
        int charCount = 0;
        int wordLength = 0;
        length = Math.min(length + offset, b.length);
        while (y <= end && index < length) {
            lineLength = 0;
            int startIndex = !isWordSplit ? -1 : index;
            while (index < length) {
                if (b[index] == -128) {
                    ++index;
                    break;
                }
                if (b[index] == -127) {
                    if (lineLength + space[type] > width) break;
                    lineLength += space[type];
                    ++index;
                    continue;
                }
                if (!isWordSplit) {
                    if (startIndex == -1) {
                        startIndex = index;
                    }
                    charCount = 0;
                    wordLength = 0;
                    while (index < length && b[index] != -127 && b[index] != -128) {
                        wordLength += Designer.getCharWidth(b[index], type);
                        ++charCount;
                        ++index;
                    }
                    if (lineLength + wordLength <= width) {
                        lineLength += wordLength;
                        continue;
                    }
                    index -= charCount;
                    break;
                }
                if (lineLength + Designer.getCharWidth(b[index], type) > width) break;
                lineLength += Designer.getCharWidth(b[index], type);
                ++index;
            }
            if (lineLength != 0) {
                int endIndex;
                for (endIndex = index - 1; endIndex > startIndex && b[endIndex] == -127; --endIndex) {
                }
                if (margin == 0) {
                    Designer.drawString(g, b, startIndex, endIndex - startIndex + 1, type, colorType, x, y);
                } else if (margin == 1) {
                    Designer.drawString(g, b, startIndex, endIndex - startIndex + 1, type, colorType, x + (width - lineLength) / 2, y);
                } else if (margin == 2) {
                    Designer.drawString(g, b, startIndex, endIndex - startIndex + 1, type, colorType, x + width - lineLength, y);
                }
            }
            y += charTotalHeight[type];
        }
        return index - offset;
    }

    public static final int drawCenterString(Graphics g, byte[] b, int offset, int length, byte type, int colorType, int x, int y) {
        return Designer.drawString(g, b, offset, length, type, colorType, x - Designer.getStringWidth(b, offset, length, type) / 2, y);
    }

    public static final int drawPulledString(Graphics g, byte[] b, int offset, int length, int num, int distance, byte type, int colorType, int x, int y) {
        int i;
        if (num > (length = Math.min(b.length - offset, length)) / 2) {
            return Designer.drawCenterString(g, b, offset, length, type, colorType, x, y);
        }
        int w1 = 0;
        int w2 = 0;
        int k = offset + num;
        for (i = offset; i < k; ++i) {
            w1 += Designer.getCharWidth(b[i], type);
        }
        k = offset + length - 1 - num;
        for (i = offset + length - 1; i > k; --i) {
            w2 += Designer.getCharWidth(b[i], type);
        }
        Designer.drawString(g, b, offset, num, type, colorType, x - (w1 + w2) / 2 - distance / 2, y);
        Designer.drawString(g, b, offset + length - num, num, type, colorType, x + (w1 - w2) / 2 + (distance + 1) / 2, y);
        return w1 + w2 + distance;
    }

    public static final int drawNumber(Graphics g, long num, byte type, int colorType, int x, int y) {
        int width = 0;
        while (num != 0L) {
            byte c = (byte)(num % 10L - 125L);
            num /= 10L;
            width += Designer.drawChar(g, c, type, colorType, x - width, y);
        }
        return width;
    }

    static {
        charIndex = "/0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz!\"#$%&'()*+,-.:;<=>?@[\\]^_`{|}~\u0309\u00b4\u02c7\u0110\u0111\u00e0\u00e1\u1ea3\u00e3\u1ea1\u0103\u1eb1\u1eaf\u1eb3\u1eb5\u1eb7\u00e2\u1ea7\u1ea5\u1ea9\u1eab\u1ead\u00e8\u00e9\u1ebb\u1ebd\u1eb9\u00ea\u1ec1\u1ebf\u1ec3\u1ec5\u1ec7\u00ec\u00ed\u1ec9\u0129\u1ecb\u00f2\u00f3\u1ecf\u00f5\u1ecd\u00f4\u1ed3\u1ed1\u1ed5\u1ed7\u1ed9\u01a1\u1edd\u1edb\u1edf\u1ee1\u1ee3\u00f9\u00fa\u1ee7\u0169\u1ee5\u01b0\u1eeb\u1ee9\u1eed\u1eef\u1ef1\u00c0\u00c1\u1ea2\u00c3\u1ea0\u0102\u1eb0\u1eae\u1eb2\u1eb4\u1eb6\u00c2\u1ea6\u1ea4\u1ea8\u1eaa\u1eac\u00c8\u00c9\u1eba\u1ebc\u1eb8\u00ca\u1ec0\u1ebe\u1ec2\u1ec4\u1ec6\u00cc\u00cd\u1ec8\u0128\u1eca\u00d2\u00d3\u1ece\u00d5\u1ecc\u00d4\u1ed2\u1ed0\u1ed4\u1ed6\u1ed8\u01a0\u1edc\u1eda\u1ede\u1ee0\u1ee2\u00d9\u00da\u1ee6\u0168\u1ee4\u01af\u1eea\u1ee8\u1eec\u1eee\u1ef0\u0366";
        textCharWidth = new byte[]{6, 6, 5, 6, 6, 7, 6, 6, 6, 6, 6, 7, 6, 6, 6, 7, 6, 6, 6, 5, 5, 6, 5, 7, 7, 7, 6, 7, 6, 6, 7, 7, 7, 7, 7, 7, 6, 7, 7, 6, 7, 7, 6, 6, 6, 5, 5, 6, 3, 7, 6, 7, 6, 6, 6, 6, 6, 7, 6, 7, 6, 6, 6, 3, 5, 7, 7, 8, 8, 3, 5, 5, 7, 7, 4, 6, 3, 3, 4, 6, 6, 6, 7, 8, 4, 6, 4, 5, 7, 4, 5, 3, 5, 8, 4, 4, 5, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 5, 5, 5, 6, 5, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8};
        space = new byte[]{4, 6, 10, 4};
        charTotalHeight = new byte[]{15, 9, 23, 14};
        rgb = new int[2000];
        leftSideRef = new byte[]{0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 6, 8, 10, 12};
    }
}

