/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.Sprite;

class BuildEnemy {
    SkyWar midlet;
    int level;
    Random rand = new Random();

    public BuildEnemy(SkyWar midlet) {
        this.midlet = midlet;
        this.level = midlet.gameCanvas.level;
    }

    public GameCanvas gc() {
        return this.midlet.gameCanvas;
    }

    public void buildEnemy() {
        switch (this.level) {
            case 0: 
            case 1: 
            case 2: {
                this.buildPlane();
                this.buildSmallShip();
                this.buildCanon();
                this.buildBoss(this.level);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                this.buildPlane();
                this.buildTank();
                this.buildCanon();
                this.buildBoss(this.level);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                this.buildPlane();
                this.buildTank();
                this.buildCanon();
                this.buildBoss(this.level);
            }
        }
    }

    private void buildPlane() {
        int length = SetMap.planeLevel[this.level].length;
        boolean x = false;
        int y = 0;
        int i = 0;
        int hPlane = 37;
        Object sprite = null;
        for (i = this.gc().indexPlane; i < length; ++i) {
            int row = SetMap.planeLevel[this.level][i];
            y = this.gc().mapY + row * this.gc().map.getCellHeight();
            if (y + hPlane >= this.gc().screenY) {
                int kind = SetMap.planeKind[this.level][i];
                switch (kind) {
                    case 1: 
                    case 2: {
                        this.buildSmallPlane(kind);
                        break;
                    }
                    case 3: {
                        this.buildHelicopter();
                        break;
                    }
                    case 4: {
                        this.buildMediumPlane();
                    }
                }
                continue;
            }
            this.gc().indexPlane = i;
            break;
        }
    }

    private void buildSmallShip() {
        int i = 0;
        int length = SetMap.shipLevel[this.level].length;
        int j = 0;
        Sprite sprite = null;
        boolean choose = false;
        int str = 0;
        GameObject object = null;
        for (i = this.gc().indexShip; i < length; ++i) {
            int row = SetMap.shipLevel[this.level][i][0];
            int col = SetMap.shipLevel[this.level][i][1];
            int aspect = SetMap.aspectShip[this.level][i];
            int x = this.gc().mapX + col * this.gc().map.getCellWidth();
            int y = this.gc().mapY + row * this.gc().map.getCellHeight();
            sprite = new Sprite(this.gc().ship1);
            switch (aspect) {
                case 0: {
                    sprite.setTransform(5);
                    break;
                }
                case 4: {
                    sprite.setTransform(6);
                }
            }
            int height = sprite.getHeight();
            str = this.healthMax(5, this.level);
            if (y + height >= this.gc().screenY) {
                choose = false;
                for (j = 0; j < this.gc().Enemy.size(); ++j) {
                    object = (GameObject)this.gc().Enemy.elementAt(j);
                    if (object.free) {
                        object.free = false;
                        object.mainSprite = null;
                        object.mainSprite = new Sprite(sprite);
                        object.type = 5;
                        object.strength = str;
                        choose = true;
                    }
                    if (choose) break;
                }
                if (!choose) {
                    object = new GameObject(new Sprite(sprite), 5, str);
                    object.append(this.midlet);
                    this.gc().Enemy.addElement(object);
                }
                object.ObjectX = x;
                object.ObjectY = y;
                object.extendInit();
                object.frameTime = 0;
                object.step = 0;
                object.aspect = aspect;
                object.fireTime = 0;
                this.gc().layerManager.append((Layer)object.gunSprite[0]);
                int xo = x + sprite.getWidth() / 2;
                int yo = y + sprite.getHeight() / 2;
                object.gunSprite[0].setPosition(xo -= object.gunSprite[0].getWidth() / 2, yo -= object.gunSprite[0].getHeight() / 2);
                this.gc().layerManager.append((Layer)object.mainSprite);
                this.gc().layer[2] = this.gc().layer[2] + 2;
                object.mainSprite.setPosition(x, y);
                if (this.gc().scopeOnGround > 0) {
                    object.scope = true;
                    --this.gc().scopeOnGround;
                } else {
                    object.scope = false;
                }
                if (i == length - 1) {
                    this.gc().indexShip = length;
                }
            } else {
                this.gc().indexShip = i;
                break;
            }
            sprite = null;
        }
    }

    private void buildCanon() {
        int i = 0;
        int j = 0;
        int length = SetMap.canonLevel[this.level].length;
        Sprite sprite = null;
        boolean choose = false;
        int str = 0;
        GameObject object = null;
        for (i = this.gc().indexCanon; i < length; ++i) {
            int row = SetMap.canonLevel[this.level][i][0];
            int col = SetMap.canonLevel[this.level][i][1];
            int x = this.gc().mapX + col * this.gc().map.getCellWidth();
            int y = this.gc().mapY + row * this.gc().map.getCellHeight();
            int type = SetMap.canonKind[this.level][i];
            switch (type) {
                case 6: {
                    sprite = this.gc().canon[0];
                    break;
                }
                case 8: {
                    sprite = this.gc().canon[1];
                    break;
                }
                case 9: {
                    sprite = this.gc().canon[2];
                    break;
                }
                case 10: {
                    sprite = this.gc().canon[1];
                }
            }
            int height = sprite.getHeight();
            str = this.healthMax(type, this.level);
            if (y + height >= this.gc().screenY || y > this.gc().screenY) {
                choose = false;
                for (j = 0; j < this.gc().Enemy.size(); ++j) {
                    object = (GameObject)this.gc().Enemy.elementAt(j);
                    if (object.free) {
                        object.free = false;
                        object.mainSprite = null;
                        object.mainSprite = new Sprite(sprite);
                        object.type = type;
                        object.strength = str;
                        choose = true;
                    }
                    if (choose) break;
                }
                if (!choose) {
                    object = new GameObject(new Sprite(sprite), type, str);
                    object.append(this.midlet);
                    this.gc().Enemy.addElement(object);
                }
                object.ObjectX = x;
                object.ObjectY = y;
                object.extendInit();
                object.frameTime = 0;
                if (object.type == 10) {
                    object.aspect = x + object.mainSprite.getWidth() / 2 < this.gc().screenWidth / 2 ? 0 : 4;
                }
                object.step = 0;
                object.fireTime = 0;
                if (object.gunNum > 0) {
                    for (j = 0; j < object.gunNum; ++j) {
                        this.gc().layerManager.append((Layer)object.gunSprite[j]);
                        object.gunSprite[j].setPosition(x, y);
                        if (type != 6) continue;
                        object.gunSprite[j].setFrame(2);
                    }
                }
                this.gc().layerManager.append((Layer)object.mainSprite);
                this.gc().layer[2] = this.gc().layer[2] + 1 + object.gunNum;
                object.mainSprite.setPosition(x, y);
                if (object.type != 8 && object.type != 10) {
                    if (this.gc().scopeOnGround > 0) {
                        object.scope = true;
                        --this.gc().scopeOnGround;
                    } else {
                        object.scope = false;
                    }
                } else {
                    object.scope = false;
                }
                if (i != length - 1) continue;
                this.gc().indexCanon = length;
                continue;
            }
            this.gc().indexCanon = i;
            break;
        }
    }

    private void buildTank() {
        int i = 0;
        int length = SetMap.tankLevel[this.level - 3].length;
        int j = 0;
        Sprite sprite = null;
        boolean choose = false;
        int str = 0;
        GameObject object = null;
        for (i = this.gc().indexTank; i < length; ++i) {
            int row = SetMap.tankLevel[this.level - 3][i][0];
            int col = SetMap.tankLevel[this.level - 3][i][1];
            int aspect = SetMap.aspectTank[this.level - 3][i];
            int x = this.gc().mapX + col * this.gc().map.getCellWidth();
            int y = this.gc().mapY + row * this.gc().map.getCellHeight();
            sprite = new Sprite(this.gc().tank);
            switch (aspect) {
                case 0: {
                    sprite.setTransform(2);
                    break;
                }
                case 4: {
                    break;
                }
                case 2: {
                    sprite.setTransform(5);
                    break;
                }
                case 6: {
                    sprite.setTransform(6);
                }
            }
            int height = sprite.getHeight();
            str = this.healthMax(7, this.level);
            if (y + height >= this.gc().screenY) {
                choose = false;
                for (j = 0; j < this.gc().Enemy.size(); ++j) {
                    object = (GameObject)this.gc().Enemy.elementAt(j);
                    if (object.free) {
                        object.free = false;
                        object.mainSprite = null;
                        object.mainSprite = new Sprite(sprite);
                        object.type = 7;
                        object.strength = str;
                        choose = true;
                    }
                    if (choose) break;
                }
                if (!choose) {
                    object = new GameObject(new Sprite(sprite), 7, str);
                    object.append(this.midlet);
                    this.gc().Enemy.addElement(object);
                }
                object.ObjectX = x;
                object.ObjectY = y;
                object.extendInit();
                object.frameTime = 0;
                object.step = 0;
                object.aspect = aspect;
                object.fireTime = 0;
                this.gc().layerManager.append((Layer)object.gunSprite[0]);
                int xo = x + this.distanceX(object, 7, 0, aspect);
                int yo = y + this.distanceY(object, 7, 0, aspect);
                object.gunSprite[0].setPosition(xo, yo);
                this.gc().layerManager.append((Layer)object.mainSprite);
                this.gc().layer[2] = this.gc().layer[2] + 2;
                object.mainSprite.setPosition(x, y);
                if (this.gc().scopeOnGround > 0) {
                    object.scope = true;
                    --this.gc().scopeOnGround;
                } else {
                    object.scope = false;
                }
                if (i == length - 1) {
                    this.gc().indexTank = length;
                }
            } else {
                this.gc().indexTank = i;
                break;
            }
            sprite = null;
        }
    }

    private void buildBoss(int level) {
        int i = 0;
        int posAppend = 0;
        switch (level) {
            case 0: 
            case 1: 
            case 2: {
                int row = SetMap.bossLevel[level][0];
                int col = SetMap.bossLevel[level][1];
                int x = this.gc().mapX + col * this.gc().map.getCellWidth();
                int y = this.gc().mapY + row * this.gc().map.getCellHeight();
                int height = this.gc().BossShip.getHeight();
                if (y + height < this.gc().screenY || this.gc().Boss != null) break;
                this.gc().Boss = new GameObject(new Sprite(this.gc().BossShip), -1, 100);
                this.gc().Boss.append(this.midlet);
                this.gc().Boss.ObjectX = x;
                this.gc().Boss.ObjectY = y;
                this.gc().Boss.mainSprite.setPosition(x, y);
                this.gc().Boss.extendInit();
                this.gc().Boss.frameTime = 0;
                this.gc().Boss.fireTime = 0;
                this.gc().Boss.step = 0;
                if (this.gc().layer[2] > 0) {
                    posAppend = this.gc().layer[0] + this.gc().layer[1];
                    this.gc().layerManager.insert((Layer)this.gc().Boss.mainSprite, posAppend);
                    for (i = 0; i < this.gc().Boss.gunSprite.length; ++i) {
                        this.gc().layerManager.insert((Layer)this.gc().Boss.gunSprite[i], posAppend);
                    }
                } else {
                    for (i = 0; i < this.gc().Boss.gunSprite.length; ++i) {
                        this.gc().layerManager.append((Layer)this.gc().Boss.gunSprite[i]);
                    }
                    this.gc().layerManager.append((Layer)this.gc().Boss.mainSprite);
                }
                this.gc().Boss.mainSprite.setVisible(true);
                this.gc().layer[1] = this.gc().layer[1] + 1 + this.gc().Boss.gunSprite.length;
                this.gc().Boss.scope = true;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                int row = SetMap.bossLevel[level][0];
                int col = SetMap.bossLevel[level][1];
                int x = this.gc().mapX + col * this.gc().map.getCellWidth();
                int y = this.gc().mapY + row * this.gc().map.getCellHeight();
                int height = this.gc().BossPlane.getHeight();
                if (y + height < this.gc().screenY || this.gc().Boss != null) break;
                this.gc().Boss = new GameObject(new Sprite(this.gc().BossPlane), -2, 200);
                this.gc().Boss.append(this.midlet);
                this.gc().Boss.ObjectX = x;
                this.gc().Boss.ObjectY = y;
                this.gc().Boss.mainSprite.setPosition(x, y);
                this.gc().Boss.extendInit();
                this.gc().Boss.frameTime = 0;
                this.gc().Boss.fireTime = 0;
                this.gc().Boss.step = 0;
                if (this.gc().layer[1] + this.gc().layer[2] > 0) {
                    posAppend = this.gc().layer[0];
                    this.gc().layerManager.insert((Layer)this.gc().Boss.mainSprite, posAppend);
                    for (i = 0; i < this.gc().Boss.gunSprite.length; ++i) {
                        this.gc().layerManager.insert((Layer)this.gc().Boss.gunSprite[i], posAppend);
                    }
                } else {
                    for (i = 0; i < this.gc().Boss.gunSprite.length; ++i) {
                        this.gc().layerManager.append((Layer)this.gc().Boss.gunSprite[i]);
                    }
                    this.gc().layerManager.append((Layer)this.gc().Boss.mainSprite);
                }
                this.gc().Boss.mainSprite.setVisible(true);
                this.gc().layer[0] = this.gc().layer[0] + 1 + this.gc().Boss.gunSprite.length;
                this.gc().Boss.scope = true;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                if (this.gc().mapY + this.gc().Fortress.getHeight() < this.gc().screenY || this.gc().Boss != null) break;
                int x = this.gc().screenWidth / 2 - this.gc().Fortress.getWidth() / 2;
                int y = this.gc().mapY;
                this.gc().Boss = new GameObject(new Sprite(this.gc().Fortress), -3, 300);
                this.gc().Boss.append(this.midlet);
                this.gc().Boss.ObjectX = x;
                this.gc().Boss.ObjectY = y;
                this.gc().Boss.mainSprite.setPosition(x, y);
                this.gc().Boss.extendInit();
                this.gc().Boss.frameTime = 0;
                this.gc().Boss.fireTime = 0;
                this.gc().Boss.step = 0;
                this.gc().layerManager.insert((Layer)this.gc().leftGate, this.gc().layer[0] + this.gc().layer[1]);
                this.gc().layerManager.insert((Layer)this.gc().rightGate, this.gc().layer[0] + this.gc().layer[1]);
                for (i = 0; i < this.gc().Boss.gunSprite.length; ++i) {
                    this.gc().layerManager.append((Layer)this.gc().Boss.gunSprite[i]);
                }
                this.gc().layerManager.append((Layer)this.gc().Boss.mainSprite);
                this.gc().layer[2] = this.gc().layer[2] + 1 + this.gc().Boss.gunNum + 2;
                x = this.gc().Boss.mainSprite.getX();
                y = this.gc().Boss.mainSprite.getY();
                this.gc().leftGate.setPosition(x, y);
                x = this.gc().Boss.mainSprite.getX();
                y = this.gc().Boss.mainSprite.getY();
                this.gc().rightGate.setPosition(x, y);
                this.gc().leftGate.setVisible(false);
                this.gc().rightGate.setVisible(false);
                this.gc().Boss.scope = true;
            }
        }
    }

    private void buildSmallPlane(int kind) {
        boolean choose = false;
        int x = 0;
        int y = 0;
        int i = 0;
        int j = 0;
        int jj = 0;
        int posAppend = 0;
        int str = 0;
        Sprite sprite = null;
        GameObject object = null;
        if (this.gc().numSmallPlane == 0) {
            this.gc().layoutPlane = this.rand.nextInt(6) + 1;
            this.setXY(this.gc().layoutPlane);
            str = this.healthMax(kind, this.level);
            sprite = kind == 1 ? this.gc().plane1 : this.gc().plane2;
            for (i = 0; i < 8; ++i) {
                choose = false;
                for (j = jj; j < this.gc().Enemy.size(); ++j) {
                    object = (GameObject)this.gc().Enemy.elementAt(j);
                    if (object.free) {
                        object.free = false;
                        object.mainSprite = null;
                        object.mainSprite = new Sprite(sprite);
                        object.type = kind;
                        object.strength = str;
                        choose = true;
                    }
                    if (!choose) continue;
                    jj = j + 1;
                    break;
                }
                if (!choose) {
                    object = new GameObject(new Sprite(sprite), kind, str);
                    object.append(this.midlet);
                    jj = j;
                    this.gc().Enemy.addElement(object);
                }
                ++this.gc().numSmallPlane;
                object.extendInit();
                x = this.gc().PlaneX[this.gc().numSmallPlane - 1];
                y = this.gc().PlaneY[this.gc().numSmallPlane - 1];
                object.ObjectX = x;
                object.ObjectY = y;
                object.frameTime = 0;
                if (this.gc().layoutPlane == 5 || this.gc().layoutPlane == 6) {
                    object.frameTime = (this.gc().numSmallPlane - 1) / 4;
                }
                object.step = 0;
                posAppend = this.gc().layer[0];
                if (this.gc().layer[1] + this.gc().layer[2] == 0) {
                    this.gc().layerManager.append((Layer)object.mainSprite);
                } else {
                    this.gc().layerManager.insert((Layer)object.mainSprite, posAppend);
                }
                object.mainSprite.setPosition(x, y);
                if (this.gc().indexPlane == SetMap.planeLevel[this.level].length - 1) {
                    this.gc().indexPlane = SetMap.planeLevel[this.level].length;
                    break;
                }
                this.gc().layer[1] = this.gc().layer[1] + 1;
            }
        }
    }

    private void buildHelicopter() {
        boolean position = false;
        int x = 0;
        int y = 0;
        int i = 0;
        int j = 0;
        int jj = 0;
        boolean choose = false;
        int kind = 0;
        int posAppend = 0;
        int str = 0;
        GameObject object = null;
        if (this.gc().numHelicopter == 0) {
            kind = this.rand.nextInt(4) + 1;
            str = this.healthMax(3, this.level);
            for (i = 0; i < 3; ++i) {
                choose = false;
                switch (this.gc().numHelicopter) {
                    case 0: {
                        x = this.gc().screenX;
                        break;
                    }
                    case 1: {
                        x = this.gc().screenX + this.gc().ViewWidth / 2 - this.gc().plane3.getWidth() / 2;
                        break;
                    }
                    case 2: {
                        x = this.gc().screenX + this.gc().ViewWidth - this.gc().plane3.getWidth();
                    }
                }
                y = kind == 0 ? (this.gc().numHelicopter != 1 ? this.gc().screenY - this.gc().plane3.getHeight() : this.gc().screenY - 2 * this.gc().plane3.getHeight()) : (this.gc().numHelicopter != 1 ? this.gc().screenY - 2 * this.gc().plane3.getHeight() : this.gc().screenY - this.gc().plane3.getHeight());
                for (j = jj; j < this.gc().Enemy.size(); ++j) {
                    object = (GameObject)this.gc().Enemy.elementAt(j);
                    if (object.free) {
                        object.free = false;
                        object.mainSprite = null;
                        object.mainSprite = new Sprite(this.gc().plane3);
                        object.type = 3;
                        object.strength = str;
                        choose = true;
                    }
                    if (!choose) continue;
                    jj = j + 1;
                    break;
                }
                if (!choose) {
                    object = new GameObject(new Sprite(this.gc().plane3), 3, str);
                    object.append(this.midlet);
                    jj = j;
                    this.gc().Enemy.addElement(object);
                }
                ++this.gc().numHelicopter;
                object.extendInit();
                object.frameTime = 0;
                object.step = 0;
                object.fireTime = 0;
                object.ObjectX = x;
                object.ObjectY = y;
                if (this.gc().layer[2] == 0) {
                    this.gc().layerManager.append((Layer)object.mainSprite);
                } else {
                    posAppend = this.gc().layer[1];
                    this.gc().layerManager.insert((Layer)object.mainSprite, posAppend);
                }
                this.gc().layer[1] = this.gc().layer[1] + 1;
                object.mainSprite.setPosition(x, y);
                if (this.gc().scopeInSky > 0) {
                    object.scope = true;
                    --this.gc().scopeInSky;
                } else {
                    object.scope = false;
                }
                if (this.gc().indexPlane != SetMap.planeLevel[this.level].length - 1) continue;
                this.gc().indexPlane = SetMap.planeLevel[this.level].length;
                break;
            }
        }
    }

    private void buildMediumPlane() {
        boolean position = false;
        int x = 0;
        int y = 0;
        int i = 0;
        int j = 0;
        int jj = 0;
        boolean choose = false;
        int posAppend = 0;
        int str = 0;
        int maxPlane = 1;
        GameObject object = null;
        if (this.gc().numMediumPlane == 0) {
            str = this.healthMax(4, this.level);
            for (i = 0; i < maxPlane; ++i) {
                choose = false;
                for (j = jj; j < this.gc().Enemy.size(); ++j) {
                    object = (GameObject)this.gc().Enemy.elementAt(j);
                    x = this.gc().screenX == 0 ? this.gc().ViewWidth - this.gc().plane4.getWidth() : (this.gc().screenX == this.gc().screenWidth - this.gc().ViewWidth ? this.gc().screenX : (this.gc().leftKey ? this.gc().screenX : this.gc().screenX + this.gc().ViewWidth - this.gc().plane4.getWidth()));
                    y = this.gc().screenY + this.gc().screenHeight;
                    if (object.free) {
                        object.free = false;
                        object.mainSprite = null;
                        object.mainSprite = new Sprite(this.gc().plane4);
                        object.type = 4;
                        object.strength = str;
                        choose = true;
                    }
                    if (!choose) continue;
                    jj = j + 1;
                    break;
                }
                if (!choose) {
                    object = new GameObject(new Sprite(this.gc().plane4), 4, str);
                    object.append(this.midlet);
                    jj = j;
                    this.gc().Enemy.addElement(object);
                }
                ++this.gc().numMediumPlane;
                object.extendInit();
                object.frameTime = 0;
                object.step = 0;
                object.fireTime = 0;
                object.ObjectX = x;
                object.ObjectY = y;
                if (this.gc().layer[2] == 0) {
                    this.gc().layerManager.append((Layer)object.mainSprite);
                } else {
                    posAppend = this.gc().layer[1];
                    this.gc().layerManager.insert((Layer)object.mainSprite, posAppend);
                }
                this.gc().layer[1] = this.gc().layer[1] + 1;
                object.mainSprite.setPosition(x, y);
                if (this.gc().scopeInSky > 0) {
                    --this.gc().scopeInSky;
                    object.scope = true;
                } else {
                    object.scope = false;
                }
                if (this.gc().indexPlane != SetMap.planeLevel[this.level].length - 1) continue;
                this.gc().indexPlane = SetMap.planeLevel[this.level].length;
                break;
            }
        }
    }

    public int healthMax(int type, int level) {
        int result = type;
        if (type < 0) {
            result = (level % 3 + 1) * 100;
        }
        return result;
    }

    public int distanceX(GameObject object, int type, int position, int aspect) {
        int step = 3;
        int result = 0;
        int width = object.mainSprite.getWidth();
        int height = object.mainSprite.getHeight();
        int w = object.gunSprite[position].getWidth();
        int h = object.gunSprite[position].getHeight();
        block0 : switch (type) {
            case 5: {
                switch (aspect) {
                    case 6: {
                        result = 1;
                        break;
                    }
                    case 0: {
                        if (this.gc().ViewWidth >= 200) {
                            result = width - 21 - w;
                            break;
                        }
                        result = 11;
                        break;
                    }
                    case 4: {
                        result = this.gc().ViewWidth >= 200 ? 21 : 14;
                    }
                }
                break;
            }
            case 6: {
                result = 0;
                break;
            }
            case 7: {
                if (this.gc().ViewWidth >= 200) {
                    if (width < height) {
                        result = 2;
                        break;
                    }
                    result = 9;
                    break;
                }
                if (width < height) {
                    result = 3;
                    break;
                }
                result = 6;
                break;
            }
            case 9: {
                switch (position) {
                    case 0: 
                    case 1: {
                        result = this.gc().ViewWidth >= 200 ? 12 : 8;
                    }
                }
                break;
            }
            case -1: {
                switch (position) {
                    case 0: {
                        result = 3;
                        break;
                    }
                    case 1: {
                        if (this.gc().ViewWidth >= 200) {
                            result = 0;
                            break;
                        }
                        result = 1;
                        break;
                    }
                    case 2: {
                        result = this.gc().ViewWidth >= 200 ? 18 : 10;
                    }
                }
                break;
            }
            case -2: {
                switch (position) {
                    case 0: {
                        if (this.gc().ViewWidth >= 200) {
                            result = 35;
                            break;
                        }
                        result = 24;
                        break;
                    }
                    case 1: {
                        if (this.gc().ViewWidth >= 200) {
                            result = 53;
                            break;
                        }
                        result = 37;
                        break;
                    }
                    case 2: {
                        if (this.gc().ViewWidth >= 200) {
                            result = 19;
                            break;
                        }
                        result = 14;
                        break;
                    }
                    case 3: {
                        if (this.gc().ViewWidth >= 200) {
                            result = 43;
                            break;
                        }
                        result = 31;
                        break;
                    }
                    case 4: {
                        result = this.gc().ViewWidth >= 200 ? 69 : 48;
                    }
                }
                break;
            }
            case -3: {
                switch (position) {
                    case 0: {
                        if (this.gc().ViewWidth >= 200) {
                            result = 25;
                            break block0;
                        }
                        result = 17;
                        break block0;
                    }
                    case 1: {
                        if (this.gc().ViewWidth >= 200) {
                            result = 55;
                            break block0;
                        }
                        result = 37;
                        break block0;
                    }
                    case 2: {
                        result = this.gc().ViewWidth >= 200 ? 86 : 58;
                    }
                }
            }
        }
        return result;
    }

    public int distanceY(GameObject object, int type, int position, int aspect) {
        int step = 3;
        int result = 0;
        int width = object.mainSprite.getWidth();
        int height = object.mainSprite.getHeight();
        int w = object.gunSprite[position].getWidth();
        int h = object.gunSprite[position].getHeight();
        block0 : switch (type) {
            case 5: {
                switch (aspect) {
                    case 6: {
                        if (this.gc().ViewWidth >= 200) {
                            result = 21;
                            break;
                        }
                        result = 16;
                        break;
                    }
                    case 0: {
                        if (this.gc().ViewWidth >= 200) {
                            result = 1;
                            break;
                        }
                        result = 2;
                        break;
                    }
                    case 4: {
                        result = this.gc().ViewWidth >= 200 ? height - 1 - h : 4;
                    }
                }
                break;
            }
            case 6: {
                result = 0;
                break;
            }
            case 7: {
                if (this.gc().ViewWidth >= 200) {
                    if (width < height) {
                        result = 9;
                        break;
                    }
                    result = 2;
                    break;
                }
                if (width < height) {
                    result = 6;
                    break;
                }
                result = 3;
                break;
            }
            case 9: {
                switch (position) {
                    case 0: {
                        if (this.gc().ViewWidth >= 200) {
                            result = 0;
                            break;
                        }
                        result = 4;
                        break;
                    }
                    case 1: {
                        result = this.gc().ViewWidth >= 200 ? 36 : 19;
                    }
                }
                break;
            }
            case -1: {
                switch (position) {
                    case 0: {
                        if (this.gc().ViewWidth >= 200) {
                            result = 20;
                            break;
                        }
                        result = 14;
                        break;
                    }
                    case 1: {
                        if (this.gc().ViewWidth >= 200) {
                            result = 48;
                            break;
                        }
                        result = 34;
                        break;
                    }
                    case 2: {
                        result = this.gc().ViewWidth >= 200 ? 48 : 34;
                    }
                }
                break;
            }
            case -2: {
                switch (position) {
                    case 0: {
                        if (this.gc().ViewWidth >= 200) {
                            result = 74;
                            break;
                        }
                        result = 52;
                        break;
                    }
                    case 1: {
                        if (this.gc().ViewWidth >= 200) {
                            result = 74;
                            break;
                        }
                        result = 52;
                        break;
                    }
                    case 2: {
                        if (this.gc().ViewWidth >= 200) {
                            result = 25;
                            break;
                        }
                        result = 17;
                        break;
                    }
                    case 3: {
                        if (this.gc().ViewWidth >= 200) {
                            result = 28;
                            break;
                        }
                        result = 20;
                        break;
                    }
                    case 4: {
                        result = this.gc().ViewWidth >= 200 ? 25 : 17;
                    }
                }
                break;
            }
            case -3: {
                switch (position) {
                    case 0: {
                        if (this.gc().ViewWidth >= 200) {
                            result = 76;
                            break block0;
                        }
                        result = 51;
                        break block0;
                    }
                    case 1: {
                        if (this.gc().ViewWidth >= 200) {
                            result = 78;
                            break block0;
                        }
                        result = 52;
                        break block0;
                    }
                    case 2: {
                        result = this.gc().ViewWidth >= 200 ? 71 : 47;
                    }
                }
            }
        }
        return result;
    }

    private void setXY(int layout) {
        int i = 0;
        int x = 0;
        int y = 0;
        int speed = 6;
        switch (layout) {
            case 1: {
                x = this.gc().screenX;
                y = this.gc().screenY - this.gc().plane1.getHeight();
                for (i = 0; i < 4; ++i) {
                    this.gc().PlaneX[i] = x;
                    this.gc().PlaneY[i] = y;
                    x -= 2 * this.gc().plane1.getWidth();
                    y -= 2 * this.gc().plane1.getHeight();
                }
                x = this.gc().screenX + 2 * this.gc().plane1.getWidth();
                y = this.gc().screenY - this.gc().plane1.getHeight();
                for (i = 4; i < 8; ++i) {
                    this.gc().PlaneX[i] = x;
                    this.gc().PlaneY[i] = y;
                    x -= 2 * this.gc().plane1.getWidth();
                    y -= 2 * this.gc().plane1.getHeight();
                }
                break;
            }
            case 2: {
                x = this.gc().screenX + this.gc().ViewWidth - this.gc().plane1.getWidth();
                y = this.gc().screenY - this.gc().plane1.getHeight();
                for (i = 0; i < 4; ++i) {
                    this.gc().PlaneX[i] = x;
                    this.gc().PlaneY[i] = y;
                    x += 2 * this.gc().plane1.getWidth();
                    y -= 2 * this.gc().plane1.getHeight();
                }
                x = this.gc().screenX + this.gc().ViewWidth - 3 * this.gc().plane1.getWidth();
                y = this.gc().screenY - this.gc().plane1.getHeight();
                for (i = 4; i < 8; ++i) {
                    this.gc().PlaneX[i] = x;
                    this.gc().PlaneY[i] = y;
                    x += 2 * this.gc().plane1.getWidth();
                    y -= 2 * this.gc().plane1.getHeight();
                }
                break;
            }
            case 3: {
                x = this.gc().screenX;
                y = this.gc().screenY - this.gc().plane1.getHeight();
                for (i = 0; i < 8; ++i) {
                    this.gc().PlaneX[i] = x;
                    this.gc().PlaneY[i] = y;
                    y -= 3 * this.gc().plane1.getHeight() / speed * speed;
                }
                break;
            }
            case 4: {
                x = this.gc().screenX + this.gc().ViewWidth - this.gc().plane1.getWidth();
                y = this.gc().screenY - this.gc().plane1.getHeight();
                for (i = 0; i < 8; ++i) {
                    this.gc().PlaneX[i] = x;
                    this.gc().PlaneY[i] = y;
                    y -= 3 * this.gc().plane1.getHeight() / speed * speed;
                }
                break;
            }
            case 5: {
                x = this.gc().screenX - this.gc().plane1.getWidth();
                y = this.gc().screenY + this.gc().ViewHeight / 2;
                for (i = 0; i < 4; ++i) {
                    this.gc().PlaneX[i] = x;
                    this.gc().PlaneY[i] = y;
                    x -= 3 * this.gc().plane1.getWidth() / speed * speed;
                    y += 3 * this.gc().plane1.getHeight() / speed * speed;
                }
                x = this.gc().screenX + this.gc().ViewWidth;
                y = this.gc().screenY + this.gc().ViewHeight / 2;
                for (i = 4; i < 8; ++i) {
                    this.gc().PlaneX[i] = x;
                    this.gc().PlaneY[i] = y;
                    x += 3 * this.gc().plane1.getWidth() / speed * speed;
                    y += 3 * this.gc().plane1.getHeight() / speed * speed;
                }
                break;
            }
            case 6: {
                x = this.gc().screenX + this.gc().ViewWidth / 4 - this.gc().plane1.getWidth();
                y = this.gc().screenY - this.gc().plane1.getHeight();
                for (i = 0; i < 4; ++i) {
                    this.gc().PlaneX[i] = x;
                    this.gc().PlaneY[i] = y;
                    x -= 2 * this.gc().plane1.getWidth();
                    y -= 2 * this.gc().plane1.getHeight();
                }
                x = this.gc().screenX + 3 * this.gc().ViewWidth / 4;
                y = this.gc().screenY - this.gc().plane1.getHeight();
                for (i = 4; i < 8; ++i) {
                    this.gc().PlaneX[i] = x;
                    this.gc().PlaneY[i] = y;
                    x += 2 * this.gc().plane1.getWidth();
                    y -= 2 * this.gc().plane1.getHeight();
                }
                break;
            }
        }
    }
}

