/*
 * Decompiled with CFR 0.152.
 */
package com.motorola.graphics.j3d;

import com.motorola.graphics.j3d.AffineTrans;
import com.motorola.graphics.j3d.Effect3D;
import com.motorola.graphics.j3d.Figure;
import com.motorola.graphics.j3d.FigureLayout;
import com.motorola.graphics.j3d.Light;
import com.motorola.graphics.j3d.Texture;
import com.motorola.graphics.j3d.Vector3D;
import javax.microedition.lcdui.Graphics;
import ru.woesss.j2me.micro3d.Render;

public class RenderProxy {
    public static void drawFigure(Graphics graphics, Figure figure, int n2, int n3, FigureLayout figureLayout, Effect3D effect3D) {
        if (figure == null || figureLayout == null || effect3D == null) {
            throw new NullPointerException();
        }
        Render render = Render.getRender();
        render.bind(graphics);
        RenderProxy.getViewTrans(figureLayout.affine, render.getViewMatrix());
        render.setCenter(figureLayout.centerX + n2, figureLayout.centerY + n3);
        render.setOrthographicScale(figureLayout.scaleX, figureLayout.scaleY);
        int n4 = render.getAttributes();
        Light light = effect3D.light;
        if (light != null) {
            n4 |= 1;
            Vector3D vector3D = light.direction;
            render.setLight(light.ambIntensity, light.dirIntensity, vector3D.x, vector3D.y, vector3D.z);
        } else {
            n4 &= 0xFFFFFFFE;
        }
        int n5 = effect3D.shading;
        if (n5 == 1) {
            n4 |= 4;
            int n6 = effect3D.toonThreshold;
            int n7 = effect3D.toonHigh;
            int n8 = effect3D.toonLow;
            render.setToonParam(n6, n7, n8);
        } else {
            n4 &= 0xFFFFFFFB;
        }
        n4 = effect3D.isTransparency ? (n4 |= 8) : (n4 &= 0xFFFFFFF7);
        Texture texture = effect3D.texture;
        if (texture != null) {
            n4 |= 2;
            render.setSphereTexture(texture.impl);
        } else {
            n4 &= 0xFFFFFFFD;
        }
        render.setAttribute(n4);
        Texture texture2 = figure.texture;
        if (texture2 != null) {
            render.setTexture(texture2.impl);
        }
        render.drawFigure(figure.impl);
        render.release();
    }

    private static void getViewTrans(AffineTrans affineTrans, float[] fArray) {
        fArray[0] = (float)affineTrans.m00 * 2.4414062E-4f;
        fArray[3] = (float)affineTrans.m01 * 2.4414062E-4f;
        fArray[6] = (float)affineTrans.m02 * 2.4414062E-4f;
        fArray[9] = affineTrans.m03;
        fArray[1] = (float)affineTrans.m10 * 2.4414062E-4f;
        fArray[4] = (float)affineTrans.m11 * 2.4414062E-4f;
        fArray[7] = (float)affineTrans.m12 * 2.4414062E-4f;
        fArray[10] = affineTrans.m13;
        fArray[2] = (float)affineTrans.m20 * 2.4414062E-4f;
        fArray[5] = (float)affineTrans.m21 * 2.4414062E-4f;
        fArray[8] = (float)affineTrans.m22 * 2.4414062E-4f;
        fArray[11] = affineTrans.m23;
    }
}

