/*
 * Decompiled with CFR 0.152.
 */
package com.motorola.iden.micro3d;

import com.motorola.iden.micro3d.Layout3D;
import com.motorola.iden.micro3d.Primitive;
import com.motorola.iden.micro3d.Texture;
import com.motorola.iden.micro3d.Vector3D;

public class Quadrangle
extends Primitive {
    Vector3D[] normals;
    final int[] textureCoords = new int[8];
    boolean hasFaceNormal;

    public Quadrangle(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3, Vector3D vector3D4, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Layout3D layout3D, Texture texture) {
        this(vector3D, vector3D2, vector3D3, vector3D4, layout3D);
        this.textureCoords[0] = n2;
        this.textureCoords[1] = n3;
        this.textureCoords[2] = n4;
        this.textureCoords[3] = n5;
        this.textureCoords[4] = n6;
        this.textureCoords[5] = n7;
        this.textureCoords[6] = n8;
        this.textureCoords[7] = n9;
        this.setTexture(texture);
    }

    public Quadrangle(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3, Vector3D vector3D4, Layout3D layout3D, int n2) {
        this(vector3D, vector3D2, vector3D3, vector3D4, layout3D);
        this.setColor(n2);
    }

    public Quadrangle(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3, Vector3D vector3D4, Vector3D vector3D5, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Layout3D layout3D, Texture texture) {
        this(vector3D, vector3D2, vector3D3, vector3D4, layout3D);
        if (vector3D5 == null) {
            throw new NullPointerException();
        }
        this.hasFaceNormal = true;
        this.normals = new Vector3D[]{vector3D5};
        this.textureCoords[0] = n2;
        this.textureCoords[1] = n3;
        this.textureCoords[2] = n4;
        this.textureCoords[3] = n5;
        this.textureCoords[4] = n6;
        this.textureCoords[5] = n7;
        this.textureCoords[6] = n8;
        this.textureCoords[7] = n9;
        this.setTexture(texture);
    }

    public Quadrangle(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3, Vector3D vector3D4, Vector3D vector3D5, Layout3D layout3D, int n2) {
        this(vector3D, vector3D2, vector3D3, vector3D4, layout3D);
        if (vector3D5 == null) {
            throw new NullPointerException();
        }
        this.hasFaceNormal = true;
        this.normals = new Vector3D[]{vector3D5};
        this.setColor(n2);
    }

    public Quadrangle(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3, Vector3D vector3D4, Vector3D vector3D5, Vector3D vector3D6, Vector3D vector3D7, Vector3D vector3D8, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Layout3D layout3D, Texture texture) {
        this(vector3D, vector3D2, vector3D3, vector3D4, layout3D);
        if (vector3D5 == null && vector3D6 == null && vector3D7 == null && vector3D8 == null) {
            throw new NullPointerException();
        }
        this.normals = new Vector3D[]{vector3D5, vector3D6, vector3D7, vector3D8};
        this.textureCoords[0] = n2;
        this.textureCoords[1] = n3;
        this.textureCoords[2] = n4;
        this.textureCoords[3] = n5;
        this.textureCoords[4] = n6;
        this.textureCoords[5] = n7;
        this.textureCoords[6] = n8;
        this.textureCoords[7] = n9;
        this.setTexture(texture);
    }

    public Quadrangle(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3, Vector3D vector3D4, Vector3D vector3D5, Vector3D vector3D6, Vector3D vector3D7, Vector3D vector3D8, Layout3D layout3D, int n2) {
        this(vector3D, vector3D2, vector3D3, vector3D4, layout3D);
        if (vector3D5 == null && vector3D6 == null && vector3D7 == null && vector3D8 == null) {
            throw new NullPointerException();
        }
        this.normals = new Vector3D[]{vector3D5, vector3D6, vector3D7, vector3D8};
        this.setColor(n2);
    }

    private Quadrangle(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3, Vector3D vector3D4, Layout3D layout3D) {
        super(4);
        if (vector3D == null && vector3D2 == null && vector3D3 == null && vector3D4 == null) {
            throw new NullPointerException();
        }
        this.vertices[0] = vector3D;
        this.vertices[1] = vector3D2;
        this.vertices[2] = vector3D3;
        this.vertices[3] = vector3D4;
        this.setLayout(layout3D);
    }

    public int getTextureCoordinateX(int n2) {
        if (n2 < 1 || n2 > 4) {
            throw new IllegalArgumentException();
        }
        return this.textureCoords[(n2 - 1) * 2];
    }

    public int getTextureCoordinateY(int n2) {
        if (n2 < 1 || n2 > 4) {
            throw new IllegalArgumentException();
        }
        return this.textureCoords[(n2 - 1) * 2 + 1];
    }

    @Override
    public Vector3D getVector(int n2) {
        if (n2 == 32) {
            return this.hasFaceNormal ? this.normals[0] : null;
        }
        int n3 = n2 & 0xFFFFFFEF;
        if (n3 < 1 || n3 > 4) {
            throw new IllegalArgumentException();
        }
        if ((n2 & 0x10) != 0) {
            if (this.hasFaceNormal || this.normals == null) {
                return null;
            }
            return this.normals[n3 - 1];
        }
        return this.vertices[n3 - 1];
    }

    public void setTextureCoordinates(int n2, int n3, int n4) {
        if (n2 < 1 || n2 > 4) {
            throw new IllegalArgumentException();
        }
        int n5 = (n2 - 1) * 2;
        this.textureCoords[n5++] = n3;
        this.textureCoords[n5] = n4;
    }

    @Override
    public void setVector(int n2, Vector3D vector3D) {
        if (vector3D == null) {
            throw new NullPointerException();
        }
        if (n2 == 32) {
            this.hasFaceNormal = true;
            if (this.normals == null) {
                this.normals = new Vector3D[]{vector3D};
            } else {
                this.normals[0] = vector3D;
            }
            return;
        }
        int n3 = n2 & 0xFFFFFFEF;
        if (n3 < 1 || n3 > 4) {
            throw new IllegalArgumentException();
        }
        if ((n2 & 0x10) != 0) {
            if (this.normals == null || this.hasFaceNormal) {
                this.normals = new Vector3D[3];
            }
            this.normals[n3 - 1] = vector3D;
        } else {
            this.vertices[n3 - 1] = vector3D;
        }
    }
}

