/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.game;

import com.siemens.mp.game.ExtendedImage;
import com.siemens.mp.game.GraphicObject;
import java.awt.Rectangle;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TiledBackground
extends GraphicObject {
    private static final String TAG = TiledBackground.class.getName();
    private Image pixels;
    private byte[][] map;
    private int widthInTiles;
    private int heightInTiles;
    private int posX;
    private int posY;
    private Rectangle frame = new Rectangle(0, 0, 8, 8);
    private Rectangle dst = new Rectangle(0, 0, 8, 8);

    public TiledBackground(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) {
        this(com.siemens.mp.ui.Image.createImageFromBitmap(byArray, byArray2, 8, byArray.length), null, byArray3, n2, n3);
    }

    public TiledBackground(ExtendedImage extendedImage, ExtendedImage extendedImage2, byte[] byArray, int n2, int n3) {
        this(extendedImage.getImage(), extendedImage2 == null ? null : extendedImage2.getImage(), byArray, n2, n3);
    }

    public TiledBackground(Image image, Image image2, byte[] byArray, int n2, int n3) {
        this.map = new byte[n3][n2];
        this.heightInTiles = n3;
        this.widthInTiles = n2;
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            byte[] byArray2 = this.map[i2];
            for (int i3 = 0; i3 < n2; ++i3) {
                byArray2[i3] = byArray[n4++];
            }
        }
        this.pixels = image;
    }

    public void setPositionInMap(int n2, int n3) {
        this.posX = n2;
        this.posY = n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paint(Graphics graphics, int n2, int n3) {
        int n4 = graphics.getClipX();
        int n5 = graphics.getClipY();
        int n6 = graphics.getClipWidth();
        int n7 = graphics.getClipHeight();
        Rectangle rectangle = new Rectangle(n4, n5, n6, n7);
        rectangle.x = Math.max(rectangle.x, n2);
        rectangle.y = Math.max(rectangle.y, n3);
        graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int n8 = n2 - this.posX % 8;
        int n9 = n3 - this.posY % 8;
        this.dst.x = n8;
        this.dst.y = n9;
        try {
            int n10;
            int n11 = rectangle.height / 8 + 1 + n10;
            for (n10 = this.posY / 8; n10 < n11; ++n10) {
                int n12;
                byte[] byArray = this.map[n10 % this.heightInTiles];
                int n13 = rectangle.width / 8 + 1 + n12;
                for (n12 = this.posX / 8; n12 < n13; ++n12) {
                    int n14 = byArray[n12 % this.widthInTiles] & 0xFF;
                    switch (n14) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            graphics.setColor(-1);
                            graphics.fillRect(this.dst.x, this.dst.y, this.dst.width, this.dst.height);
                            break;
                        }
                        case 2: {
                            graphics.setColor(0);
                            graphics.fillRect(this.dst.x, this.dst.y, this.dst.width, this.dst.height);
                            break;
                        }
                        default: {
                            this.frame.x = 0;
                            this.frame.y = (n14 - 3) * 8;
                            graphics.drawRegion(this.pixels, this.frame.x, this.frame.y, this.dst.width, this.dst.height, 0, this.dst.x, this.dst.y, 0);
                        }
                    }
                    this.dst.x += 8;
                }
                this.dst.x = n8;
                this.dst.y += 8;
                this.dst.width = 8;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            graphics.setClip(n4, n5, n6, n7);
        }
    }
}

