/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform;

import com.sun.jna.Pointer;
import com.sun.jna.platform.WindowUtils$NativeWindowUtils$TransparentContentPane;
import com.sun.jna.platform.WindowUtils$W32WindowUtils;
import com.sun.jna.platform.win32.GDI32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinDef$HBITMAP;
import com.sun.jna.platform.win32.WinDef$POINT;
import com.sun.jna.platform.win32.WinGDI$BITMAPINFO;
import com.sun.jna.platform.win32.WinNT$HANDLE;
import com.sun.jna.platform.win32.WinUser$BLENDFUNCTION;
import com.sun.jna.platform.win32.WinUser$SIZE;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import javax.swing.SwingUtilities;

class WindowUtils$W32WindowUtils$W32TransparentContentPane
extends WindowUtils$NativeWindowUtils$TransparentContentPane {
    private static final long serialVersionUID = 1L;
    private WinDef.HDC memDC;
    private WinDef$HBITMAP hBitmap;
    private Pointer pbits;
    private Dimension bitmapSize;
    final /* synthetic */ WindowUtils$W32WindowUtils this$0;

    public WindowUtils$W32WindowUtils$W32TransparentContentPane(WindowUtils$W32WindowUtils windowUtils$W32WindowUtils, Container container) {
        this.this$0 = windowUtils$W32WindowUtils;
        super(windowUtils$W32WindowUtils, container);
    }

    private void disposeBackingStore() {
        GDI32 gDI32 = GDI32.INSTANCE;
        if (this.hBitmap != null) {
            gDI32.DeleteObject(this.hBitmap);
            this.hBitmap = null;
        }
        if (this.memDC != null) {
            gDI32.DeleteDC(this.memDC);
            this.memDC = null;
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.disposeBackingStore();
    }

    @Override
    public void setTransparent(boolean bl2) {
        super.setTransparent(bl2);
        if (!bl2) {
            this.disposeBackingStore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintDirect(BufferedImage bufferedImage, Rectangle rectangle) {
        Window window = SwingUtilities.getWindowAncestor(this);
        GDI32 gDI32 = GDI32.INSTANCE;
        User32 user32 = User32.INSTANCE;
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        Point point = SwingUtilities.convertPoint(this, n2, n3, window);
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = window.getWidth();
        int n7 = window.getHeight();
        WinDef.HDC hDC = user32.GetDC(null);
        WinNT$HANDLE winNT$HANDLE = null;
        try {
            Object object;
            Object object2;
            if (this.memDC == null) {
                this.memDC = gDI32.CreateCompatibleDC(hDC);
            }
            if (this.hBitmap == null || !window.getSize().equals(this.bitmapSize)) {
                if (this.hBitmap != null) {
                    gDI32.DeleteObject(this.hBitmap);
                    this.hBitmap = null;
                }
                object2 = new WinGDI$BITMAPINFO();
                ((WinGDI$BITMAPINFO)object2).bmiHeader.biWidth = n6;
                ((WinGDI$BITMAPINFO)object2).bmiHeader.biHeight = n7;
                ((WinGDI$BITMAPINFO)object2).bmiHeader.biPlanes = 1;
                ((WinGDI$BITMAPINFO)object2).bmiHeader.biBitCount = (short)32;
                ((WinGDI$BITMAPINFO)object2).bmiHeader.biCompression = 0;
                ((WinGDI$BITMAPINFO)object2).bmiHeader.biSizeImage = n6 * n7 * 4;
                object = new PointerByReference();
                this.hBitmap = gDI32.CreateDIBSection(this.memDC, (WinGDI$BITMAPINFO)object2, 0, (PointerByReference)object, null, 0);
                this.pbits = ((PointerByReference)object).getValue();
                this.bitmapSize = new Dimension(n6, n7);
            }
            winNT$HANDLE = gDI32.SelectObject(this.memDC, this.hBitmap);
            object2 = bufferedImage.getData();
            object = new int[4];
            int[] nArray = new int[n4];
            for (int i2 = 0; i2 < n5; ++i2) {
                int n8;
                for (n8 = 0; n8 < n4; ++n8) {
                    ((Raster)object2).getPixel(n8, i2, (int[])object);
                    int n9 = (object[3] & 0xFF) << 24;
                    int n10 = object[2] & 0xFF;
                    int n11 = (object[1] & 0xFF) << 8;
                    int n12 = (object[0] & 0xFF) << 16;
                    nArray[n8] = n9 | n10 | n11 | n12;
                }
                n8 = n7 - (point.y + i2) - 1;
                this.pbits.write((long)((n8 * n6 + point.x) * 4), nArray, 0, nArray.length);
            }
            WinUser$SIZE winUser$SIZE = new WinUser$SIZE();
            winUser$SIZE.cx = window.getWidth();
            winUser$SIZE.cy = window.getHeight();
            WinDef$POINT winDef$POINT = new WinDef$POINT();
            winDef$POINT.x = window.getX();
            winDef$POINT.y = window.getY();
            WinDef$POINT winDef$POINT2 = new WinDef$POINT();
            WinUser$BLENDFUNCTION winUser$BLENDFUNCTION = new WinUser$BLENDFUNCTION();
            WinDef.HWND hWND = WindowUtils$W32WindowUtils.access$400(this.this$0, window);
            ByteByReference byteByReference = new ByteByReference();
            IntByReference intByReference = new IntByReference();
            byte by2 = WindowUtils$W32WindowUtils.access$700(this.this$0, window);
            try {
                if (user32.GetLayeredWindowAttributes(hWND, null, byteByReference, intByReference) && (intByReference.getValue() & 2) != 0) {
                    by2 = byteByReference.getValue();
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
            winUser$BLENDFUNCTION.SourceConstantAlpha = by2;
            winUser$BLENDFUNCTION.AlphaFormat = 1;
            user32.UpdateLayeredWindow(hWND, hDC, winDef$POINT, winUser$SIZE, this.memDC, winDef$POINT2, 0, winUser$BLENDFUNCTION, 2);
            user32.ReleaseDC(null, hDC);
        }
        catch (Throwable throwable) {
            user32.ReleaseDC(null, hDC);
            if (this.memDC != null && winNT$HANDLE != null) {
                gDI32.SelectObject(this.memDC, winNT$HANDLE);
            }
            throw throwable;
        }
        if (this.memDC != null && winNT$HANDLE != null) {
            gDI32.SelectObject(this.memDC, winNT$HANDLE);
        }
    }
}

