/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util$1;
import com.sun.jna.platform.win32.Advapi32Util$2;
import com.sun.jna.platform.win32.Advapi32Util$AccessCheckPermission;
import com.sun.jna.platform.win32.Advapi32Util$Account;
import com.sun.jna.platform.win32.Advapi32Util$EnumKey;
import com.sun.jna.platform.win32.Advapi32Util$InfoKey;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef$BOOLByReference;
import com.sun.jna.platform.win32.WinDef$DWORD;
import com.sun.jna.platform.win32.WinDef$DWORDByReference;
import com.sun.jna.platform.win32.WinDef$ULONG;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinNT$ACCESS_ACEStructure;
import com.sun.jna.platform.win32.WinNT$ACE_HEADER;
import com.sun.jna.platform.win32.WinNT$ACL;
import com.sun.jna.platform.win32.WinNT$GENERIC_MAPPING;
import com.sun.jna.platform.win32.WinNT$HANDLE;
import com.sun.jna.platform.win32.WinNT$HANDLEByReference;
import com.sun.jna.platform.win32.WinNT$PRIVILEGE_SET;
import com.sun.jna.platform.win32.WinNT$PSID;
import com.sun.jna.platform.win32.WinNT$PSIDByReference;
import com.sun.jna.platform.win32.WinNT$SECURITY_DESCRIPTOR_RELATIVE;
import com.sun.jna.platform.win32.WinNT$SID_AND_ATTRIBUTES;
import com.sun.jna.platform.win32.WinNT$TOKEN_GROUPS;
import com.sun.jna.platform.win32.WinNT$TOKEN_USER;
import com.sun.jna.platform.win32.WinReg;
import com.sun.jna.platform.win32.WinReg$HKEYByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.W32APITypeMapper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public abstract class Advapi32Util {
    public static String getUserName() {
        char[] cArray = new char[128];
        IntByReference intByReference = new IntByReference(cArray.length);
        boolean bl2 = Advapi32.INSTANCE.GetUserNameW(cArray, intByReference);
        if (!bl2) {
            switch (Kernel32.INSTANCE.GetLastError()) {
                case 122: {
                    cArray = new char[intByReference.getValue()];
                    break;
                }
                default: {
                    throw new Win32Exception(Native.getLastError());
                }
            }
            bl2 = Advapi32.INSTANCE.GetUserNameW(cArray, intByReference);
        }
        if (!bl2) {
            throw new Win32Exception(Native.getLastError());
        }
        return Native.toString(cArray);
    }

    public static Advapi32Util$Account getAccountByName(String string) {
        return Advapi32Util.getAccountByName(null, string);
    }

    public static Advapi32Util$Account getAccountByName(String string, String string2) {
        char[] cArray;
        IntByReference intByReference = new IntByReference(0);
        IntByReference intByReference2 = new IntByReference(0);
        PointerByReference pointerByReference = new PointerByReference();
        if (Advapi32.INSTANCE.LookupAccountName(string, string2, null, intByReference, null, intByReference2, pointerByReference)) {
            throw new RuntimeException("LookupAccountNameW was expected to fail with ERROR_INSUFFICIENT_BUFFER");
        }
        int n2 = Kernel32.INSTANCE.GetLastError();
        if (intByReference.getValue() == 0 || n2 != 122) {
            throw new Win32Exception(n2);
        }
        Memory memory = new Memory(intByReference.getValue());
        WinNT$PSID winNT$PSID = new WinNT$PSID(memory);
        if (!Advapi32.INSTANCE.LookupAccountName(string, string2, winNT$PSID, intByReference, cArray = new char[intByReference2.getValue() + 1], intByReference2, pointerByReference)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        Advapi32Util$Account advapi32Util$Account = new Advapi32Util$Account();
        advapi32Util$Account.accountType = pointerByReference.getPointer().getInt(0L);
        String[] stringArray = string2.split("\\\\", 2);
        String[] stringArray2 = string2.split("@", 2);
        advapi32Util$Account.name = stringArray.length == 2 ? stringArray[1] : (stringArray2.length == 2 ? stringArray2[0] : string2);
        if (intByReference2.getValue() > 0) {
            advapi32Util$Account.domain = Native.toString(cArray);
            advapi32Util$Account.fqn = advapi32Util$Account.domain + "\\" + advapi32Util$Account.name;
        } else {
            advapi32Util$Account.fqn = advapi32Util$Account.name;
        }
        advapi32Util$Account.sid = winNT$PSID.getBytes();
        advapi32Util$Account.sidString = Advapi32Util.convertSidToStringSid(new WinNT$PSID(advapi32Util$Account.sid));
        return advapi32Util$Account;
    }

    public static Advapi32Util$Account getAccountBySid(WinNT$PSID winNT$PSID) {
        return Advapi32Util.getAccountBySid(null, winNT$PSID);
    }

    public static Advapi32Util$Account getAccountBySid(String string, WinNT$PSID winNT$PSID) {
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference();
        PointerByReference pointerByReference = new PointerByReference();
        if (Advapi32.INSTANCE.LookupAccountSid(null, winNT$PSID, null, intByReference, null, intByReference2, pointerByReference)) {
            throw new RuntimeException("LookupAccountSidW was expected to fail with ERROR_INSUFFICIENT_BUFFER");
        }
        int n2 = Kernel32.INSTANCE.GetLastError();
        if (intByReference.getValue() == 0 || n2 != 122) {
            throw new Win32Exception(n2);
        }
        char[] cArray = new char[intByReference2.getValue()];
        char[] cArray2 = new char[intByReference.getValue()];
        if (!Advapi32.INSTANCE.LookupAccountSid(null, winNT$PSID, cArray2, intByReference, cArray, intByReference2, pointerByReference)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        Advapi32Util$Account advapi32Util$Account = new Advapi32Util$Account();
        advapi32Util$Account.accountType = pointerByReference.getPointer().getInt(0L);
        advapi32Util$Account.name = Native.toString(cArray2);
        if (intByReference2.getValue() > 0) {
            advapi32Util$Account.domain = Native.toString(cArray);
            advapi32Util$Account.fqn = advapi32Util$Account.domain + "\\" + advapi32Util$Account.name;
        } else {
            advapi32Util$Account.fqn = advapi32Util$Account.name;
        }
        advapi32Util$Account.sid = winNT$PSID.getBytes();
        advapi32Util$Account.sidString = Advapi32Util.convertSidToStringSid(winNT$PSID);
        return advapi32Util$Account;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertSidToStringSid(WinNT$PSID winNT$PSID) {
        PointerByReference pointerByReference = new PointerByReference();
        if (!Advapi32.INSTANCE.ConvertSidToStringSid(winNT$PSID, pointerByReference)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        Pointer pointer = pointerByReference.getValue();
        try {
            String string = pointer.getWideString(0L);
            return string;
        }
        finally {
            Kernel32Util.freeLocalMemory(pointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] convertStringSidToSid(String string) {
        WinNT$PSIDByReference winNT$PSIDByReference = new WinNT$PSIDByReference();
        if (!Advapi32.INSTANCE.ConvertStringSidToSid(string, winNT$PSIDByReference)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        WinNT$PSID winNT$PSID = winNT$PSIDByReference.getValue();
        try {
            byte[] byArray = winNT$PSID.getBytes();
            return byArray;
        }
        finally {
            Kernel32Util.freeLocalMemory(winNT$PSID.getPointer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isWellKnownSid(String string, int n2) {
        WinNT$PSIDByReference winNT$PSIDByReference = new WinNT$PSIDByReference();
        if (!Advapi32.INSTANCE.ConvertStringSidToSid(string, winNT$PSIDByReference)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        WinNT$PSID winNT$PSID = winNT$PSIDByReference.getValue();
        try {
            boolean bl2 = Advapi32.INSTANCE.IsWellKnownSid(winNT$PSID, n2);
            return bl2;
        }
        finally {
            Kernel32Util.freeLocalMemory(winNT$PSID.getPointer());
        }
    }

    public static boolean isWellKnownSid(byte[] byArray, int n2) {
        WinNT$PSID winNT$PSID = new WinNT$PSID(byArray);
        return Advapi32.INSTANCE.IsWellKnownSid(winNT$PSID, n2);
    }

    public static int alignOnDWORD(int n2) {
        return n2 + 3 & 0xFFFFFFFC;
    }

    public static int getAceSize(int n2) {
        return Native.getNativeSize(WinNT.ACCESS_ALLOWED_ACE.class, null) + n2 - 4;
    }

    public static Advapi32Util$Account getAccountBySid(String string) {
        return Advapi32Util.getAccountBySid(null, string);
    }

    public static Advapi32Util$Account getAccountBySid(String string, String string2) {
        return Advapi32Util.getAccountBySid(string, new WinNT$PSID(Advapi32Util.convertStringSidToSid(string2)));
    }

    public static Advapi32Util$Account[] getTokenGroups(WinNT$HANDLE winNT$HANDLE) {
        IntByReference intByReference = new IntByReference();
        if (Advapi32.INSTANCE.GetTokenInformation(winNT$HANDLE, 2, null, 0, intByReference)) {
            throw new RuntimeException("Expected GetTokenInformation to fail with ERROR_INSUFFICIENT_BUFFER");
        }
        int n2 = Kernel32.INSTANCE.GetLastError();
        if (n2 != 122) {
            throw new Win32Exception(n2);
        }
        WinNT$TOKEN_GROUPS winNT$TOKEN_GROUPS = new WinNT$TOKEN_GROUPS(intByReference.getValue());
        if (!Advapi32.INSTANCE.GetTokenInformation(winNT$HANDLE, 2, winNT$TOKEN_GROUPS, intByReference.getValue(), intByReference)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        ArrayList<Advapi32Util$Account> arrayList = new ArrayList<Advapi32Util$Account>();
        for (WinNT$SID_AND_ATTRIBUTES winNT$SID_AND_ATTRIBUTES : winNT$TOKEN_GROUPS.getGroups()) {
            Advapi32Util$Account advapi32Util$Account;
            try {
                advapi32Util$Account = Advapi32Util.getAccountBySid(winNT$SID_AND_ATTRIBUTES.Sid);
            }
            catch (Exception exception) {
                advapi32Util$Account = new Advapi32Util$Account();
                advapi32Util$Account.sid = winNT$SID_AND_ATTRIBUTES.Sid.getBytes();
                advapi32Util$Account.name = advapi32Util$Account.sidString = Advapi32Util.convertSidToStringSid(winNT$SID_AND_ATTRIBUTES.Sid);
                advapi32Util$Account.fqn = advapi32Util$Account.sidString;
                advapi32Util$Account.accountType = 2;
            }
            arrayList.add(advapi32Util$Account);
        }
        return arrayList.toArray(new Advapi32Util$Account[0]);
    }

    public static Advapi32Util$Account getTokenAccount(WinNT$HANDLE winNT$HANDLE) {
        IntByReference intByReference = new IntByReference();
        if (Advapi32.INSTANCE.GetTokenInformation(winNT$HANDLE, 1, null, 0, intByReference)) {
            throw new RuntimeException("Expected GetTokenInformation to fail with ERROR_INSUFFICIENT_BUFFER");
        }
        int n2 = Kernel32.INSTANCE.GetLastError();
        if (n2 != 122) {
            throw new Win32Exception(n2);
        }
        WinNT$TOKEN_USER winNT$TOKEN_USER = new WinNT$TOKEN_USER(intByReference.getValue());
        if (!Advapi32.INSTANCE.GetTokenInformation(winNT$HANDLE, 1, winNT$TOKEN_USER, intByReference.getValue(), intByReference)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return Advapi32Util.getAccountBySid(winNT$TOKEN_USER.User.Sid);
    }

    public static Advapi32Util$Account[] getCurrentUserGroups() {
        WinNT$HANDLEByReference winNT$HANDLEByReference = new WinNT$HANDLEByReference();
        Win32Exception win32Exception = null;
        try {
            WinNT$HANDLE winNT$HANDLE = Kernel32.INSTANCE.GetCurrentThread();
            if (!Advapi32.INSTANCE.OpenThreadToken(winNT$HANDLE, 10, true, winNT$HANDLEByReference)) {
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 != 1008) {
                    throw new Win32Exception(n2);
                }
                WinNT$HANDLE winNT$HANDLE2 = Kernel32.INSTANCE.GetCurrentProcess();
                if (!Advapi32.INSTANCE.OpenProcessToken(winNT$HANDLE2, 10, winNT$HANDLEByReference)) {
                    throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                }
            }
            Advapi32Util$Account[] advapi32Util$AccountArray = Advapi32Util.getTokenGroups(winNT$HANDLEByReference.getValue());
            return advapi32Util$AccountArray;
        }
        catch (Win32Exception win32Exception2) {
            win32Exception = win32Exception2;
            throw win32Exception;
        }
        finally {
            WinNT$HANDLE winNT$HANDLE = winNT$HANDLEByReference.getValue();
            if (!WinBase.INVALID_HANDLE_VALUE.equals(winNT$HANDLE)) {
                try {
                    Kernel32Util.closeHandle(winNT$HANDLE);
                }
                catch (Win32Exception win32Exception3) {
                    if (win32Exception == null) {
                        win32Exception = win32Exception3;
                    }
                    win32Exception.addSuppressedReflected(win32Exception3);
                }
            }
            if (win32Exception != null) {
                throw win32Exception;
            }
        }
    }

    public static boolean registryKeyExists(WinReg.HKEY hKEY, String string) {
        return Advapi32Util.registryKeyExists(hKEY, string, 0);
    }

    public static boolean registryKeyExists(WinReg.HKEY hKEY, String string, int n2) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n3 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 0x20019 | n2, winReg$HKEYByReference);
        switch (n3) {
            case 0: {
                Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new Win32Exception(n3);
    }

    public static boolean registryValueExists(WinReg.HKEY hKEY, String string, String string2) {
        return Advapi32Util.registryValueExists(hKEY, string, string2, 0);
    }

    public static boolean registryValueExists(WinReg.HKEY hKEY, String string, String string2, int n2) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n3 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 0x20019 | n2, winReg$HKEYByReference);
        switch (n3) {
            case 0: {
                break;
            }
            case 2: {
                return false;
            }
            default: {
                throw new Win32Exception(n3);
            }
        }
        try {
            IntByReference intByReference = new IntByReference();
            IntByReference intByReference2 = new IntByReference();
            n3 = Advapi32.INSTANCE.RegQueryValueEx(winReg$HKEYByReference.getValue(), string2, 0, intByReference2, (Pointer)null, intByReference);
            switch (n3) {
                case 0: 
                case 122: 
                case 234: {
                    boolean bl2 = true;
                    return bl2;
                }
                case 2: {
                    boolean bl3 = false;
                    return bl3;
                }
            }
            throw new Win32Exception(n3);
        }
        finally {
            if (winReg$HKEYByReference.getValue() != WinBase.INVALID_HANDLE_VALUE && (n3 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue())) != 0) {
                throw new Win32Exception(n3);
            }
        }
    }

    public static String registryGetStringValue(WinReg.HKEY hKEY, String string, String string2) {
        return Advapi32Util.registryGetStringValue(hKEY, string, string2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String registryGetStringValue(WinReg.HKEY hKEY, String string, String string2, int n2) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n3 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 0x20019 | n2, winReg$HKEYByReference);
        if (n3 != 0) {
            throw new Win32Exception(n3);
        }
        try {
            String string3 = Advapi32Util.registryGetStringValue(winReg$HKEYByReference.getValue(), string2);
            return string3;
        }
        finally {
            n3 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n3 != 0) {
                throw new Win32Exception(n3);
            }
        }
    }

    public static String registryGetStringValue(WinReg.HKEY hKEY, String string) {
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference();
        int n2 = Advapi32.INSTANCE.RegQueryValueEx(hKEY, string, 0, intByReference, (Pointer)null, intByReference2);
        if (n2 != 0 && n2 != 122) {
            throw new Win32Exception(n2);
        }
        if (intByReference.getValue() != 1 && intByReference.getValue() != 2) {
            throw new RuntimeException("Unexpected registry type " + intByReference.getValue() + ", expected REG_SZ or REG_EXPAND_SZ");
        }
        if (intByReference2.getValue() == 0) {
            return "";
        }
        Memory memory = new Memory(intByReference2.getValue() + Native.WCHAR_SIZE);
        memory.clear();
        n2 = Advapi32.INSTANCE.RegQueryValueEx(hKEY, string, 0, intByReference, memory, intByReference2);
        if (n2 != 0 && n2 != 122) {
            throw new Win32Exception(n2);
        }
        if (W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE) {
            return memory.getWideString(0L);
        }
        return memory.getString(0L);
    }

    public static String registryGetExpandableStringValue(WinReg.HKEY hKEY, String string, String string2) {
        return Advapi32Util.registryGetExpandableStringValue(hKEY, string, string2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String registryGetExpandableStringValue(WinReg.HKEY hKEY, String string, String string2, int n2) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n3 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 0x20019 | n2, winReg$HKEYByReference);
        if (n3 != 0) {
            throw new Win32Exception(n3);
        }
        try {
            String string3 = Advapi32Util.registryGetExpandableStringValue(winReg$HKEYByReference.getValue(), string2);
            return string3;
        }
        finally {
            n3 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n3 != 0) {
                throw new Win32Exception(n3);
            }
        }
    }

    public static String registryGetExpandableStringValue(WinReg.HKEY hKEY, String string) {
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference();
        int n2 = Advapi32.INSTANCE.RegQueryValueEx(hKEY, string, 0, intByReference, (char[])null, intByReference2);
        if (n2 != 0 && n2 != 122) {
            throw new Win32Exception(n2);
        }
        if (intByReference.getValue() != 2) {
            throw new RuntimeException("Unexpected registry type " + intByReference.getValue() + ", expected REG_SZ");
        }
        if (intByReference2.getValue() == 0) {
            return "";
        }
        Memory memory = new Memory(intByReference2.getValue() + Native.WCHAR_SIZE);
        memory.clear();
        n2 = Advapi32.INSTANCE.RegQueryValueEx(hKEY, string, 0, intByReference, memory, intByReference2);
        if (n2 != 0 && n2 != 122) {
            throw new Win32Exception(n2);
        }
        if (W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE) {
            return memory.getWideString(0L);
        }
        return memory.getString(0L);
    }

    public static String[] registryGetStringArray(WinReg.HKEY hKEY, String string, String string2) {
        return Advapi32Util.registryGetStringArray(hKEY, string, string2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] registryGetStringArray(WinReg.HKEY hKEY, String string, String string2, int n2) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n3 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 0x20019 | n2, winReg$HKEYByReference);
        if (n3 != 0) {
            throw new Win32Exception(n3);
        }
        try {
            String[] stringArray = Advapi32Util.registryGetStringArray(winReg$HKEYByReference.getValue(), string2);
            return stringArray;
        }
        finally {
            n3 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n3 != 0) {
                throw new Win32Exception(n3);
            }
        }
    }

    public static String[] registryGetStringArray(WinReg.HKEY hKEY, String string) {
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference();
        int n2 = Advapi32.INSTANCE.RegQueryValueEx(hKEY, string, 0, intByReference, (char[])null, intByReference2);
        if (n2 != 0 && n2 != 122) {
            throw new Win32Exception(n2);
        }
        if (intByReference.getValue() != 7) {
            throw new RuntimeException("Unexpected registry type " + intByReference.getValue() + ", expected REG_SZ");
        }
        Memory memory = new Memory(intByReference2.getValue() + 2 * Native.WCHAR_SIZE);
        memory.clear();
        n2 = Advapi32.INSTANCE.RegQueryValueEx(hKEY, string, 0, intByReference, memory, intByReference2);
        if (n2 != 0 && n2 != 122) {
            throw new Win32Exception(n2);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = 0;
        while ((long)n3 < memory.size()) {
            String string2;
            if (W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE) {
                string2 = memory.getWideString(n3);
                n3 += string2.length() * Native.WCHAR_SIZE;
                n3 += Native.WCHAR_SIZE;
            } else {
                string2 = memory.getString(n3);
                n3 += string2.length();
                ++n3;
            }
            if (string2.length() == 0) break;
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static byte[] registryGetBinaryValue(WinReg.HKEY hKEY, String string, String string2) {
        return Advapi32Util.registryGetBinaryValue(hKEY, string, string2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] registryGetBinaryValue(WinReg.HKEY hKEY, String string, String string2, int n2) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n3 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 0x20019 | n2, winReg$HKEYByReference);
        if (n3 != 0) {
            throw new Win32Exception(n3);
        }
        try {
            byte[] byArray = Advapi32Util.registryGetBinaryValue(winReg$HKEYByReference.getValue(), string2);
            return byArray;
        }
        finally {
            n3 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n3 != 0) {
                throw new Win32Exception(n3);
            }
        }
    }

    public static byte[] registryGetBinaryValue(WinReg.HKEY hKEY, String string) {
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference();
        int n2 = Advapi32.INSTANCE.RegQueryValueEx(hKEY, string, 0, intByReference, (Pointer)null, intByReference2);
        if (n2 != 0 && n2 != 122) {
            throw new Win32Exception(n2);
        }
        if (intByReference.getValue() != 3) {
            throw new RuntimeException("Unexpected registry type " + intByReference.getValue() + ", expected REG_BINARY");
        }
        byte[] byArray = new byte[intByReference2.getValue()];
        n2 = Advapi32.INSTANCE.RegQueryValueEx(hKEY, string, 0, intByReference, byArray, intByReference2);
        if (n2 != 0 && n2 != 122) {
            throw new Win32Exception(n2);
        }
        return byArray;
    }

    public static int registryGetIntValue(WinReg.HKEY hKEY, String string, String string2) {
        return Advapi32Util.registryGetIntValue(hKEY, string, string2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int registryGetIntValue(WinReg.HKEY hKEY, String string, String string2, int n2) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n3 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 0x20019 | n2, winReg$HKEYByReference);
        if (n3 != 0) {
            throw new Win32Exception(n3);
        }
        try {
            int n4 = Advapi32Util.registryGetIntValue(winReg$HKEYByReference.getValue(), string2);
            return n4;
        }
        finally {
            n3 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n3 != 0) {
                throw new Win32Exception(n3);
            }
        }
    }

    public static int registryGetIntValue(WinReg.HKEY hKEY, String string) {
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference();
        int n2 = Advapi32.INSTANCE.RegQueryValueEx(hKEY, string, 0, intByReference, (char[])null, intByReference2);
        if (n2 != 0 && n2 != 122) {
            throw new Win32Exception(n2);
        }
        if (intByReference.getValue() != 4) {
            throw new RuntimeException("Unexpected registry type " + intByReference.getValue() + ", expected REG_DWORD");
        }
        IntByReference intByReference3 = new IntByReference();
        n2 = Advapi32.INSTANCE.RegQueryValueEx(hKEY, string, 0, intByReference, intByReference3, intByReference2);
        if (n2 != 0 && n2 != 122) {
            throw new Win32Exception(n2);
        }
        return intByReference3.getValue();
    }

    public static long registryGetLongValue(WinReg.HKEY hKEY, String string, String string2) {
        return Advapi32Util.registryGetLongValue(hKEY, string, string2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long registryGetLongValue(WinReg.HKEY hKEY, String string, String string2, int n2) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n3 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 0x20019 | n2, winReg$HKEYByReference);
        if (n3 != 0) {
            throw new Win32Exception(n3);
        }
        try {
            long l2 = Advapi32Util.registryGetLongValue(winReg$HKEYByReference.getValue(), string2);
            return l2;
        }
        finally {
            n3 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n3 != 0) {
                throw new Win32Exception(n3);
            }
        }
    }

    public static long registryGetLongValue(WinReg.HKEY hKEY, String string) {
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference();
        int n2 = Advapi32.INSTANCE.RegQueryValueEx(hKEY, string, 0, intByReference, (char[])null, intByReference2);
        if (n2 != 0 && n2 != 122) {
            throw new Win32Exception(n2);
        }
        if (intByReference.getValue() != 11) {
            throw new RuntimeException("Unexpected registry type " + intByReference.getValue() + ", expected REG_QWORD");
        }
        LongByReference longByReference = new LongByReference();
        n2 = Advapi32.INSTANCE.RegQueryValueEx(hKEY, string, 0, intByReference, longByReference, intByReference2);
        if (n2 != 0 && n2 != 122) {
            throw new Win32Exception(n2);
        }
        return longByReference.getValue();
    }

    public static Object registryGetValue(WinReg.HKEY hKEY, String string, String string2) {
        Object object = null;
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference();
        int n2 = Advapi32.INSTANCE.RegGetValue(hKEY, string, string2, 65535, intByReference, (Pointer)null, intByReference2);
        if (intByReference.getValue() == 0) {
            return null;
        }
        if (n2 != 0 && n2 != 122) {
            throw new Win32Exception(n2);
        }
        Memory memory = new Memory(intByReference2.getValue() + Native.WCHAR_SIZE);
        memory.clear();
        n2 = Advapi32.INSTANCE.RegGetValue(hKEY, string, string2, 65535, intByReference, memory, intByReference2);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        if (intByReference.getValue() == 4) {
            object = memory.getInt(0L);
        } else if (intByReference.getValue() == 11) {
            object = memory.getLong(0L);
        } else if (intByReference.getValue() == 3) {
            object = memory.getByteArray(0L, intByReference2.getValue());
        } else if (intByReference.getValue() == 1 || intByReference.getValue() == 2) {
            object = W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE ? memory.getWideString(0L) : memory.getString(0L);
        }
        return object;
    }

    public static boolean registryCreateKey(WinReg.HKEY hKEY, String string) {
        return Advapi32Util.registryCreateKey(hKEY, string, 0);
    }

    public static boolean registryCreateKey(WinReg.HKEY hKEY, String string, int n2) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        IntByReference intByReference = new IntByReference();
        int n3 = Advapi32.INSTANCE.RegCreateKeyEx(hKEY, string, 0, null, 0, 0x20019 | n2, null, winReg$HKEYByReference, intByReference);
        if (n3 != 0) {
            throw new Win32Exception(n3);
        }
        n3 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
        if (n3 != 0) {
            throw new Win32Exception(n3);
        }
        return 1 == intByReference.getValue();
    }

    public static boolean registryCreateKey(WinReg.HKEY hKEY, String string, String string2) {
        return Advapi32Util.registryCreateKey(hKEY, string, string2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean registryCreateKey(WinReg.HKEY hKEY, String string, String string2, int n2) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n3 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 4 | n2, winReg$HKEYByReference);
        if (n3 != 0) {
            throw new Win32Exception(n3);
        }
        try {
            boolean bl2 = Advapi32Util.registryCreateKey(winReg$HKEYByReference.getValue(), string2);
            return bl2;
        }
        finally {
            n3 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n3 != 0) {
                throw new Win32Exception(n3);
            }
        }
    }

    public static void registrySetIntValue(WinReg.HKEY hKEY, String string, int n2) {
        byte[] byArray = new byte[]{(byte)(n2 & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 >> 16 & 0xFF), (byte)(n2 >> 24 & 0xFF)};
        int n3 = Advapi32.INSTANCE.RegSetValueEx(hKEY, string, 0, 4, byArray, 4);
        if (n3 != 0) {
            throw new Win32Exception(n3);
        }
    }

    public static void registrySetIntValue(WinReg.HKEY hKEY, String string, String string2, int n2) {
        Advapi32Util.registrySetIntValue(hKEY, string, string2, n2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registrySetIntValue(WinReg.HKEY hKEY, String string, String string2, int n2, int n3) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n4 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 0x2001F | n3, winReg$HKEYByReference);
        if (n4 != 0) {
            throw new Win32Exception(n4);
        }
        try {
            Advapi32Util.registrySetIntValue(winReg$HKEYByReference.getValue(), string2, n2);
        }
        finally {
            n4 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n4 != 0) {
                throw new Win32Exception(n4);
            }
        }
    }

    public static void registrySetLongValue(WinReg.HKEY hKEY, String string, long l2) {
        byte[] byArray = new byte[]{(byte)(l2 & 0xFFL), (byte)(l2 >> 8 & 0xFFL), (byte)(l2 >> 16 & 0xFFL), (byte)(l2 >> 24 & 0xFFL), (byte)(l2 >> 32 & 0xFFL), (byte)(l2 >> 40 & 0xFFL), (byte)(l2 >> 48 & 0xFFL), (byte)(l2 >> 56 & 0xFFL)};
        int n2 = Advapi32.INSTANCE.RegSetValueEx(hKEY, string, 0, 11, byArray, 8);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
    }

    public static void registrySetLongValue(WinReg.HKEY hKEY, String string, String string2, long l2) {
        Advapi32Util.registrySetLongValue(hKEY, string, string2, l2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registrySetLongValue(WinReg.HKEY hKEY, String string, String string2, long l2, int n2) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n3 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 0x2001F | n2, winReg$HKEYByReference);
        if (n3 != 0) {
            throw new Win32Exception(n3);
        }
        try {
            Advapi32Util.registrySetLongValue(winReg$HKEYByReference.getValue(), string2, l2);
        }
        finally {
            n3 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n3 != 0) {
                throw new Win32Exception(n3);
            }
        }
    }

    public static void registrySetStringValue(WinReg.HKEY hKEY, String string, String string2) {
        Memory memory;
        if (string2 == null) {
            string2 = "";
        }
        if (W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE) {
            memory = new Memory((string2.length() + 1) * Native.WCHAR_SIZE);
            memory.setWideString(0L, string2);
        } else {
            memory = new Memory(string2.length() + 1);
            memory.setString(0L, string2);
        }
        int n2 = Advapi32.INSTANCE.RegSetValueEx(hKEY, string, 0, 1, memory, (int)memory.size());
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
    }

    public static void registrySetStringValue(WinReg.HKEY hKEY, String string, String string2, String string3) {
        Advapi32Util.registrySetStringValue(hKEY, string, string2, string3, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registrySetStringValue(WinReg.HKEY hKEY, String string, String string2, String string3, int n2) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n3 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 0x2001F | n2, winReg$HKEYByReference);
        if (n3 != 0) {
            throw new Win32Exception(n3);
        }
        try {
            Advapi32Util.registrySetStringValue(winReg$HKEYByReference.getValue(), string2, string3);
        }
        finally {
            n3 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n3 != 0) {
                throw new Win32Exception(n3);
            }
        }
    }

    public static void registrySetExpandableStringValue(WinReg.HKEY hKEY, String string, String string2) {
        Memory memory;
        if (W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE) {
            memory = new Memory((string2.length() + 1) * Native.WCHAR_SIZE);
            memory.setWideString(0L, string2);
        } else {
            memory = new Memory(string2.length() + 1);
            memory.setString(0L, string2);
        }
        int n2 = Advapi32.INSTANCE.RegSetValueEx(hKEY, string, 0, 2, memory, (int)memory.size());
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
    }

    public static void registrySetExpandableStringValue(WinReg.HKEY hKEY, String string, String string2, String string3) {
        Advapi32Util.registrySetExpandableStringValue(hKEY, string, string2, string3, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registrySetExpandableStringValue(WinReg.HKEY hKEY, String string, String string2, String string3, int n2) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n3 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 0x2001F | n2, winReg$HKEYByReference);
        if (n3 != 0) {
            throw new Win32Exception(n3);
        }
        try {
            Advapi32Util.registrySetExpandableStringValue(winReg$HKEYByReference.getValue(), string2, string3);
        }
        finally {
            n3 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n3 != 0) {
                throw new Win32Exception(n3);
            }
        }
    }

    public static void registrySetStringArray(WinReg.HKEY hKEY, String string, String[] stringArray) {
        int n2 = W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE ? Native.WCHAR_SIZE : 1;
        int n3 = 0;
        for (String string2 : stringArray) {
            n3 += string2.length() * n2;
            n3 += n2;
        }
        int n4 = 0;
        Memory memory = new Memory(n3 += n2);
        memory.clear();
        for (String string3 : stringArray) {
            if (W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE) {
                memory.setWideString(n4, string3);
            } else {
                memory.setString((long)n4, string3);
            }
            n4 += string3.length() * n2;
            n4 += n2;
        }
        int n5 = Advapi32.INSTANCE.RegSetValueEx(hKEY, string, 0, 7, memory, n3);
        if (n5 != 0) {
            throw new Win32Exception(n5);
        }
    }

    public static void registrySetStringArray(WinReg.HKEY hKEY, String string, String string2, String[] stringArray) {
        Advapi32Util.registrySetStringArray(hKEY, string, string2, stringArray, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registrySetStringArray(WinReg.HKEY hKEY, String string, String string2, String[] stringArray, int n2) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n3 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 0x2001F | n2, winReg$HKEYByReference);
        if (n3 != 0) {
            throw new Win32Exception(n3);
        }
        try {
            Advapi32Util.registrySetStringArray(winReg$HKEYByReference.getValue(), string2, stringArray);
        }
        finally {
            n3 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n3 != 0) {
                throw new Win32Exception(n3);
            }
        }
    }

    public static void registrySetBinaryValue(WinReg.HKEY hKEY, String string, byte[] byArray) {
        int n2 = Advapi32.INSTANCE.RegSetValueEx(hKEY, string, 0, 3, byArray, byArray.length);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
    }

    public static void registrySetBinaryValue(WinReg.HKEY hKEY, String string, String string2, byte[] byArray) {
        Advapi32Util.registrySetBinaryValue(hKEY, string, string2, byArray, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registrySetBinaryValue(WinReg.HKEY hKEY, String string, String string2, byte[] byArray, int n2) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n3 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 0x2001F | n2, winReg$HKEYByReference);
        if (n3 != 0) {
            throw new Win32Exception(n3);
        }
        try {
            Advapi32Util.registrySetBinaryValue(winReg$HKEYByReference.getValue(), string2, byArray);
        }
        finally {
            n3 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n3 != 0) {
                throw new Win32Exception(n3);
            }
        }
    }

    public static void registryDeleteKey(WinReg.HKEY hKEY, String string) {
        int n2 = Advapi32.INSTANCE.RegDeleteKey(hKEY, string);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
    }

    public static void registryDeleteKey(WinReg.HKEY hKEY, String string, String string2) {
        Advapi32Util.registryDeleteKey(hKEY, string, string2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registryDeleteKey(WinReg.HKEY hKEY, String string, String string2, int n2) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n3 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 0x2001F | n2, winReg$HKEYByReference);
        if (n3 != 0) {
            throw new Win32Exception(n3);
        }
        try {
            Advapi32Util.registryDeleteKey(winReg$HKEYByReference.getValue(), string2);
        }
        finally {
            n3 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n3 != 0) {
                throw new Win32Exception(n3);
            }
        }
    }

    public static void registryDeleteValue(WinReg.HKEY hKEY, String string) {
        int n2 = Advapi32.INSTANCE.RegDeleteValue(hKEY, string);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
    }

    public static void registryDeleteValue(WinReg.HKEY hKEY, String string, String string2) {
        Advapi32Util.registryDeleteValue(hKEY, string, string2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registryDeleteValue(WinReg.HKEY hKEY, String string, String string2, int n2) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n3 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 0x2001F | n2, winReg$HKEYByReference);
        if (n3 != 0) {
            throw new Win32Exception(n3);
        }
        try {
            Advapi32Util.registryDeleteValue(winReg$HKEYByReference.getValue(), string2);
        }
        finally {
            n3 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n3 != 0) {
                throw new Win32Exception(n3);
            }
        }
    }

    public static String[] registryGetKeys(WinReg.HKEY hKEY) {
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference();
        int n2 = Advapi32.INSTANCE.RegQueryInfoKey(hKEY, null, null, null, intByReference, intByReference2, null, null, null, null, null, null);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        ArrayList<String> arrayList = new ArrayList<String>(intByReference.getValue());
        char[] cArray = new char[intByReference2.getValue() + 1];
        for (int i2 = 0; i2 < intByReference.getValue(); ++i2) {
            IntByReference intByReference3 = new IntByReference(intByReference2.getValue() + 1);
            n2 = Advapi32.INSTANCE.RegEnumKeyEx(hKEY, i2, cArray, intByReference3, null, null, null, null);
            if (n2 != 0) {
                throw new Win32Exception(n2);
            }
            arrayList.add(Native.toString(cArray));
        }
        return arrayList.toArray(new String[0]);
    }

    public static String[] registryGetKeys(WinReg.HKEY hKEY, String string) {
        return Advapi32Util.registryGetKeys(hKEY, string, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] registryGetKeys(WinReg.HKEY hKEY, String string, int n2) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n3 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 0x20019 | n2, winReg$HKEYByReference);
        if (n3 != 0) {
            throw new Win32Exception(n3);
        }
        try {
            String[] stringArray = Advapi32Util.registryGetKeys(winReg$HKEYByReference.getValue());
            return stringArray;
        }
        finally {
            n3 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n3 != 0) {
                throw new Win32Exception(n3);
            }
        }
    }

    public static WinReg$HKEYByReference registryGetKey(WinReg.HKEY hKEY, String string, int n2) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n3 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, n2, winReg$HKEYByReference);
        if (n3 != 0) {
            throw new Win32Exception(n3);
        }
        return winReg$HKEYByReference;
    }

    public static void registryCloseKey(WinReg.HKEY hKEY) {
        int n2 = Advapi32.INSTANCE.RegCloseKey(hKEY);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
    }

    public static TreeMap registryGetValues(WinReg.HKEY hKEY) {
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference();
        IntByReference intByReference3 = new IntByReference();
        int n2 = Advapi32.INSTANCE.RegQueryInfoKey(hKEY, null, null, null, null, null, null, intByReference, intByReference2, intByReference3, null, null);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        char[] cArray = new char[intByReference2.getValue() + 1];
        Memory memory = new Memory(intByReference3.getValue() + 2 * Native.WCHAR_SIZE);
        block13: for (int i2 = 0; i2 < intByReference.getValue(); ++i2) {
            memory.clear();
            IntByReference intByReference4 = new IntByReference(intByReference2.getValue() + 1);
            IntByReference intByReference5 = new IntByReference(intByReference3.getValue());
            IntByReference intByReference6 = new IntByReference();
            n2 = Advapi32.INSTANCE.RegEnumValue(hKEY, i2, cArray, intByReference4, null, intByReference6, memory, intByReference5);
            if (n2 != 0) {
                throw new Win32Exception(n2);
            }
            String string = Native.toString(cArray);
            if (intByReference5.getValue() == 0) {
                switch (intByReference6.getValue()) {
                    case 3: {
                        treeMap.put(string, new byte[0]);
                        continue block13;
                    }
                    case 1: 
                    case 2: {
                        treeMap.put(string, new char[0]);
                        continue block13;
                    }
                    case 7: {
                        treeMap.put(string, new String[0]);
                        continue block13;
                    }
                    case 0: {
                        treeMap.put(string, null);
                        continue block13;
                    }
                    default: {
                        throw new RuntimeException("Unsupported empty type: " + intByReference6.getValue());
                    }
                }
            }
            switch (intByReference6.getValue()) {
                case 11: {
                    treeMap.put(string, memory.getLong(0L));
                    continue block13;
                }
                case 4: {
                    treeMap.put(string, memory.getInt(0L));
                    continue block13;
                }
                case 1: 
                case 2: {
                    if (W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE) {
                        treeMap.put(string, memory.getWideString(0L));
                        continue block13;
                    }
                    treeMap.put(string, memory.getString(0L));
                    continue block13;
                }
                case 3: {
                    treeMap.put(string, memory.getByteArray(0L, intByReference5.getValue()));
                    continue block13;
                }
                case 7: {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    int n3 = 0;
                    while ((long)n3 < memory.size()) {
                        String string2;
                        if (W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE) {
                            string2 = memory.getWideString(n3);
                            n3 += string2.length() * Native.WCHAR_SIZE;
                            n3 += Native.WCHAR_SIZE;
                        } else {
                            string2 = memory.getString(n3);
                            n3 += string2.length();
                            ++n3;
                        }
                        if (string2.length() == 0) break;
                        arrayList.add(string2);
                    }
                    treeMap.put(string, arrayList.toArray(new String[0]));
                    continue block13;
                }
                default: {
                    throw new RuntimeException("Unsupported type: " + intByReference6.getValue());
                }
            }
        }
        return treeMap;
    }

    public static TreeMap registryGetValues(WinReg.HKEY hKEY, String string) {
        return Advapi32Util.registryGetValues(hKEY, string, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TreeMap registryGetValues(WinReg.HKEY hKEY, String string, int n2) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n3 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 0x20019 | n2, winReg$HKEYByReference);
        if (n3 != 0) {
            throw new Win32Exception(n3);
        }
        try {
            TreeMap treeMap = Advapi32Util.registryGetValues(winReg$HKEYByReference.getValue());
            return treeMap;
        }
        finally {
            n3 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n3 != 0) {
                throw new Win32Exception(n3);
            }
        }
    }

    public static Advapi32Util$InfoKey registryQueryInfoKey(WinReg.HKEY hKEY, int n2) {
        Advapi32Util$InfoKey advapi32Util$InfoKey = new Advapi32Util$InfoKey(hKEY, n2);
        int n3 = Advapi32.INSTANCE.RegQueryInfoKey(hKEY, advapi32Util$InfoKey.lpClass, advapi32Util$InfoKey.lpcClass, null, advapi32Util$InfoKey.lpcSubKeys, advapi32Util$InfoKey.lpcMaxSubKeyLen, advapi32Util$InfoKey.lpcMaxClassLen, advapi32Util$InfoKey.lpcValues, advapi32Util$InfoKey.lpcMaxValueNameLen, advapi32Util$InfoKey.lpcMaxValueLen, advapi32Util$InfoKey.lpcbSecurityDescriptor, advapi32Util$InfoKey.lpftLastWriteTime);
        if (n3 != 0) {
            throw new Win32Exception(n3);
        }
        return advapi32Util$InfoKey;
    }

    public static Advapi32Util$EnumKey registryRegEnumKey(WinReg.HKEY hKEY, int n2) {
        Advapi32Util$EnumKey advapi32Util$EnumKey = new Advapi32Util$EnumKey(hKEY, n2);
        int n3 = Advapi32.INSTANCE.RegEnumKeyEx(hKEY, advapi32Util$EnumKey.dwIndex, advapi32Util$EnumKey.lpName, advapi32Util$EnumKey.lpcName, null, advapi32Util$EnumKey.lpClass, advapi32Util$EnumKey.lpcbClass, advapi32Util$EnumKey.lpftLastWriteTime);
        if (n3 != 0) {
            throw new Win32Exception(n3);
        }
        return advapi32Util$EnumKey;
    }

    public static String getEnvironmentBlock(Map map) {
        StringBuilder stringBuilder = new StringBuilder(map.size() * 32);
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            if (string2 == null) continue;
            stringBuilder.append(string).append("=").append(string2).append('\u0000');
        }
        return stringBuilder.append('\u0000').toString();
    }

    public static WinNT$ACE_HEADER[] getFileSecurity(String string, boolean bl2) {
        Object object;
        Memory memory;
        boolean bl3;
        int n2 = 4;
        int n3 = 1024;
        do {
            int n4;
            bl3 = false;
            memory = new Memory(n3);
            object = new IntByReference();
            boolean bl4 = Advapi32.INSTANCE.GetFileSecurity(string, n2, memory, n3, (IntByReference)object);
            if (!bl4) {
                n4 = Kernel32.INSTANCE.GetLastError();
                memory.clear();
                if (122 != n4) {
                    throw new Win32Exception(n4);
                }
            }
            if (n3 >= (n4 = ((IntByReference)object).getValue())) continue;
            bl3 = true;
            n3 = n4;
            memory.clear();
        } while (bl3);
        object = new WinNT$SECURITY_DESCRIPTOR_RELATIVE(memory);
        WinNT$ACL winNT$ACL = ((WinNT$SECURITY_DESCRIPTOR_RELATIVE)object).getDiscretionaryACL();
        WinNT$ACE_HEADER[] winNT$ACE_HEADERArray = winNT$ACL.getACEs();
        if (bl2) {
            ArrayList<WinNT$ACE_HEADER> arrayList = new ArrayList<WinNT$ACE_HEADER>();
            HashMap<String, WinNT$ACCESS_ACEStructure> hashMap = new HashMap<String, WinNT$ACCESS_ACEStructure>();
            for (WinNT$ACE_HEADER winNT$ACE_HEADER : winNT$ACE_HEADERArray) {
                if (winNT$ACE_HEADER instanceof WinNT$ACCESS_ACEStructure) {
                    WinNT$ACCESS_ACEStructure winNT$ACCESS_ACEStructure = (WinNT$ACCESS_ACEStructure)winNT$ACE_HEADER;
                    boolean bl5 = (winNT$ACE_HEADER.AceFlags & 0x1F) != 0;
                    String string2 = winNT$ACCESS_ACEStructure.getSidString() + "/" + bl5 + "/" + winNT$ACE_HEADER.getClass().getName();
                    WinNT$ACCESS_ACEStructure winNT$ACCESS_ACEStructure2 = (WinNT$ACCESS_ACEStructure)hashMap.get(string2);
                    if (winNT$ACCESS_ACEStructure2 != null) {
                        int n5 = winNT$ACCESS_ACEStructure2.Mask;
                        winNT$ACCESS_ACEStructure2.Mask = n5 |= winNT$ACCESS_ACEStructure.Mask;
                        continue;
                    }
                    hashMap.put(string2, winNT$ACCESS_ACEStructure);
                    arrayList.add(winNT$ACCESS_ACEStructure2);
                    continue;
                }
                arrayList.add(winNT$ACE_HEADER);
            }
            return arrayList.toArray(new WinNT$ACE_HEADER[arrayList.size()]);
        }
        return winNT$ACE_HEADERArray;
    }

    private static Memory getSecurityDescriptorForFile(String string) {
        int n2;
        int n3 = 7;
        IntByReference intByReference = new IntByReference();
        boolean bl2 = Advapi32.INSTANCE.GetFileSecurity(string, 7, null, 0, intByReference);
        if (!bl2 && 122 != (n2 = Kernel32.INSTANCE.GetLastError())) {
            throw new Win32Exception(n2);
        }
        n2 = intByReference.getValue();
        Memory memory = new Memory(n2);
        bl2 = Advapi32.INSTANCE.GetFileSecurity(string, 7, memory, n2, intByReference);
        if (!bl2) {
            memory.clear();
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return memory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Memory getSecurityDescriptorForObject(String string, int n2, boolean bl2) {
        PointerByReference pointerByReference;
        int n3 = 7 | (bl2 ? 8 : 0);
        int n4 = Advapi32.INSTANCE.GetNamedSecurityInfo(string, n2, n3, null, null, null, null, pointerByReference = new PointerByReference());
        if (n4 != 0) {
            throw new Win32Exception(n4);
        }
        int n5 = Advapi32.INSTANCE.GetSecurityDescriptorLength(pointerByReference.getValue());
        Memory memory = new Memory(n5);
        Pointer pointer = pointerByReference.getValue();
        try {
            byte[] byArray = pointer.getByteArray(0L, n5);
            memory.write(0L, byArray, 0, n5);
            Memory memory2 = memory;
            return memory2;
        }
        finally {
            Kernel32Util.freeLocalMemory(pointer);
        }
    }

    public static void setSecurityDescriptorForObject(String string, int n2, WinNT$SECURITY_DESCRIPTOR_RELATIVE winNT$SECURITY_DESCRIPTOR_RELATIVE, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        int n3;
        WinNT$PSID winNT$PSID = winNT$SECURITY_DESCRIPTOR_RELATIVE.getOwner();
        WinNT$PSID winNT$PSID2 = winNT$SECURITY_DESCRIPTOR_RELATIVE.getGroup();
        WinNT$ACL winNT$ACL = winNT$SECURITY_DESCRIPTOR_RELATIVE.getDiscretionaryACL();
        WinNT$ACL winNT$ACL2 = winNT$SECURITY_DESCRIPTOR_RELATIVE.getSystemACL();
        int n4 = 0;
        if (bl2) {
            if (winNT$PSID == null) {
                throw new IllegalArgumentException("SECURITY_DESCRIPTOR_RELATIVE does not contain owner");
            }
            if (!Advapi32.INSTANCE.IsValidSid(winNT$PSID)) {
                throw new IllegalArgumentException("Owner PSID is invalid");
            }
            n4 |= 1;
        }
        if (bl3) {
            if (winNT$PSID2 == null) {
                throw new IllegalArgumentException("SECURITY_DESCRIPTOR_RELATIVE does not contain group");
            }
            if (!Advapi32.INSTANCE.IsValidSid(winNT$PSID2)) {
                throw new IllegalArgumentException("Group PSID is invalid");
            }
            n4 |= 2;
        }
        if (bl4) {
            if (winNT$ACL == null) {
                throw new IllegalArgumentException("SECURITY_DESCRIPTOR_RELATIVE does not contain DACL");
            }
            if (!Advapi32.INSTANCE.IsValidAcl(winNT$ACL.getPointer())) {
                throw new IllegalArgumentException("DACL is invalid");
            }
            n4 |= 4;
        }
        if (bl5) {
            if (winNT$ACL2 == null) {
                throw new IllegalArgumentException("SECURITY_DESCRIPTOR_RELATIVE does not contain SACL");
            }
            if (!Advapi32.INSTANCE.IsValidAcl(winNT$ACL2.getPointer())) {
                throw new IllegalArgumentException("SACL is invalid");
            }
            n4 |= 8;
        }
        if (bl6) {
            if ((winNT$SECURITY_DESCRIPTOR_RELATIVE.Control & 0x1000) != 0) {
                n4 |= Integer.MIN_VALUE;
            } else if ((winNT$SECURITY_DESCRIPTOR_RELATIVE.Control & 0x1000) == 0) {
                n4 |= 0x20000000;
            }
        }
        if (bl7) {
            if ((winNT$SECURITY_DESCRIPTOR_RELATIVE.Control & 0x2000) != 0) {
                n4 |= 0x40000000;
            } else if ((winNT$SECURITY_DESCRIPTOR_RELATIVE.Control & 0x2000) == 0) {
                n4 |= 0x10000000;
            }
        }
        if ((n3 = Advapi32.INSTANCE.SetNamedSecurityInfo(string, n2, n4, bl2 ? winNT$PSID.getPointer() : null, bl3 ? winNT$PSID2.getPointer() : null, bl4 ? winNT$ACL.getPointer() : null, bl5 ? winNT$ACL2.getPointer() : null)) != 0) {
            throw new Win32Exception(n3);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean accessCheck(File file, Advapi32Util$AccessCheckPermission advapi32Util$AccessCheckPermission) {
        boolean bl2;
        Memory memory = Advapi32Util.getSecurityDescriptorForFile(file.getAbsolutePath().replace('/', '\\'));
        WinNT$HANDLEByReference winNT$HANDLEByReference = new WinNT$HANDLEByReference();
        WinNT$HANDLEByReference winNT$HANDLEByReference2 = new WinNT$HANDLEByReference();
        Win32Exception win32Exception = null;
        try {
            int n2 = 131086;
            WinNT$HANDLE winNT$HANDLE = Kernel32.INSTANCE.GetCurrentProcess();
            if (!Advapi32.INSTANCE.OpenProcessToken(winNT$HANDLE, n2, winNT$HANDLEByReference)) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            if (!Advapi32.INSTANCE.DuplicateToken(winNT$HANDLEByReference.getValue(), 2, winNT$HANDLEByReference2)) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            WinNT$GENERIC_MAPPING winNT$GENERIC_MAPPING = new WinNT$GENERIC_MAPPING();
            winNT$GENERIC_MAPPING.genericRead = new WinDef$DWORD(1179785L);
            winNT$GENERIC_MAPPING.genericWrite = new WinDef$DWORD(1179926L);
            winNT$GENERIC_MAPPING.genericExecute = new WinDef$DWORD(1179808L);
            winNT$GENERIC_MAPPING.genericAll = new WinDef$DWORD(0x1F01FFL);
            WinDef$DWORDByReference winDef$DWORDByReference = new WinDef$DWORDByReference(new WinDef$DWORD((long)advapi32Util$AccessCheckPermission.getCode()));
            Advapi32.INSTANCE.MapGenericMask(winDef$DWORDByReference, winNT$GENERIC_MAPPING);
            WinNT$PRIVILEGE_SET winNT$PRIVILEGE_SET = new WinNT$PRIVILEGE_SET(1);
            winNT$PRIVILEGE_SET.PrivilegeCount = new WinDef$DWORD(0L);
            WinDef$DWORDByReference winDef$DWORDByReference2 = new WinDef$DWORDByReference(new WinDef$DWORD((long)winNT$PRIVILEGE_SET.size()));
            WinDef$DWORDByReference winDef$DWORDByReference3 = new WinDef$DWORDByReference();
            WinDef$BOOLByReference winDef$BOOLByReference = new WinDef$BOOLByReference();
            if (!Advapi32.INSTANCE.AccessCheck(memory, winNT$HANDLEByReference2.getValue(), winDef$DWORDByReference.getValue(), winNT$GENERIC_MAPPING, winNT$PRIVILEGE_SET, winDef$DWORDByReference2, winDef$DWORDByReference3, winDef$BOOLByReference)) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            bl2 = winDef$BOOLByReference.getValue().booleanValue();
        }
        catch (Win32Exception win32Exception3) {
            try {
                win32Exception = win32Exception3;
                throw win32Exception;
            }
            catch (Throwable throwable) {
                block17: {
                    try {
                        Kernel32Util.closeHandleRefs(winNT$HANDLEByReference, winNT$HANDLEByReference2);
                    }
                    catch (Win32Exception win32Exception4) {
                        if (win32Exception == null) {
                            win32Exception = win32Exception4;
                            break block17;
                        }
                        win32Exception.addSuppressedReflected(win32Exception4);
                    }
                }
                if (memory != null) {
                    memory.clear();
                }
                if (win32Exception != null) {
                    throw win32Exception;
                }
                throw throwable;
            }
        }
        try {
            Kernel32Util.closeHandleRefs(winNT$HANDLEByReference, winNT$HANDLEByReference2);
        }
        catch (Win32Exception win32Exception2) {
            if (win32Exception == null) {
                win32Exception = win32Exception2;
            }
            win32Exception.addSuppressedReflected(win32Exception2);
        }
        if (memory != null) {
            memory.clear();
        }
        if (win32Exception != null) {
            throw win32Exception;
        }
        return bl2;
    }

    public static WinNT$SECURITY_DESCRIPTOR_RELATIVE getFileSecurityDescriptor(File file, boolean bl2) {
        Memory memory = Advapi32Util.getSecurityDescriptorForObject(file.getAbsolutePath().replaceAll("/", "\\"), 1, bl2);
        WinNT$SECURITY_DESCRIPTOR_RELATIVE winNT$SECURITY_DESCRIPTOR_RELATIVE = new WinNT$SECURITY_DESCRIPTOR_RELATIVE(memory);
        return winNT$SECURITY_DESCRIPTOR_RELATIVE;
    }

    public static void setFileSecurityDescriptor(File file, WinNT$SECURITY_DESCRIPTOR_RELATIVE winNT$SECURITY_DESCRIPTOR_RELATIVE, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        Advapi32Util.setSecurityDescriptorForObject(file.getAbsolutePath().replaceAll("/", "\\"), 1, winNT$SECURITY_DESCRIPTOR_RELATIVE, bl2, bl3, bl4, bl5, bl6, bl7);
    }

    public static void encryptFile(File file) {
        String string = file.getAbsolutePath();
        if (!Advapi32.INSTANCE.EncryptFile(string)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    public static void decryptFile(File file) {
        String string = file.getAbsolutePath();
        if (!Advapi32.INSTANCE.DecryptFile(string, new WinDef$DWORD(0L))) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    public static int fileEncryptionStatus(File file) {
        WinDef$DWORDByReference winDef$DWORDByReference = new WinDef$DWORDByReference();
        String string = file.getAbsolutePath();
        if (!Advapi32.INSTANCE.FileEncryptionStatus(string, winDef$DWORDByReference)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return winDef$DWORDByReference.getValue().intValue();
    }

    public static void disableEncryption(File file, boolean bl2) {
        String string = file.getAbsolutePath();
        if (!Advapi32.INSTANCE.EncryptionDisable(string, bl2)) {
            throw new Win32Exception(Native.getLastError());
        }
    }

    public static void backupEncryptedFile(File file, File file2) {
        PointerByReference pointerByReference;
        String string;
        if (!file2.isDirectory()) {
            throw new IllegalArgumentException("destDir must be a directory.");
        }
        WinDef$ULONG winDef$ULONG = new WinDef$ULONG(0L);
        WinDef$ULONG winDef$ULONG2 = new WinDef$ULONG(1L);
        if (file.isDirectory()) {
            winDef$ULONG2.setValue(3L);
        }
        if (Advapi32.INSTANCE.OpenEncryptedFileRaw(string = file.getAbsolutePath(), winDef$ULONG, pointerByReference = new PointerByReference()) != 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Advapi32Util$1 advapi32Util$1 = new Advapi32Util$1(byteArrayOutputStream);
        if (Advapi32.INSTANCE.ReadEncryptedFileRaw(advapi32Util$1, null, pointerByReference.getValue()) != 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        Advapi32.INSTANCE.CloseEncryptedFileRaw(pointerByReference.getValue());
        String string2 = file2.getAbsolutePath() + File.separator + file.getName();
        pointerByReference = new PointerByReference();
        if (Advapi32.INSTANCE.OpenEncryptedFileRaw(string2, winDef$ULONG2, pointerByReference) != 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        IntByReference intByReference = new IntByReference(0);
        Advapi32Util$2 advapi32Util$2 = new Advapi32Util$2(intByReference, byteArrayOutputStream);
        if (Advapi32.INSTANCE.WriteEncryptedFileRaw(advapi32Util$2, null, pointerByReference.getValue()) != 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        Advapi32.INSTANCE.CloseEncryptedFileRaw(pointerByReference.getValue());
    }
}

