/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM;

import com.sun.jna.WString;
import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.COMInvoker;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.COM.Dispatch;
import com.sun.jna.platform.win32.COM.IDispatch;
import com.sun.jna.platform.win32.COM.IUnknown;
import com.sun.jna.platform.win32.COM.Unknown;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.Guid$CLSID;
import com.sun.jna.platform.win32.Guid$CLSID$ByReference;
import com.sun.jna.platform.win32.Guid$GUID;
import com.sun.jna.platform.win32.Guid$REFIID;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.OaIdl;
import com.sun.jna.platform.win32.OaIdl$DISPID;
import com.sun.jna.platform.win32.OaIdl$DISPIDByReference;
import com.sun.jna.platform.win32.OaIdl$EXCEPINFO$ByReference;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.OleAuto$DISPPARAMS$ByReference;
import com.sun.jna.platform.win32.Variant$VARIANT;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinDef$WORD;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;

public class COMBindingBaseObject
extends COMInvoker {
    public static final WinDef.LCID LOCALE_USER_DEFAULT = Kernel32.INSTANCE.GetUserDefaultLCID();
    public static final WinDef.LCID LOCALE_SYSTEM_DEFAULT = Kernel32.INSTANCE.GetSystemDefaultLCID();
    private IUnknown iUnknown;
    private IDispatch iDispatch;
    private PointerByReference pDispatch = new PointerByReference();
    private PointerByReference pUnknown = new PointerByReference();

    public COMBindingBaseObject(IDispatch iDispatch) {
        this.iDispatch = iDispatch;
    }

    public COMBindingBaseObject(Guid$CLSID guid$CLSID, boolean bl2) {
        this(guid$CLSID, bl2, 21);
    }

    public COMBindingBaseObject(Guid$CLSID guid$CLSID, boolean bl2, int n2) {
        assert (COMUtils.comIsInitialized()) : "COM not initialized";
        this.init(bl2, guid$CLSID, n2);
    }

    public COMBindingBaseObject(String string, boolean bl2, int n2) {
        assert (COMUtils.comIsInitialized()) : "COM not initialized";
        Guid$CLSID$ByReference guid$CLSID$ByReference = new Guid$CLSID$ByReference();
        WinNT.HRESULT hRESULT = Ole32.INSTANCE.CLSIDFromProgID(string, guid$CLSID$ByReference);
        COMUtils.checkRC(hRESULT);
        this.init(bl2, guid$CLSID$ByReference, n2);
    }

    public COMBindingBaseObject(String string, boolean bl2) {
        this(string, bl2, 21);
    }

    private void init(boolean bl2, Guid$GUID guid$GUID, int n2) {
        WinNT.HRESULT hRESULT;
        if (bl2) {
            hRESULT = OleAuto.INSTANCE.GetActiveObject(guid$GUID, null, this.pUnknown);
            if (COMUtils.SUCCEEDED(hRESULT)) {
                this.iUnknown = new Unknown(this.pUnknown.getValue());
                hRESULT = this.iUnknown.QueryInterface(new Guid$REFIID(IDispatch.IID_IDISPATCH), this.pDispatch);
            } else {
                hRESULT = Ole32.INSTANCE.CoCreateInstance(guid$GUID, null, n2, IDispatch.IID_IDISPATCH, this.pDispatch);
            }
        } else {
            hRESULT = Ole32.INSTANCE.CoCreateInstance(guid$GUID, null, n2, IDispatch.IID_IDISPATCH, this.pDispatch);
        }
        COMUtils.checkRC(hRESULT);
        this.iDispatch = new Dispatch(this.pDispatch.getValue());
    }

    public IDispatch getIDispatch() {
        return this.iDispatch;
    }

    public PointerByReference getIDispatchPointer() {
        return this.pDispatch;
    }

    public IUnknown getIUnknown() {
        return this.iUnknown;
    }

    public PointerByReference getIUnknownPointer() {
        return this.pUnknown;
    }

    public void release() {
        if (this.iDispatch != null) {
            this.iDispatch.Release();
        }
    }

    protected WinNT.HRESULT oleMethod(int n2, Variant$VARIANT.ByReference byReference, String string, Variant$VARIANT[] variant$VARIANTArray) {
        WString[] wStringArray = new WString[]{new WString(string)};
        OaIdl$DISPIDByReference oaIdl$DISPIDByReference = new OaIdl$DISPIDByReference();
        WinNT.HRESULT hRESULT = this.iDispatch.GetIDsOfNames(new Guid$REFIID(Guid.IID_NULL), wStringArray, 1, LOCALE_USER_DEFAULT, oaIdl$DISPIDByReference);
        COMUtils.checkRC(hRESULT);
        return this.oleMethod(n2, byReference, this.iDispatch, oaIdl$DISPIDByReference.getValue(), variant$VARIANTArray);
    }

    protected WinNT.HRESULT oleMethod(int n2, Variant$VARIANT.ByReference byReference, OaIdl$DISPID oaIdl$DISPID, Variant$VARIANT[] variant$VARIANTArray) {
        int n3;
        int n4 = 0;
        Variant$VARIANT[] variant$VARIANTArray2 = null;
        OleAuto$DISPPARAMS$ByReference oleAuto$DISPPARAMS$ByReference = new OleAuto$DISPPARAMS$ByReference();
        OaIdl$EXCEPINFO$ByReference oaIdl$EXCEPINFO$ByReference = new OaIdl$EXCEPINFO$ByReference();
        IntByReference intByReference = new IntByReference();
        if (variant$VARIANTArray != null && variant$VARIANTArray.length > 0) {
            n4 = variant$VARIANTArray.length;
            variant$VARIANTArray2 = new Variant$VARIANT[n4];
            n3 = n4;
            for (int i2 = 0; i2 < n4; ++i2) {
                variant$VARIANTArray2[i2] = variant$VARIANTArray[--n3];
            }
        }
        if (n2 == 4) {
            oleAuto$DISPPARAMS$ByReference.setRgdispidNamedArgs(new OaIdl$DISPID[]{OaIdl.DISPID_PROPERTYPUT});
        }
        if (n4 > 0) {
            oleAuto$DISPPARAMS$ByReference.setArgs(variant$VARIANTArray2);
            oleAuto$DISPPARAMS$ByReference.write();
        }
        n3 = n2 == 1 || n2 == 2 ? 3 : n2;
        WinNT.HRESULT hRESULT = this.iDispatch.Invoke(oaIdl$DISPID, new Guid$REFIID(Guid.IID_NULL), LOCALE_SYSTEM_DEFAULT, new WinDef$WORD((long)n3), oleAuto$DISPPARAMS$ByReference, byReference, oaIdl$EXCEPINFO$ByReference, intByReference);
        COMUtils.checkRC(hRESULT, oaIdl$EXCEPINFO$ByReference, intByReference);
        return hRESULT;
    }

    protected WinNT.HRESULT oleMethod(int n2, Variant$VARIANT.ByReference byReference, String string, Variant$VARIANT variant$VARIANT) {
        return this.oleMethod(n2, byReference, string, new Variant$VARIANT[]{variant$VARIANT});
    }

    protected WinNT.HRESULT oleMethod(int n2, Variant$VARIANT.ByReference byReference, OaIdl$DISPID oaIdl$DISPID, Variant$VARIANT variant$VARIANT) {
        return this.oleMethod(n2, byReference, oaIdl$DISPID, new Variant$VARIANT[]{variant$VARIANT});
    }

    protected WinNT.HRESULT oleMethod(int n2, Variant$VARIANT.ByReference byReference, String string) {
        return this.oleMethod(n2, byReference, string, (Variant$VARIANT[])null);
    }

    protected WinNT.HRESULT oleMethod(int n2, Variant$VARIANT.ByReference byReference, OaIdl$DISPID oaIdl$DISPID) {
        return this.oleMethod(n2, byReference, oaIdl$DISPID, (Variant$VARIANT[])null);
    }

    protected WinNT.HRESULT oleMethod(int n2, Variant$VARIANT.ByReference byReference, IDispatch iDispatch, String string, Variant$VARIANT[] variant$VARIANTArray) {
        if (iDispatch == null) {
            throw new COMException("pDisp (IDispatch) parameter is null!");
        }
        WString[] wStringArray = new WString[]{new WString(string)};
        OaIdl$DISPIDByReference oaIdl$DISPIDByReference = new OaIdl$DISPIDByReference();
        WinNT.HRESULT hRESULT = iDispatch.GetIDsOfNames(new Guid$REFIID(Guid.IID_NULL), wStringArray, 1, LOCALE_USER_DEFAULT, oaIdl$DISPIDByReference);
        COMUtils.checkRC(hRESULT);
        return this.oleMethod(n2, byReference, iDispatch, oaIdl$DISPIDByReference.getValue(), variant$VARIANTArray);
    }

    protected WinNT.HRESULT oleMethod(int n2, Variant$VARIANT.ByReference byReference, IDispatch iDispatch, OaIdl$DISPID oaIdl$DISPID, Variant$VARIANT[] variant$VARIANTArray) {
        int n3;
        if (iDispatch == null) {
            throw new COMException("pDisp (IDispatch) parameter is null!");
        }
        int n4 = 0;
        Variant$VARIANT[] variant$VARIANTArray2 = null;
        OleAuto$DISPPARAMS$ByReference oleAuto$DISPPARAMS$ByReference = new OleAuto$DISPPARAMS$ByReference();
        OaIdl$EXCEPINFO$ByReference oaIdl$EXCEPINFO$ByReference = new OaIdl$EXCEPINFO$ByReference();
        IntByReference intByReference = new IntByReference();
        if (variant$VARIANTArray != null && variant$VARIANTArray.length > 0) {
            n4 = variant$VARIANTArray.length;
            variant$VARIANTArray2 = new Variant$VARIANT[n4];
            n3 = n4;
            for (int i2 = 0; i2 < n4; ++i2) {
                variant$VARIANTArray2[i2] = variant$VARIANTArray[--n3];
            }
        }
        if (n2 == 4) {
            oleAuto$DISPPARAMS$ByReference.setRgdispidNamedArgs(new OaIdl$DISPID[]{OaIdl.DISPID_PROPERTYPUT});
        }
        if (n4 > 0) {
            oleAuto$DISPPARAMS$ByReference.setArgs(variant$VARIANTArray2);
            oleAuto$DISPPARAMS$ByReference.write();
        }
        n3 = n2 == 1 || n2 == 2 ? 3 : n2;
        WinNT.HRESULT hRESULT = iDispatch.Invoke(oaIdl$DISPID, new Guid$REFIID(Guid.IID_NULL), LOCALE_SYSTEM_DEFAULT, new WinDef$WORD((long)n3), oleAuto$DISPPARAMS$ByReference, byReference, oaIdl$EXCEPINFO$ByReference, intByReference);
        COMUtils.checkRC(hRESULT, oaIdl$EXCEPINFO$ByReference, intByReference);
        return hRESULT;
    }

    protected WinNT.HRESULT oleMethod(int n2, Variant$VARIANT.ByReference byReference, IDispatch iDispatch, String string, Variant$VARIANT variant$VARIANT) {
        return this.oleMethod(n2, byReference, iDispatch, string, new Variant$VARIANT[]{variant$VARIANT});
    }

    protected WinNT.HRESULT oleMethod(int n2, Variant$VARIANT.ByReference byReference, IDispatch iDispatch, OaIdl$DISPID oaIdl$DISPID, Variant$VARIANT variant$VARIANT) {
        return this.oleMethod(n2, byReference, iDispatch, oaIdl$DISPID, new Variant$VARIANT[]{variant$VARIANT});
    }

    protected WinNT.HRESULT oleMethod(int n2, Variant$VARIANT.ByReference byReference, IDispatch iDispatch, String string) {
        return this.oleMethod(n2, byReference, iDispatch, string, (Variant$VARIANT[])null);
    }

    protected WinNT.HRESULT oleMethod(int n2, Variant$VARIANT.ByReference byReference, IDispatch iDispatch, OaIdl$DISPID oaIdl$DISPID) {
        return this.oleMethod(n2, byReference, iDispatch, oaIdl$DISPID, (Variant$VARIANT[])null);
    }

    protected void checkFailed(WinNT.HRESULT hRESULT) {
        COMUtils.checkRC(hRESULT);
    }
}

