/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Advapi32Util$EnumKey;
import com.sun.jna.platform.win32.Advapi32Util$InfoKey;
import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.COMInvokeException;
import com.sun.jna.platform.win32.COM.COMUtils$COMInfo;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.OaIdl$EXCEPINFO;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.W32Errors;
import com.sun.jna.platform.win32.WinNT$HRESULT;
import com.sun.jna.platform.win32.WinReg;
import com.sun.jna.platform.win32.WinReg$HKEYByReference;
import com.sun.jna.ptr.IntByReference;
import java.util.ArrayList;

public abstract class COMUtils {
    public static final int S_OK = 0;
    public static final int S_FALSE = 1;
    public static final int E_UNEXPECTED = -2147418113;

    public static boolean SUCCEEDED(WinNT$HRESULT winNT$HRESULT) {
        return COMUtils.SUCCEEDED(winNT$HRESULT.intValue());
    }

    public static boolean SUCCEEDED(int n2) {
        return n2 >= 0;
    }

    public static boolean FAILED(WinNT$HRESULT winNT$HRESULT) {
        return COMUtils.FAILED(winNT$HRESULT.intValue());
    }

    public static boolean FAILED(int n2) {
        return n2 < 0;
    }

    public static void checkRC(WinNT$HRESULT winNT$HRESULT) {
        if (COMUtils.FAILED(winNT$HRESULT)) {
            String string;
            try {
                string = Kernel32Util.formatMessage(winNT$HRESULT) + "(HRESULT: " + Integer.toHexString(winNT$HRESULT.intValue()) + ")";
            }
            catch (LastErrorException lastErrorException) {
                string = "(HRESULT: " + Integer.toHexString(winNT$HRESULT.intValue()) + ")";
            }
            throw new COMException(string, winNT$HRESULT);
        }
    }

    public static void checkRC(WinNT$HRESULT winNT$HRESULT, OaIdl$EXCEPINFO oaIdl$EXCEPINFO, IntByReference intByReference) {
        Object var3_3 = null;
        if (COMUtils.FAILED(winNT$HRESULT)) {
            StringBuilder stringBuilder = new StringBuilder();
            Integer n2 = null;
            Integer n3 = null;
            Integer n4 = null;
            String string = null;
            String string2 = null;
            Integer n5 = null;
            String string3 = null;
            if (intByReference != null) {
                n2 = intByReference.getValue();
            }
            try {
                stringBuilder.append(Kernel32Util.formatMessage(winNT$HRESULT));
            }
            catch (LastErrorException lastErrorException) {
                // empty catch block
            }
            stringBuilder.append("(HRESULT: ");
            stringBuilder.append(Integer.toHexString(winNT$HRESULT.intValue()));
            stringBuilder.append(")");
            if (oaIdl$EXCEPINFO != null) {
                n3 = oaIdl$EXCEPINFO.wCode.intValue();
                n4 = oaIdl$EXCEPINFO.scode.intValue();
                n5 = oaIdl$EXCEPINFO.dwHelpContext.intValue();
                if (oaIdl$EXCEPINFO.bstrSource != null) {
                    string3 = oaIdl$EXCEPINFO.bstrSource.getValue();
                    stringBuilder.append("\nSource:      ");
                    stringBuilder.append(string3);
                }
                if (oaIdl$EXCEPINFO.bstrDescription != null) {
                    string = oaIdl$EXCEPINFO.bstrDescription.getValue();
                    stringBuilder.append("\nDescription: ");
                    stringBuilder.append(string);
                }
                if (oaIdl$EXCEPINFO.bstrHelpFile != null) {
                    string2 = oaIdl$EXCEPINFO.bstrHelpFile.getValue();
                }
            }
            throw new COMInvokeException(stringBuilder.toString(), winNT$HRESULT, n2, string, n5, string2, n4, string3, n3);
        }
        if (oaIdl$EXCEPINFO != null) {
            if (oaIdl$EXCEPINFO.bstrSource != null) {
                OleAuto.INSTANCE.SysFreeString(oaIdl$EXCEPINFO.bstrSource);
            }
            if (oaIdl$EXCEPINFO.bstrDescription != null) {
                OleAuto.INSTANCE.SysFreeString(oaIdl$EXCEPINFO.bstrDescription);
            }
            if (oaIdl$EXCEPINFO.bstrHelpFile != null) {
                OleAuto.INSTANCE.SysFreeString(oaIdl$EXCEPINFO.bstrHelpFile);
            }
        }
        if (var3_3 != null) {
            throw var3_3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getAllCOMInfoOnSystem() {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        WinReg$HKEYByReference winReg$HKEYByReference2 = new WinReg$HKEYByReference();
        ArrayList<COMUtils$COMInfo> arrayList = new ArrayList<COMUtils$COMInfo>();
        try {
            winReg$HKEYByReference = Advapi32Util.registryGetKey(WinReg.HKEY_CLASSES_ROOT, "CLSID", 131097);
            Advapi32Util$InfoKey advapi32Util$InfoKey = Advapi32Util.registryQueryInfoKey(winReg$HKEYByReference.getValue(), 131097);
            for (int i2 = 0; i2 < advapi32Util$InfoKey.lpcSubKeys.getValue(); ++i2) {
                Advapi32Util$EnumKey advapi32Util$EnumKey = Advapi32Util.registryRegEnumKey(winReg$HKEYByReference.getValue(), i2);
                String string = Native.toString(advapi32Util$EnumKey.lpName);
                COMUtils$COMInfo cOMUtils$COMInfo = new COMUtils$COMInfo(string);
                winReg$HKEYByReference2 = Advapi32Util.registryGetKey(winReg$HKEYByReference.getValue(), string, 131097);
                Advapi32Util$InfoKey advapi32Util$InfoKey2 = Advapi32Util.registryQueryInfoKey(winReg$HKEYByReference2.getValue(), 131097);
                for (int i3 = 0; i3 < advapi32Util$InfoKey2.lpcSubKeys.getValue(); ++i3) {
                    Advapi32Util$EnumKey advapi32Util$EnumKey2 = Advapi32Util.registryRegEnumKey(winReg$HKEYByReference2.getValue(), i3);
                    String string2 = Native.toString(advapi32Util$EnumKey2.lpName);
                    if (string2.equals("InprocHandler32")) {
                        cOMUtils$COMInfo.inprocHandler32 = (String)Advapi32Util.registryGetValue(winReg$HKEYByReference2.getValue(), string2, null);
                        continue;
                    }
                    if (string2.equals("InprocServer32")) {
                        cOMUtils$COMInfo.inprocServer32 = (String)Advapi32Util.registryGetValue(winReg$HKEYByReference2.getValue(), string2, null);
                        continue;
                    }
                    if (string2.equals("LocalServer32")) {
                        cOMUtils$COMInfo.localServer32 = (String)Advapi32Util.registryGetValue(winReg$HKEYByReference2.getValue(), string2, null);
                        continue;
                    }
                    if (string2.equals("ProgID")) {
                        cOMUtils$COMInfo.progID = (String)Advapi32Util.registryGetValue(winReg$HKEYByReference2.getValue(), string2, null);
                        continue;
                    }
                    if (!string2.equals("TypeLib")) continue;
                    cOMUtils$COMInfo.typeLib = (String)Advapi32Util.registryGetValue(winReg$HKEYByReference2.getValue(), string2, null);
                }
                Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference2.getValue());
                arrayList.add(cOMUtils$COMInfo);
            }
        }
        finally {
            Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference2.getValue());
        }
        return arrayList;
    }

    public static boolean comIsInitialized() {
        WinNT$HRESULT winNT$HRESULT = Ole32.INSTANCE.CoInitializeEx(Pointer.NULL, 0);
        if (winNT$HRESULT.equals(W32Errors.S_OK)) {
            Ole32.INSTANCE.CoUninitialize();
            return false;
        }
        if (winNT$HRESULT.equals(W32Errors.S_FALSE)) {
            Ole32.INSTANCE.CoUninitialize();
            return true;
        }
        if (winNT$HRESULT.intValue() == -2147417850) {
            return true;
        }
        COMUtils.checkRC(winNT$HRESULT);
        return false;
    }
}

