/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import kemnn.ez;
import net.java.games.input.AbstractComponent;
import net.java.games.input.Component;
import net.java.games.input.Component$Identifier;
import net.java.games.input.Component$Identifier$Axis;
import net.java.games.input.Component$Identifier$Button;
import net.java.games.input.Controller;
import net.java.games.input.Controller$Type;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.Keyboard;
import net.java.games.input.LinuxAbstractController;
import net.java.games.input.LinuxCombinedController;
import net.java.games.input.LinuxComponent;
import net.java.games.input.LinuxDeviceTask;
import net.java.games.input.LinuxDeviceThread;
import net.java.games.input.LinuxEnvironmentPlugin$1;
import net.java.games.input.LinuxEnvironmentPlugin$2;
import net.java.games.input.LinuxEnvironmentPlugin$3;
import net.java.games.input.LinuxEnvironmentPlugin$4;
import net.java.games.input.LinuxEnvironmentPlugin$5;
import net.java.games.input.LinuxEnvironmentPlugin$6;
import net.java.games.input.LinuxEnvironmentPlugin$7;
import net.java.games.input.LinuxEnvironmentPlugin$8;
import net.java.games.input.LinuxEventComponent;
import net.java.games.input.LinuxEventDevice;
import net.java.games.input.LinuxJoystickAbstractController;
import net.java.games.input.LinuxJoystickAxis;
import net.java.games.input.LinuxJoystickButton;
import net.java.games.input.LinuxJoystickDevice;
import net.java.games.input.LinuxJoystickPOV;
import net.java.games.input.LinuxKeyboard;
import net.java.games.input.LinuxMouse;
import net.java.games.input.LinuxNativeTypesMap;
import net.java.games.input.LinuxPOV;
import net.java.games.input.Mouse;
import net.java.games.input.Rumbler;

public final class LinuxEnvironmentPlugin
extends ControllerEnvironment
implements ez {
    private static final String LIBNAME = "jinput-linux";
    private static final String POSTFIX64BIT = "64";
    private static boolean supported = false;
    private final Controller[] controllers;
    private final List devices = new ArrayList();
    private static final LinuxDeviceThread device_thread = new LinuxDeviceThread();

    static void loadLibrary(String string) {
        AccessController.doPrivileged(new LinuxEnvironmentPlugin$1(string));
    }

    static String getPrivilegedProperty(String string) {
        return (String)AccessController.doPrivileged(new LinuxEnvironmentPlugin$2(string));
    }

    static String getPrivilegedProperty(String string, String string2) {
        return (String)AccessController.doPrivileged(new LinuxEnvironmentPlugin$3(string, string2));
    }

    public static final Object execute(LinuxDeviceTask linuxDeviceTask) {
        return device_thread.execute(linuxDeviceTask);
    }

    public LinuxEnvironmentPlugin() {
        if (this.isSupported()) {
            this.controllers = this.enumerateControllers();
            LinuxEnvironmentPlugin.logln(new StringBuffer().append("Linux plugin claims to have found ").append(this.controllers.length).append(" controllers").toString());
            AccessController.doPrivileged(new LinuxEnvironmentPlugin$4(this));
        } else {
            this.controllers = new Controller[0];
        }
    }

    @Override
    public final Controller[] getControllers() {
        return this.controllers;
    }

    private static final Component[] createComponents(List list2, LinuxEventDevice linuxEventDevice) {
        Object object;
        LinuxEventComponent linuxEventComponent;
        int n2;
        LinuxEventComponent[][] linuxEventComponentArray = new LinuxEventComponent[4][2];
        ArrayList<LinuxComponent> arrayList = new ArrayList<LinuxComponent>();
        for (n2 = 0; n2 < list2.size(); ++n2) {
            linuxEventComponent = (LinuxEventComponent)list2.get(n2);
            object = linuxEventComponent.getIdentifier();
            if (object == Component$Identifier$Axis.POV) {
                int n3 = linuxEventComponent.getDescriptor().getCode();
                switch (n3) {
                    case 16: {
                        linuxEventComponentArray[0][0] = linuxEventComponent;
                        break;
                    }
                    case 17: {
                        linuxEventComponentArray[0][1] = linuxEventComponent;
                        break;
                    }
                    case 18: {
                        linuxEventComponentArray[1][0] = linuxEventComponent;
                        break;
                    }
                    case 19: {
                        linuxEventComponentArray[1][1] = linuxEventComponent;
                        break;
                    }
                    case 20: {
                        linuxEventComponentArray[2][0] = linuxEventComponent;
                        break;
                    }
                    case 21: {
                        linuxEventComponentArray[2][1] = linuxEventComponent;
                        break;
                    }
                    case 22: {
                        linuxEventComponentArray[3][0] = linuxEventComponent;
                        break;
                    }
                    case 23: {
                        linuxEventComponentArray[3][1] = linuxEventComponent;
                        break;
                    }
                    default: {
                        LinuxEnvironmentPlugin.logln(new StringBuffer().append("Unknown POV instance: ").append(n3).toString());
                        break;
                    }
                }
                continue;
            }
            if (object == null) continue;
            LinuxComponent linuxComponent = new LinuxComponent(linuxEventComponent);
            arrayList.add(linuxComponent);
            linuxEventDevice.registerComponent(linuxEventComponent.getDescriptor(), linuxComponent);
        }
        for (n2 = 0; n2 < linuxEventComponentArray.length; ++n2) {
            linuxEventComponent = linuxEventComponentArray[n2][0];
            object = linuxEventComponentArray[n2][1];
            if (linuxEventComponent == null || object == null) continue;
            LinuxPOV linuxPOV = new LinuxPOV(linuxEventComponent, (LinuxEventComponent)object);
            arrayList.add(linuxPOV);
            linuxEventDevice.registerComponent(linuxEventComponent.getDescriptor(), linuxPOV);
            linuxEventDevice.registerComponent(((LinuxEventComponent)object).getDescriptor(), linuxPOV);
        }
        Component[] componentArray = new Component[arrayList.size()];
        arrayList.toArray(componentArray);
        return componentArray;
    }

    private static final Mouse createMouseFromDevice(LinuxEventDevice linuxEventDevice, Component[] componentArray) {
        LinuxMouse linuxMouse = new LinuxMouse(linuxEventDevice, componentArray, new Controller[0], linuxEventDevice.getRumblers());
        if (linuxMouse.getX() != null && linuxMouse.getY() != null && linuxMouse.getPrimaryButton() != null) {
            return linuxMouse;
        }
        return null;
    }

    private static final Keyboard createKeyboardFromDevice(LinuxEventDevice linuxEventDevice, Component[] componentArray) {
        LinuxKeyboard linuxKeyboard = new LinuxKeyboard(linuxEventDevice, componentArray, new Controller[0], linuxEventDevice.getRumblers());
        return linuxKeyboard;
    }

    private static final Controller createJoystickFromDevice(LinuxEventDevice linuxEventDevice, Component[] componentArray, Controller$Type controller$Type) {
        LinuxAbstractController linuxAbstractController = new LinuxAbstractController(linuxEventDevice, componentArray, new Controller[0], linuxEventDevice.getRumblers(), controller$Type);
        return linuxAbstractController;
    }

    private static final Controller createControllerFromDevice(LinuxEventDevice linuxEventDevice) {
        List list2 = linuxEventDevice.getComponents();
        Component[] componentArray = LinuxEnvironmentPlugin.createComponents(list2, linuxEventDevice);
        Controller$Type controller$Type = linuxEventDevice.getType();
        if (controller$Type == Controller$Type.MOUSE) {
            return LinuxEnvironmentPlugin.createMouseFromDevice(linuxEventDevice, componentArray);
        }
        if (controller$Type == Controller$Type.KEYBOARD) {
            return LinuxEnvironmentPlugin.createKeyboardFromDevice(linuxEventDevice, componentArray);
        }
        if (controller$Type == Controller$Type.STICK || controller$Type == Controller$Type.GAMEPAD) {
            return LinuxEnvironmentPlugin.createJoystickFromDevice(linuxEventDevice, componentArray, controller$Type);
        }
        return null;
    }

    private final Controller[] enumerateControllers() {
        ArrayList<LinuxCombinedController> arrayList = new ArrayList<LinuxCombinedController>();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        this.enumerateEventControllers(arrayList2);
        this.enumerateJoystickControllers(arrayList3);
        block0: for (int i2 = 0; i2 < arrayList2.size(); ++i2) {
            for (int i3 = 0; i3 < arrayList3.size(); ++i3) {
                Component[] componentArray;
                Component[] componentArray2;
                Controller controller = (Controller)arrayList2.get(i2);
                Controller controller2 = (Controller)arrayList3.get(i3);
                if (!controller.getName().equals(controller2.getName()) || (componentArray2 = controller.getComponents()).length != (componentArray = controller2.getComponents()).length) continue;
                boolean bl2 = false;
                for (int i4 = 0; i4 < componentArray2.length; ++i4) {
                    if (componentArray2[i4].getIdentifier() == componentArray[i4].getIdentifier()) continue;
                    bl2 = true;
                }
                if (bl2) continue;
                arrayList.add(new LinuxCombinedController((LinuxAbstractController)arrayList2.remove(i2), (LinuxJoystickAbstractController)arrayList3.remove(i3)));
                --i2;
                --i3;
                continue block0;
            }
        }
        arrayList.addAll(arrayList2);
        arrayList.addAll(arrayList3);
        Controller[] controllerArray = new Controller[arrayList.size()];
        arrayList.toArray(controllerArray);
        return controllerArray;
    }

    private static final Component$Identifier$Button getButtonIdentifier(int n2) {
        switch (n2) {
            case 0: {
                return Component$Identifier$Button._0;
            }
            case 1: {
                return Component$Identifier$Button._1;
            }
            case 2: {
                return Component$Identifier$Button._2;
            }
            case 3: {
                return Component$Identifier$Button._3;
            }
            case 4: {
                return Component$Identifier$Button._4;
            }
            case 5: {
                return Component$Identifier$Button._5;
            }
            case 6: {
                return Component$Identifier$Button._6;
            }
            case 7: {
                return Component$Identifier$Button._7;
            }
            case 8: {
                return Component$Identifier$Button._8;
            }
            case 9: {
                return Component$Identifier$Button._9;
            }
            case 10: {
                return Component$Identifier$Button._10;
            }
            case 11: {
                return Component$Identifier$Button._11;
            }
            case 12: {
                return Component$Identifier$Button._12;
            }
            case 13: {
                return Component$Identifier$Button._13;
            }
            case 14: {
                return Component$Identifier$Button._14;
            }
            case 15: {
                return Component$Identifier$Button._15;
            }
            case 16: {
                return Component$Identifier$Button._16;
            }
            case 17: {
                return Component$Identifier$Button._17;
            }
            case 18: {
                return Component$Identifier$Button._18;
            }
            case 19: {
                return Component$Identifier$Button._19;
            }
            case 20: {
                return Component$Identifier$Button._20;
            }
            case 21: {
                return Component$Identifier$Button._21;
            }
            case 22: {
                return Component$Identifier$Button._22;
            }
            case 23: {
                return Component$Identifier$Button._23;
            }
            case 24: {
                return Component$Identifier$Button._24;
            }
            case 25: {
                return Component$Identifier$Button._25;
            }
            case 26: {
                return Component$Identifier$Button._26;
            }
            case 27: {
                return Component$Identifier$Button._27;
            }
            case 28: {
                return Component$Identifier$Button._28;
            }
            case 29: {
                return Component$Identifier$Button._29;
            }
            case 30: {
                return Component$Identifier$Button._30;
            }
            case 31: {
                return Component$Identifier$Button._31;
            }
        }
        return null;
    }

    private static final Controller createJoystickFromJoystickDevice(LinuxJoystickDevice linuxJoystickDevice) {
        AbstractComponent abstractComponent;
        Component$Identifier component$Identifier;
        int n2;
        ArrayList<LinuxJoystickButton> arrayList = new ArrayList<LinuxJoystickButton>();
        byte[] byArray = linuxJoystickDevice.getAxisMap();
        char[] cArray = linuxJoystickDevice.getButtonMap();
        LinuxJoystickAxis[] linuxJoystickAxisArray = new LinuxJoystickAxis[6];
        for (n2 = 0; n2 < linuxJoystickDevice.getNumButtons(); ++n2) {
            component$Identifier = LinuxNativeTypesMap.getButtonID(cArray[n2]);
            if (component$Identifier == null) continue;
            abstractComponent = new LinuxJoystickButton(component$Identifier);
            linuxJoystickDevice.registerButton(n2, (LinuxJoystickButton)abstractComponent);
            arrayList.add((LinuxJoystickButton)abstractComponent);
        }
        for (n2 = 0; n2 < linuxJoystickDevice.getNumAxes(); ++n2) {
            component$Identifier = (Component$Identifier$Axis)LinuxNativeTypesMap.getAbsAxisID(byArray[n2]);
            abstractComponent = new LinuxJoystickAxis((Component$Identifier$Axis)component$Identifier);
            linuxJoystickDevice.registerAxis(n2, (LinuxJoystickAxis)abstractComponent);
            if (byArray[n2] == 16) {
                linuxJoystickAxisArray[0] = abstractComponent;
                continue;
            }
            if (byArray[n2] == 17) {
                linuxJoystickAxisArray[1] = abstractComponent;
                abstractComponent = new LinuxJoystickPOV(Component$Identifier$Axis.POV, linuxJoystickAxisArray[0], linuxJoystickAxisArray[1]);
                linuxJoystickDevice.registerPOV((LinuxJoystickPOV)abstractComponent);
                arrayList.add((LinuxJoystickButton)abstractComponent);
                continue;
            }
            if (byArray[n2] == 18) {
                linuxJoystickAxisArray[2] = abstractComponent;
                continue;
            }
            if (byArray[n2] == 19) {
                linuxJoystickAxisArray[3] = abstractComponent;
                abstractComponent = new LinuxJoystickPOV(Component$Identifier$Axis.POV, linuxJoystickAxisArray[2], linuxJoystickAxisArray[3]);
                linuxJoystickDevice.registerPOV((LinuxJoystickPOV)abstractComponent);
                arrayList.add((LinuxJoystickButton)abstractComponent);
                continue;
            }
            if (byArray[n2] == 20) {
                linuxJoystickAxisArray[4] = abstractComponent;
                continue;
            }
            if (byArray[n2] == 21) {
                linuxJoystickAxisArray[5] = abstractComponent;
                abstractComponent = new LinuxJoystickPOV(Component$Identifier$Axis.POV, linuxJoystickAxisArray[4], linuxJoystickAxisArray[5]);
                linuxJoystickDevice.registerPOV((LinuxJoystickPOV)abstractComponent);
                arrayList.add((LinuxJoystickButton)abstractComponent);
                continue;
            }
            arrayList.add((LinuxJoystickButton)abstractComponent);
        }
        return new LinuxJoystickAbstractController(linuxJoystickDevice, arrayList.toArray(new Component[0]), new Controller[0], new Rumbler[0]);
    }

    private final void enumerateJoystickControllers(List list2) {
        File[] fileArray = LinuxEnvironmentPlugin.enumerateJoystickDeviceFiles("/dev/input");
        if ((fileArray == null || fileArray.length == 0) && (fileArray = LinuxEnvironmentPlugin.enumerateJoystickDeviceFiles("/dev")) == null) {
            return;
        }
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            File file = fileArray[i2];
            try {
                String string = LinuxEnvironmentPlugin.getAbsolutePathPrivileged(file);
                LinuxJoystickDevice linuxJoystickDevice = new LinuxJoystickDevice(string);
                Controller controller = LinuxEnvironmentPlugin.createJoystickFromJoystickDevice(linuxJoystickDevice);
                if (controller != null) {
                    list2.add(controller);
                    this.devices.add(linuxJoystickDevice);
                    continue;
                }
                linuxJoystickDevice.close();
                continue;
            }
            catch (IOException iOException) {
                LinuxEnvironmentPlugin.logln(new StringBuffer().append("Failed to open device (").append(file).append("): ").append(iOException.getMessage()).toString());
            }
        }
    }

    private static final File[] enumerateJoystickDeviceFiles(String string) {
        File file = new File(string);
        return LinuxEnvironmentPlugin.listFilesPrivileged(file, new LinuxEnvironmentPlugin$5());
    }

    private static String getAbsolutePathPrivileged(File file) {
        return (String)AccessController.doPrivileged(new LinuxEnvironmentPlugin$6(file));
    }

    private static File[] listFilesPrivileged(File file, FilenameFilter filenameFilter) {
        return (File[])AccessController.doPrivileged(new LinuxEnvironmentPlugin$7(file, filenameFilter));
    }

    private final void enumerateEventControllers(List list2) {
        File file = new File("/dev/input");
        File[] fileArray = LinuxEnvironmentPlugin.listFilesPrivileged(file, new LinuxEnvironmentPlugin$8(this));
        if (fileArray == null) {
            return;
        }
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            File file2 = fileArray[i2];
            try {
                String string = LinuxEnvironmentPlugin.getAbsolutePathPrivileged(file2);
                LinuxEventDevice linuxEventDevice = new LinuxEventDevice(string);
                try {
                    Controller controller = LinuxEnvironmentPlugin.createControllerFromDevice(linuxEventDevice);
                    if (controller != null) {
                        list2.add(controller);
                        this.devices.add(linuxEventDevice);
                        continue;
                    }
                    linuxEventDevice.close();
                }
                catch (IOException iOException) {
                    LinuxEnvironmentPlugin.logln(new StringBuffer().append("Failed to create Controller: ").append(iOException.getMessage()).toString());
                    linuxEventDevice.close();
                }
                continue;
            }
            catch (IOException iOException) {
                LinuxEnvironmentPlugin.logln(new StringBuffer().append("Failed to open device (").append(file2).append("): ").append(iOException.getMessage()).toString());
            }
        }
    }

    @Override
    public boolean isSupported() {
        return supported;
    }

    static boolean access$002(boolean bl2) {
        supported = bl2;
        return supported;
    }

    static List access$200(LinuxEnvironmentPlugin linuxEnvironmentPlugin) {
        return linuxEnvironmentPlugin.devices;
    }

    static {
        String string = LinuxEnvironmentPlugin.getPrivilegedProperty("os.name", "").trim();
        if (string.equals("Linux")) {
            supported = true;
            if ("i386".equals(LinuxEnvironmentPlugin.getPrivilegedProperty("os.arch"))) {
                LinuxEnvironmentPlugin.loadLibrary(LIBNAME);
            } else {
                LinuxEnvironmentPlugin.loadLibrary("jinput-linux64");
            }
        }
    }
}

