/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.zip;

import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipException;
import org.apache.tools.zip.UnrecognizedExtraField;
import org.apache.tools.zip.ZipExtraField;
import org.apache.tools.zip.ZipShort;

public class ExtraFieldUtils {
    private static final int WORD = 4;
    private static Hashtable implementations = new Hashtable();
    static Class class$org$apache$tools$zip$AsiExtraField;
    static Class class$org$apache$tools$zip$JarMarker;

    public static void register(Class clazz) {
        try {
            ZipExtraField zipExtraField = (ZipExtraField)clazz.newInstance();
            implementations.put(zipExtraField.getHeaderId(), clazz);
            return;
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException(new StringBuffer().append(clazz).append(" doesn't implement ZipExtraField").toString());
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(new StringBuffer().append(clazz).append(" is not a concrete class").toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(new StringBuffer().append(clazz).append("'s no-arg constructor is not public").toString());
        }
    }

    public static ZipExtraField createExtraField(ZipShort zipShort) {
        Class clazz = (Class)implementations.get(zipShort);
        if (clazz != null) {
            return (ZipExtraField)clazz.newInstance();
        }
        UnrecognizedExtraField unrecognizedExtraField = new UnrecognizedExtraField();
        unrecognizedExtraField.setHeaderId(zipShort);
        return unrecognizedExtraField;
    }

    public static ZipExtraField[] parse(byte[] byArray) {
        Object[] objectArray;
        int n2;
        int n3;
        Vector<ZipExtraField> vector2 = new Vector<ZipExtraField>();
        for (n2 = 0; n2 <= byArray.length - 4; n2 += n3 + 4) {
            objectArray = new ZipShort(byArray, n2);
            n3 = new ZipShort(byArray, n2 + 2).getValue();
            if (n2 + 4 + n3 > byArray.length) {
                throw new ZipException(new StringBuffer().append("data starting at ").append(n2).append(" is in unknown format").toString());
            }
            try {
                ZipExtraField zipExtraField = ExtraFieldUtils.createExtraField((ZipShort)objectArray);
                zipExtraField.parseFromLocalFileData(byArray, n2 + 4, n3);
                vector2.addElement(zipExtraField);
                continue;
            }
            catch (InstantiationException instantiationException) {
                throw new ZipException(instantiationException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ZipException(illegalAccessException.getMessage());
            }
        }
        if (n2 != byArray.length) {
            throw new ZipException(new StringBuffer().append("data starting at ").append(n2).append(" is in unknown format").toString());
        }
        objectArray = new ZipExtraField[vector2.size()];
        vector2.copyInto(objectArray);
        return objectArray;
    }

    public static byte[] mergeLocalFileDataData(ZipExtraField[] zipExtraFieldArray) {
        int n2 = 4 * zipExtraFieldArray.length;
        for (int i2 = 0; i2 < zipExtraFieldArray.length; ++i2) {
            n2 += zipExtraFieldArray[i2].getLocalFileDataLength().getValue();
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (int i3 = 0; i3 < zipExtraFieldArray.length; ++i3) {
            System.arraycopy(zipExtraFieldArray[i3].getHeaderId().getBytes(), 0, byArray, n3, 2);
            System.arraycopy(zipExtraFieldArray[i3].getLocalFileDataLength().getBytes(), 0, byArray, n3 + 2, 2);
            byte[] byArray2 = zipExtraFieldArray[i3].getLocalFileDataData();
            System.arraycopy(byArray2, 0, byArray, n3 + 4, byArray2.length);
            n3 += byArray2.length + 4;
        }
        return byArray;
    }

    public static byte[] mergeCentralDirectoryData(ZipExtraField[] zipExtraFieldArray) {
        int n2 = 4 * zipExtraFieldArray.length;
        for (int i2 = 0; i2 < zipExtraFieldArray.length; ++i2) {
            n2 += zipExtraFieldArray[i2].getCentralDirectoryLength().getValue();
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (int i3 = 0; i3 < zipExtraFieldArray.length; ++i3) {
            System.arraycopy(zipExtraFieldArray[i3].getHeaderId().getBytes(), 0, byArray, n3, 2);
            System.arraycopy(zipExtraFieldArray[i3].getCentralDirectoryLength().getBytes(), 0, byArray, n3 + 2, 2);
            byte[] byArray2 = zipExtraFieldArray[i3].getCentralDirectoryData();
            System.arraycopy(byArray2, 0, byArray, n3 + 4, byArray2.length);
            n3 += byArray2.length + 4;
        }
        return byArray;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ExtraFieldUtils.register(class$org$apache$tools$zip$AsiExtraField == null ? (class$org$apache$tools$zip$AsiExtraField = ExtraFieldUtils.class$("org.apache.tools.zip.AsiExtraField")) : class$org$apache$tools$zip$AsiExtraField);
        ExtraFieldUtils.register(class$org$apache$tools$zip$JarMarker == null ? (class$org$apache$tools$zip$JarMarker = ExtraFieldUtils.class$("org.apache.tools.zip.JarMarker")) : class$org$apache$tools$zip$JarMarker);
    }
}

